/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.ats;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.ListenerList;
import org.eclipsetrader.core.ats.BarFactoryEvent;
import org.eclipsetrader.core.ats.IBarFactoryListener;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;

public class BarFactory {
    final Map<ISecurity, Set<Data>> map = new HashMap<ISecurity, Set<Data>>();
    private final Timer timer;
    private final ListenerList listeners = new ListenerList();

    public BarFactory() {
        this.timer = new Timer(true);
    }

    public void add(ISecurity security, TimeSpan timeSpan) {
        Set<Data> set = this.map.get(security);
        if (set == null) {
            set = new HashSet<Data>();
            this.map.put(security, set);
        }
        set.add(new Data(security, timeSpan));
    }

    public void addBarFactoryListener(IBarFactoryListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeBarFactoryListener(IBarFactoryListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void dispose() {
        this.timer.cancel();
        this.listeners.clear();
    }

    public void pricingUpdate(PricingEvent event) {
        Set<Data> set = this.map.get(event.getSecurity());
        if (set == null) {
            return;
        }
        PricingDelta[] pricingDeltaArray = event.getDelta();
        int n = pricingDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            PricingDelta delta = pricingDeltaArray[n2];
            if (delta.getNewValue() instanceof ITrade) {
                for (Data data : set) {
                    this.processTrade(data, (ITrade)delta.getNewValue());
                }
            }
            ++n2;
        }
    }

    private void processTrade(Data data, ITrade trade) {
        if (trade.getTime() == null) {
            return;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(trade.getTime());
        c.set(14, 0);
        if (data.dateOpen != null && data.dateClose != null) {
            Date time = c.getTime();
            if (!time.before(data.dateOpen) && time.before(data.dateClose)) {
                if (data.high == null || trade.getPrice() > data.high) {
                    data.high = trade.getPrice();
                }
                if (data.low == null || trade.getPrice() < data.low) {
                    data.low = trade.getPrice();
                }
                data.close = trade.getPrice();
                if (trade.getSize() != null) {
                    data.volume = data.volume != null ? data.volume + trade.getSize() : trade.getSize();
                }
            }
            if (!time.before(data.dateClose)) {
                this.fireBarCloseEvent(data);
            }
        }
        if (data.dateOpen == null) {
            data.dateOpen = c.getTime();
            data.open = trade.getPrice();
            data.high = trade.getPrice();
            data.low = trade.getPrice();
            data.close = trade.getPrice();
            data.volume = trade.getSize();
            c.add(12, data.timeSpan.getLength());
            data.dateClose = c.getTime();
            this.fireBarOpenEvent(data);
            this.timer.schedule((TimerTask)new BarCloseTimerTask(data), data.dateClose);
        }
    }

    private void fireBarOpenEvent(Data data) {
        BarFactoryEvent event = new BarFactoryEvent(data.security, data.timeSpan, data.dateOpen, data.open);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((IBarFactoryListener)l[i]).barOpen(event);
            ++i;
        }
    }

    private void fireBarCloseEvent(Data data) {
        BarFactoryEvent event = new BarFactoryEvent(data.security, data.timeSpan, data.dateOpen, data.open, data.high, data.low, data.close, data.volume);
        data.dateOpen = null;
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            ((IBarFactoryListener)l[i]).barClose(event);
            ++i;
        }
    }

    private class BarCloseTimerTask
    extends TimerTask {
        private final Data data;
        private final Date date;

        public BarCloseTimerTask(Data data) {
            this.data = data;
            this.date = data.dateOpen;
        }

        @Override
        public void run() {
            if (this.data.dateOpen == this.date) {
                BarFactory.this.fireBarCloseEvent(this.data);
            }
        }
    }

    class Data {
        final ISecurity security;
        final TimeSpan timeSpan;
        Date dateOpen;
        Double open;
        Double high;
        Double low;
        Double close;
        Long volume;
        Date dateClose;

        public Data(ISecurity security, TimeSpan timeSpan) {
            this.security = security;
            this.timeSpan = timeSpan;
        }
    }
}

