/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.ats;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipsetrader.core.ats.IStrategy;
import org.eclipsetrader.core.ats.ITradingSystem;
import org.eclipsetrader.core.ats.ITradingSystemContext;
import org.eclipsetrader.core.ats.ITradingSystemInstrument;
import org.eclipsetrader.core.ats.engines.EngineEvent;
import org.eclipsetrader.core.ats.engines.JavaScriptEngine;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.ats.TradingSystemInstrument;
import org.eclipsetrader.core.internal.ats.TradingSystemProperties;
import org.eclipsetrader.core.trading.IPosition;

public class TradingSystem
implements ITradingSystem {
    private final IStrategy strategy;
    private TradingSystemProperties properties;
    private final Map<ISecurity, TradingSystemInstrument> instruments = new HashMap<ISecurity, TradingSystemInstrument>();
    private JavaScriptEngine engine;
    private int status = 4;
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private final Observer observer = new Observer(){

        @Override
        public void update(Observable o, Object arg) {
            EngineEvent event = (EngineEvent)arg;
            TradingSystemInstrument instrument = (TradingSystemInstrument)TradingSystem.this.instruments.get(event.instrument);
            if (instrument == null) {
                return;
            }
            if (event.value instanceof IPosition) {
                IPosition position = (IPosition)event.value;
                instrument.setPosition(position.getQuantity() != 0L ? position : null);
            }
            if (event.value instanceof IQuote) {
                instrument.setQuote((IQuote)event.value);
            }
            if (event.value instanceof ITrade) {
                instrument.setTrade((ITrade)event.value);
            }
        }
    };
    private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!"instruments".equals(evt.getPropertyName())) {
                return;
            }
            boolean changed = false;
            ITradingSystemInstrument[] oldInstruments = TradingSystem.this.getInstruments();
            ISecurity[] security = (ISecurity[])evt.getNewValue();
            int i = 0;
            while (i < security.length) {
                if (!TradingSystem.this.instruments.containsKey(security[i])) {
                    TradingSystem.this.instruments.put(security[i], new TradingSystemInstrument(security[i]));
                    changed = true;
                }
                ++i;
            }
            HashSet<ISecurity> set = new HashSet<ISecurity>(Arrays.asList(security));
            Iterator iter = TradingSystem.this.instruments.keySet().iterator();
            while (iter.hasNext()) {
                if (set.contains(iter.next())) continue;
                iter.remove();
                changed = true;
            }
            if (changed) {
                TradingSystem.this.changeSupport.firePropertyChange("instruments", oldInstruments, TradingSystem.this.getInstruments());
            }
        }
    };

    public TradingSystem(IStrategy strategy) {
        this.strategy = strategy;
        this.properties = new TradingSystemProperties();
        ISecurity[] iSecurityArray = strategy.getInstruments();
        int n = iSecurityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISecurity security = iSecurityArray[n2];
            this.instruments.put(security, new TradingSystemInstrument(security));
            ++n2;
        }
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)strategy.getAdapter(PropertyChangeSupport.class);
        if (propertyChangeSupport != null) {
            propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void dispose() {
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.strategy.getAdapter(PropertyChangeSupport.class);
        if (propertyChangeSupport != null) {
            propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        this.changeSupport.firePropertyChange("status", this.status, this.status);
    }

    @Override
    public IStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ITradingSystemInstrument[] getInstruments() {
        ArrayList<TradingSystemInstrument> c = new ArrayList<TradingSystemInstrument>(this.instruments.values());
        return c.toArray(new ITradingSystemInstrument[c.size()]);
    }

    @Override
    public void start(ITradingSystemContext context) throws Exception {
        for (TradingSystemInstrument instrument : this.instruments.values()) {
            instrument.setQuote(null);
            instrument.setTrade(null);
        }
        IPosition[] iPositionArray = context.getAccount().getPositions();
        int n = iPositionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPosition position = iPositionArray[n2];
            TradingSystemInstrument instrument = this.instruments.get(position.getSecurity());
            if (instrument != null) {
                instrument.setPosition(position);
            }
            ++n2;
        }
        this.engine = new JavaScriptEngine(this, context);
        this.engine.addObserver(this.observer);
        this.engine.start();
    }

    @Override
    public void stop() {
        if (this.engine != null) {
            this.engine.deleteObserver(this.observer);
            this.engine.stop();
            this.engine.dispose();
            this.engine = null;
        }
        for (TradingSystemInstrument instrument : this.instruments.values()) {
            instrument.setQuote(null);
            instrument.setTrade(null);
        }
    }

    public TradingSystemProperties getProperties() {
        return this.properties;
    }

    public void setProperties(TradingSystemProperties properties) {
        this.properties = properties;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.strategy.getClass())) {
            return this.strategy;
        }
        if (adapter.isAssignableFrom(this.properties.getClass())) {
            return this.properties;
        }
        if (adapter.isAssignableFrom(this.changeSupport.getClass())) {
            return this.changeSupport;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }
}

