/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.ats;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipsetrader.core.ats.BarFactoryEvent;
import org.eclipsetrader.core.ats.IBarFactoryListener;
import org.eclipsetrader.core.ats.IStrategy;
import org.eclipsetrader.core.ats.ITradingSystemContext;
import org.eclipsetrader.core.feed.Bar;
import org.eclipsetrader.core.feed.BarOpen;
import org.eclipsetrader.core.feed.IBar;
import org.eclipsetrader.core.feed.IBarOpen;
import org.eclipsetrader.core.feed.IBook;
import org.eclipsetrader.core.feed.ILastClose;
import org.eclipsetrader.core.feed.IPricingEnvironment;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ITodayOHL;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEnvironment;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.ats.BarFactory;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketDay;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.markets.MarketPricingEnvironment;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;

public class TradingSystemContext
implements ITradingSystemContext {
    private final IMarketService marketService;
    private final IBroker broker;
    private final IAccount account;
    private final PricingEnvironment pricingEnvironment;
    private Integer backfillSize;
    private final MarketPricingEnvironment marketPricingEnvironment;
    private final BarFactory barFactory;
    private boolean needsDailyBars;
    private Log logger = LogFactory.getLog(this.getClass());
    public IBarFactoryListener barFactoryListener = new IBarFactoryListener(){

        @Override
        public void barOpen(BarFactoryEvent event) {
            BarOpen barOpen = new BarOpen(event.date, event.timeSpan, event.open);
            TradingSystemContext.this.logger.info((Object)barOpen);
            TradingSystemContext.this.pricingEnvironment.setBarOpen(event.security, barOpen);
        }

        @Override
        public void barClose(BarFactoryEvent event) {
            Bar bar = new Bar(event.date, event.timeSpan, event.open, event.high, event.low, event.close, event.volume);
            TradingSystemContext.this.logger.info((Object)bar);
            TradingSystemContext.this.pricingEnvironment.setBar(event.security, bar);
        }
    };
    private final IPricingListener pricingListener = new IPricingListener(){

        @Override
        public void pricingUpdate(PricingEvent event) {
            IMarketDay day;
            IMarket market = TradingSystemContext.this.marketService.getMarketForSecurity(event.getSecurity());
            if (market != null && (day = market.getToday()) != null && !day.isOpen()) {
                return;
            }
            PricingDelta[] pricingDeltaArray = event.getDelta();
            int n = pricingDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                PricingDelta delta = pricingDeltaArray[n2];
                if (delta.getNewValue() instanceof ITrade) {
                    TradingSystemContext.this.pricingEnvironment.setTrade(event.getSecurity(), (ITrade)delta.getNewValue());
                }
                if (delta.getNewValue() instanceof IQuote) {
                    TradingSystemContext.this.pricingEnvironment.setQuote(event.getSecurity(), (IQuote)delta.getNewValue());
                }
                if (delta.getNewValue() instanceof ITodayOHL) {
                    TradingSystemContext.this.pricingEnvironment.setTodayOHL(event.getSecurity(), (ITodayOHL)delta.getNewValue());
                }
                if (delta.getNewValue() instanceof ILastClose) {
                    TradingSystemContext.this.pricingEnvironment.setLastClose(event.getSecurity(), (ILastClose)delta.getNewValue());
                }
                if (delta.getNewValue() instanceof IBook) {
                    TradingSystemContext.this.pricingEnvironment.setBook(event.getSecurity(), (IBook)delta.getNewValue());
                }
                if (TradingSystemContext.this.needsDailyBars) {
                    Object bar;
                    if (delta.getNewValue() instanceof IBarOpen && (bar = (IBarOpen)delta.getNewValue()).getTimeSpan().getUnits() == TimeSpan.Units.Days && bar.getTimeSpan().getLength() == 1) {
                        TradingSystemContext.this.pricingEnvironment.setBarOpen(event.getSecurity(), (IBarOpen)bar);
                    }
                    if (delta.getNewValue() instanceof IBar && (bar = (IBar)delta.getNewValue()).getTimeSpan().getUnits() == TimeSpan.Units.Days && bar.getTimeSpan().getLength() == 1) {
                        TradingSystemContext.this.pricingEnvironment.setBar(event.getSecurity(), (IBar)bar);
                    }
                }
                ++n2;
            }
            TradingSystemContext.this.barFactory.pricingUpdate(event);
        }
    };

    public TradingSystemContext(IMarketService marketService, IStrategy strategy, IBroker broker, IAccount account) {
        this.marketService = marketService;
        this.broker = broker;
        this.account = account;
        this.pricingEnvironment = new PricingEnvironment();
        this.marketPricingEnvironment = new MarketPricingEnvironment(marketService);
        this.marketPricingEnvironment.addSecurities(strategy.getInstruments());
        this.marketPricingEnvironment.addPricingListener(this.pricingListener);
        this.barFactory = new BarFactory();
        ISecurity[] iSecurityArray = strategy.getInstruments();
        int n = iSecurityArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISecurity security = iSecurityArray[n2];
            TimeSpan[] timeSpanArray = strategy.getBarsTimeSpan();
            int n3 = timeSpanArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TimeSpan timeSpan = timeSpanArray[n4];
                if (timeSpan.getUnits() == TimeSpan.Units.Days && timeSpan.getLength() == 1) {
                    this.needsDailyBars = true;
                } else if (timeSpan.getUnits() == TimeSpan.Units.Minutes) {
                    this.barFactory.add(security, timeSpan);
                }
                ++n4;
            }
            ++n2;
        }
        this.barFactory.addBarFactoryListener(this.barFactoryListener);
    }

    @Override
    public IBroker getBroker() {
        return this.broker;
    }

    @Override
    public IAccount getAccount() {
        return this.account;
    }

    @Override
    public IPricingEnvironment getPricingEnvironment() {
        return this.pricingEnvironment;
    }

    @Override
    public void dispose() {
        this.barFactory.dispose();
        this.marketPricingEnvironment.dispose();
    }

    public void setInitialBackfillSize(Integer backfillSize) {
        this.backfillSize = backfillSize;
    }

    @Override
    public int getInitialBackfillSize() {
        return this.backfillSize != null ? this.backfillSize : 0;
    }
}

