/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.ats;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipsetrader.core.ats.IStrategy;
import org.eclipsetrader.core.ats.ITradingSystem;
import org.eclipsetrader.core.ats.ITradingSystemListener;
import org.eclipsetrader.core.ats.ITradingSystemService;
import org.eclipsetrader.core.ats.TradingSystemEvent;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.ats.TradingSystem;
import org.eclipsetrader.core.internal.ats.TradingSystemContext;
import org.eclipsetrader.core.internal.ats.TradingSystemProperties;
import org.eclipsetrader.core.internal.ats.repository.SettingsCollection;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.repositories.IRepositoryChangeListener;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.RepositoryChangeEvent;
import org.eclipsetrader.core.repositories.RepositoryResourceDelta;

public class TradingSystemService
implements ITradingSystemService {
    private final IRepositoryService repositoryService;
    private final IMarketService marketService;
    private final List<TradingSystem> list = new ArrayList<TradingSystem>();
    private SettingsCollection collection;
    private final ListenerList listeners = new ListenerList(1);
    private final IRepositoryChangeListener repositoryChangeListener = new IRepositoryChangeListener(){

        @Override
        public void repositoryResourceChanged(RepositoryChangeEvent event) {
            RepositoryResourceDelta[] delta = event.getDeltas();
            int i = 0;
            while (i < delta.length) {
                if (delta[i].getResource() instanceof IStrategy) {
                    IStrategy strategy = (IStrategy)delta[i].getResource();
                    if ((delta[i].getKind() & 1) != 0) {
                        TradingSystem tradingSystem = new TradingSystem(strategy);
                        TradingSystemProperties properties = TradingSystemService.this.collection.getSettingsFor(strategy);
                        if (properties != null) {
                            tradingSystem.setProperties(properties);
                        }
                        TradingSystemService.this.list.add(tradingSystem);
                        TradingSystemService.this.fireTradingSystemEvent(new TradingSystemEvent(1, tradingSystem));
                    } else if ((delta[i].getKind() & 2) != 0) {
                        for (TradingSystem tradingSystem : TradingSystemService.this.list) {
                            if (tradingSystem.getStrategy() != strategy) continue;
                            tradingSystem.stop();
                            TradingSystemService.this.list.remove(tradingSystem);
                            TradingSystemService.this.fireTradingSystemEvent(new TradingSystemEvent(2, tradingSystem));
                            break;
                        }
                    }
                }
                ++i;
            }
        }
    };

    public TradingSystemService(IRepositoryService repositoryService, IMarketService marketService) {
        this.repositoryService = repositoryService;
        this.marketService = marketService;
    }

    public void startUp() {
        IStoreObject[] iStoreObjectArray = this.repositoryService.getAllObjects();
        int n = iStoreObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStoreObject object = iStoreObjectArray[n2];
            if (object instanceof IStrategy) {
                this.list.add(new TradingSystem((IStrategy)((Object)object)));
            }
            ++n2;
        }
        this.loadSettings(CoreActivator.getDefault().getStateLocation().append("trade_systems.xml").toFile());
        this.repositoryService.addRepositoryResourceListener(this.repositoryChangeListener);
    }

    public void shutDown() {
        this.repositoryService.removeRepositoryResourceListener(this.repositoryChangeListener);
        for (TradingSystem system : this.list) {
            try {
                system.stop();
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.eclipsetrader.core", "Error stopping trading system", t);
                CoreActivator.log((IStatus)status);
            }
        }
        this.saveSettings(CoreActivator.getDefault().getStateLocation().append("trade_systems.xml").toFile());
    }

    @Override
    public ITradingSystem[] getTradeSystems() {
        return this.list.toArray(new ITradingSystem[this.list.size()]);
    }

    @Override
    public void start() {
        for (TradingSystem system : this.list) {
            TradingSystemProperties properties = system.getProperties();
            if (!properties.isAutostart()) continue;
            this.start(system);
        }
    }

    @Override
    public void stop() {
        for (TradingSystem system : this.list) {
            this.stop(system);
        }
    }

    @Override
    public void start(final ITradingSystem system) {
        ((TradingSystem)system).setStatus(1);
        Job job = new Job("Starting " + system.getStrategy().getName()){

            protected IStatus run(IProgressMonitor monitor) {
                TradingSystemProperties properties = ((TradingSystem)system).getProperties();
                TradingSystemContext context = new TradingSystemContext(TradingSystemService.this.marketService, system.getStrategy(), properties.getBroker(), properties.getAccount());
                context.setInitialBackfillSize(properties.getBackfill());
                try {
                    system.start(context);
                    ((TradingSystem)system).setStatus(2);
                }
                catch (Exception e) {
                    ((TradingSystem)system).setStatus(4);
                    return new Status(4, "org.eclipsetrader.core", "Error starting trade system", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    @Override
    public void stop(final ITradingSystem system) {
        ((TradingSystem)system).setStatus(3);
        Job job = new Job("Stopping " + system.getStrategy().getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        system.stop();
                    }
                    catch (Exception e) {
                        Status status = new Status(4, "org.eclipsetrader.core", "Error starting trade system", (Throwable)e);
                        ((TradingSystem)system).setStatus(4);
                        return status;
                    }
                }
                finally {
                    ((TradingSystem)system).setStatus(4);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    @Override
    public void addTradingSystemListener(ITradingSystemListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeTradingSystemListener(ITradingSystemListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void fireTradingSystemEvent(TradingSystemEvent event) {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((ITradingSystemListener)l[i]).tradingSystemChanged(event);
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.eclipsetrader.core", 0, "Error notifying listeners", t);
                CoreActivator.log((IStatus)status);
            }
            ++i;
        }
    }

    private void loadSettings(File file) {
        if (file.exists()) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SettingsCollection.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                unmarshaller.setEventHandler(new ValidationEventHandler(){

                    public boolean handleEvent(ValidationEvent event) {
                        Status status = new Status(2, "org.eclipsetrader.core", 0, "Error validating XML: " + event.getMessage(), null);
                        CoreActivator.log((IStatus)status);
                        return true;
                    }
                });
                this.collection = (SettingsCollection)unmarshaller.unmarshal(file);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipsetrader.core", 0, "Error loading repository", (Throwable)e);
                CoreActivator.log((IStatus)status);
            }
        }
        if (this.collection == null) {
            this.collection = new SettingsCollection();
        }
        for (TradingSystem system : this.list) {
            TradingSystemProperties properties = this.collection.getSettingsFor(system.getStrategy());
            if (properties == null) continue;
            system.setProperties(properties);
        }
    }

    private void saveSettings(File file) {
        try {
            if (file.exists()) {
                file.delete();
            }
            for (TradingSystem system : this.list) {
                this.collection.setSettingsFor(system.getStrategy(), system.getProperties());
            }
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{SettingsCollection.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
            marshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    Status status = new Status(2, "org.eclipsetrader.core", 0, "Error validating XML: " + event.getMessage(), null);
                    CoreActivator.log((IStatus)status);
                    return true;
                }
            });
            marshaller.marshal((Object)this.collection, (Writer)new FileWriter(file));
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.core", 0, "Error saving repository", (Throwable)e);
            CoreActivator.log((IStatus)status);
        }
    }
}

