/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.ats;

import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.ats.TradingSystemService;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class TradingSystemServiceFactory
implements ServiceFactory {
    private final IRepositoryService repositoryService;
    private TradingSystemService serviceInstance;

    public TradingSystemServiceFactory(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        if (this.serviceInstance == null) {
            BundleContext bundleContext = bundle.getBundleContext();
            ServiceReference marketServiceReference = bundleContext.getServiceReference(IMarketService.class);
            IMarketService marketService = (IMarketService)bundleContext.getService(marketServiceReference);
            this.serviceInstance = new TradingSystemService(this.repositoryService, marketService);
            try {
                this.serviceInstance.startUp();
            }
            catch (Exception e) {
                CoreActivator.log("Error starting market service", e);
            }
        }
        return this.serviceInstance;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    public void dispose() {
        if (this.serviceInstance != null) {
            try {
                this.serviceInstance.shutDown();
            }
            catch (Exception e) {
                CoreActivator.log("Error stopping market service", e);
            }
        }
    }
}

