/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.ats.repository;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipsetrader.core.internal.ats.TradingSystemProperties;
import org.eclipsetrader.core.internal.ats.repository.Settings;
import org.eclipsetrader.core.repositories.IStoreObject;

@XmlRootElement(name="list")
public class SettingsCollection {
    @XmlElementRef
    private List<Settings> systems = new ArrayList<Settings>();

    public void add(Settings settings) {
        this.systems.add(settings);
    }

    public TradingSystemProperties getSettingsFor(IAdaptable strategy) {
        IStoreObject storeObject = (IStoreObject)strategy.getAdapter(IStoreObject.class);
        if (storeObject == null) {
            return null;
        }
        URI uri = storeObject.getStore().toURI();
        for (Settings settings : this.systems) {
            if (!settings.getUri().equals(uri)) continue;
            return settings.getProperties();
        }
        return null;
    }

    public void setSettingsFor(IAdaptable strategy, TradingSystemProperties properties) {
        IStoreObject storeObject = (IStoreObject)strategy.getAdapter(IStoreObject.class);
        if (storeObject == null) {
            return;
        }
        URI uri = storeObject.getStore().toURI();
        Iterator<Settings> iter = this.systems.iterator();
        while (iter.hasNext()) {
            Settings settings = iter.next();
            if (!settings.getUri().equals(uri)) continue;
            iter.remove();
            break;
        }
        this.systems.add(new Settings(uri, properties));
    }
}

