/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.charts.repository;

import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.charts.repository.IChartSection;
import org.eclipsetrader.core.charts.repository.IChartTemplate;
import org.eclipsetrader.core.charts.repository.IChartVisitor;
import org.eclipsetrader.core.internal.charts.repository.ChartSection;

@XmlRootElement(name="chart")
public class ChartTemplate
implements IChartTemplate {
    @XmlElement(name="name")
    private String name;
    @XmlElement(name="section")
    @XmlJavaTypeAdapter(value=ChartSectionAdapter.class)
    private List<IChartSection> sections;

    public ChartTemplate() {
    }

    public ChartTemplate(String name) {
        this.name = name;
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @XmlTransient
    public IChartSection[] getSections() {
        return this.sections != null ? this.sections.toArray(new ChartSection[this.sections.size()]) : new ChartSection[]{};
    }

    @Override
    public void setSections(IChartSection[] sections) {
        this.sections = Arrays.asList(sections);
    }

    @Override
    public IChartSection getSectionWithName(String name) {
        for (IChartSection s : this.sections) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    @Override
    public IChartSection getSectionWithId(String id) {
        for (IChartSection s : this.sections) {
            if (!s.getId().equals(id)) continue;
            return s;
        }
        return null;
    }

    @Override
    public void accept(IChartVisitor visitor) {
        if (visitor.visit(this)) {
            IChartSection[] s = this.getSections();
            int i = 0;
            while (i < s.length) {
                s[i].accept(visitor);
                ++i;
            }
        }
    }

    public static class ChartSectionAdapter
    extends XmlAdapter<ChartSection, IChartSection> {
        public ChartSection marshal(IChartSection v) throws Exception {
            return v != null ? new ChartSection(v) : null;
        }

        public IChartSection unmarshal(ChartSection v) throws Exception {
            return v;
        }
    }
}

