/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.charts.repository;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.charts.repository.IChartVisitor;
import org.eclipsetrader.core.charts.repository.IElementSection;
import org.eclipsetrader.core.charts.repository.IParameter;
import org.eclipsetrader.core.internal.charts.repository.Parameter;

@XmlRootElement(name="element")
public class ElementSection
implements IElementSection {
    @XmlAttribute(name="id")
    private String id;
    @XmlAttribute(name="plugin-id")
    private String pluginId;
    @XmlElement(name="param")
    @XmlJavaTypeAdapter(value=ParameterAdapter.class)
    private List<IParameter> parameters;

    protected ElementSection() {
    }

    protected ElementSection(IElementSection section) {
        this.id = section.getId();
        this.pluginId = section.getPluginId();
        this.parameters = section.getParameters() != null ? Arrays.asList(section.getParameters()) : null;
    }

    public ElementSection(String pluginId) {
        this.id = UUID.randomUUID().toString();
        this.pluginId = pluginId;
    }

    public ElementSection(String id, String pluginId) {
        this.id = id;
        this.pluginId = pluginId;
    }

    @Override
    @XmlTransient
    public String getId() {
        return this.id;
    }

    @Override
    @XmlTransient
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    @XmlTransient
    public IParameter[] getParameters() {
        return this.parameters != null ? this.parameters.toArray(new IParameter[this.parameters.size()]) : new IParameter[]{};
    }

    @Override
    public void setParameters(IParameter[] parameters) {
        this.parameters = parameters != null ? Arrays.asList(parameters) : null;
    }

    @Override
    public void accept(IChartVisitor visitor) {
        visitor.visit(this);
    }

    public static class ParameterAdapter
    extends XmlAdapter<Parameter, IParameter> {
        public Parameter marshal(IParameter v) throws Exception {
            return v != null ? new Parameter(v.getName(), v.getValue()) : null;
        }

        public IParameter unmarshal(Parameter v) throws Exception {
            return v;
        }
    }
}

