/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.feed;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IConnectorOverride;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.feed.ConnectorOverride;

public class ConnectorOverrideAdapter
implements IAdapterFactory {
    private List<ConnectorOverride> list = new ArrayList<ConnectorOverride>();

    public ConnectorOverrideAdapter(File file) throws Exception {
        if (file.exists()) {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ConnectorOverride[].class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setEventHandler(new ValidationEventHandler(){

                public boolean handleEvent(ValidationEvent event) {
                    Status status = new Status(2, "org.eclipsetrader.core", 0, "Error validating XML: " + event.getMessage(), null);
                    CoreActivator.log((IStatus)status);
                    return true;
                }
            });
            JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(file), ConnectorOverride[].class);
            this.list.addAll(Arrays.asList((ConnectorOverride[])element.getValue()));
        }
    }

    public void save(File file) throws Exception {
        if (file.exists()) {
            file.delete();
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ConnectorOverride[].class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.core", 0, "Error validating XML: " + event.getMessage(), null);
                CoreActivator.getDefault().getLog().log((IStatus)status);
                return true;
            }
        });
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
        JAXBElement element = new JAXBElement(new QName("list"), ConnectorOverride[].class, (Object)this.list.toArray(new ConnectorOverride[this.list.size()]));
        marshaller.marshal((Object)element, (Writer)new FileWriter(file));
    }

    public void addOverride(ConnectorOverride override) {
        Iterator<ConnectorOverride> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (iter.next().getSecurity() != override.getSecurity()) continue;
            iter.remove();
        }
        this.list.add(override);
    }

    public void removeOverride(ConnectorOverride override) {
        Iterator<ConnectorOverride> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (iter.next().getSecurity() != override.getSecurity()) continue;
            iter.remove();
        }
    }

    public void clearOverride(ISecurity security) {
        Iterator<ConnectorOverride> iter = this.list.iterator();
        while (iter.hasNext()) {
            if (iter.next().getSecurity() != security) continue;
            iter.remove();
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof ISecurity) {
            if (adapterType.isAssignableFrom(this.getClass())) {
                return this;
            }
            if (adapterType.isAssignableFrom(ConnectorOverride.class)) {
                for (ConnectorOverride override : this.list) {
                    if (override.getSecurity() != adaptableObject) continue;
                    return override;
                }
            }
        }
        return null;
    }

    public Class[] getAdapterList() {
        return new Class[]{IConnectorOverride.class, ConnectorOverride.class, ConnectorOverrideAdapter.class};
    }

    List<ConnectorOverride> getList() {
        return this.list;
    }
}

