/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.feed;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.ILauncher;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.feed.FeedService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class FeedServiceLauncher
implements ILauncher,
IExecutableExtension {
    private String id;
    private String name;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void launch(IProgressMonitor monitor) {
        block5: {
            try {
                BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
                ServiceReference serviceReference = context.getServiceReference(FeedService.class);
                if (serviceReference == null) break block5;
                FeedService service = (FeedService)context.getService(serviceReference);
                IFeedConnector[] connector = service.getConnectors();
                int i = 0;
                while (i < connector.length) {
                    try {
                        connector[i].connect();
                    }
                    catch (Throwable e) {
                        Status status = new Status(4, "org.eclipsetrader.core", 0, "Error starting connector", e);
                        CoreActivator.log((IStatus)status);
                    }
                    ++i;
                }
                context.ungetService(serviceReference);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipsetrader.core", 0, "Error reading feed service", (Throwable)e);
                CoreActivator.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    @Override
    public void terminate(IProgressMonitor monitor) {
        block5: {
            try {
                BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
                ServiceReference serviceReference = context.getServiceReference(FeedService.class);
                if (serviceReference == null) break block5;
                FeedService service = (FeedService)context.getService(serviceReference);
                IFeedConnector[] connector = service.getConnectors();
                int i = 0;
                while (i < connector.length) {
                    try {
                        connector[i].disconnect();
                    }
                    catch (Throwable e) {
                        Status status = new Status(4, "org.eclipsetrader.core", 0, "Error starting connector", e);
                        CoreActivator.log((IStatus)status);
                    }
                    ++i;
                }
                context.ungetService(serviceReference);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipsetrader.core", 0, "Error reading feed service", (Throwable)e);
                CoreActivator.getDefault().getLog().log((IStatus)status);
            }
        }
    }
}

