/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.markets;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IConnectorListener;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.feed.IFeedService;
import org.eclipsetrader.core.feed.IFeedSubscription;
import org.eclipsetrader.core.internal.CoreActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class FeedConnectorAdapter
extends XmlAdapter<String, IFeedConnector> {
    public String marshal(IFeedConnector v) throws Exception {
        return v != null ? v.getId() : null;
    }

    public IFeedConnector unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        IFeedConnector connector = null;
        try {
            BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IFeedService.class);
            IFeedService feedService = (IFeedService)context.getService(serviceReference);
            connector = feedService.getConnector(v);
            if (connector == null) {
                connector = new FailsafeFeedConnector(v);
            }
            context.ungetService(serviceReference);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.core", 0, "Error reading feed service", (Throwable)e);
            CoreActivator.log((IStatus)status);
        }
        if (connector == null) {
            connector = new FailsafeFeedConnector(v);
        }
        return connector;
    }

    public class FailsafeFeedConnector
    implements IFeedConnector {
        private String id;

        public FailsafeFeedConnector(String id) {
            this.id = id;
        }

        @Override
        public void connect() {
        }

        @Override
        public void disconnect() {
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.id;
        }

        @Override
        public IFeedSubscription subscribe(IFeedIdentifier identifier) {
            return null;
        }

        @Override
        public void addConnectorListener(IConnectorListener listener) {
        }

        @Override
        public void removeConnectorListener(IConnectorListener listener) {
        }
    }
}

