/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.markets;

import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipsetrader.core.feed.IBackfillConnector;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.markets.MarketBackfillConnector;
import org.eclipsetrader.core.internal.markets.MarketConnector;
import org.eclipsetrader.core.internal.markets.MarketDay;
import org.eclipsetrader.core.internal.markets.MarketHoliday;
import org.eclipsetrader.core.internal.markets.MarketTime;
import org.eclipsetrader.core.internal.markets.SecurityAdapter;
import org.eclipsetrader.core.internal.markets.TimeZoneAdapter;
import org.eclipsetrader.core.internal.markets.WeekdaysAdapter;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketDay;

@XmlRootElement(name="market")
@XmlType(name="org.eclipsetrader.core.markets.Market")
public class Market
extends PlatformObject
implements IMarket {
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="timeZone")
    @XmlJavaTypeAdapter(value=TimeZoneAdapter.class)
    private TimeZone timeZone;
    @XmlAttribute(name="weekDays")
    @XmlJavaTypeAdapter(value=WeekdaysAdapter.class)
    private Set<Integer> weekDays;
    @XmlElement(name="liveFeed")
    private MarketConnector liveFeedConnector;
    @XmlElement(name="backfill")
    private MarketBackfillConnector backfillConnector;
    @XmlElement(name="intraday-backfill")
    private MarketBackfillConnector intradayBackfillConnector;
    @XmlElementWrapper(name="schedule")
    @XmlElementRef
    private SortedSet<MarketTime> schedule;
    @XmlElementWrapper(name="holidays")
    @XmlElementRef
    private SortedSet<MarketHoliday> holidays;
    @XmlElementWrapper(name="members")
    @XmlElement(name="security")
    @XmlJavaTypeAdapter(value=SecurityAdapter.class)
    private List<ISecurity> members;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected Market() {
    }

    public Market(String name, Collection<MarketTime> schedule) {
        this(name, schedule, null);
    }

    public Market(String name, Collection<MarketTime> schedule, TimeZone timeZone) {
        this.name = name;
        this.schedule = schedule != null ? new TreeSet<MarketTime>(schedule) : null;
        this.timeZone = timeZone;
    }

    @Override
    @XmlTransient
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", oldValue, this.name);
    }

    @XmlTransient
    public MarketTime[] getSchedule() {
        return this.schedule.toArray(new MarketTime[this.schedule.size()]);
    }

    public void setSchedule(MarketTime[] schedule) {
        MarketTime[] oldValue = this.schedule.toArray(new MarketTime[this.schedule.size()]);
        this.schedule = schedule != null ? new TreeSet<MarketTime>(Arrays.asList(schedule)) : null;
        this.propertyChangeSupport.firePropertyChange("schedule", oldValue, this.schedule.toArray(new MarketTime[this.schedule.size()]));
    }

    @XmlTransient
    public Integer[] getWeekDays() {
        if (this.weekDays == null) {
            return new Integer[0];
        }
        return this.weekDays.toArray(new Integer[this.weekDays.size()]);
    }

    public void setWeekDays(Integer[] weekDays) {
        Set<Integer> oldValue = this.weekDays;
        this.weekDays = new HashSet<Integer>(Arrays.asList(weekDays));
        this.propertyChangeSupport.firePropertyChange("weekdays", oldValue, this.weekDays);
    }

    @XmlTransient
    public MarketHoliday[] getHolidays() {
        if (this.holidays == null) {
            return new MarketHoliday[0];
        }
        return this.holidays.toArray(new MarketHoliday[this.holidays.size()]);
    }

    public void setHolidays(MarketHoliday[] holidays) {
        SortedSet<MarketHoliday> oldValue = this.holidays;
        this.holidays = new TreeSet<MarketHoliday>(Arrays.asList(holidays));
        this.propertyChangeSupport.firePropertyChange("holidays", oldValue, this.holidays);
    }

    @XmlTransient
    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        TimeZone oldValue = this.timeZone;
        this.timeZone = timeZone;
        this.propertyChangeSupport.firePropertyChange("timezone", oldValue, this.timeZone);
    }

    @Override
    public boolean isOpen() {
        return this.isOpen(Calendar.getInstance().getTime());
    }

    @Override
    public boolean isOpen(Date time) {
        MarketDay day = this.getMarketDayFor(time);
        return day.isOpen(time);
    }

    protected Date getCombinedDateTime(Date date, Date time) {
        Calendar normalized = Calendar.getInstance(this.timeZone != null ? this.timeZone : TimeZone.getDefault());
        Calendar refTime = Calendar.getInstance();
        refTime.setTime(date);
        normalized.set(1, refTime.get(1));
        normalized.set(2, refTime.get(2));
        normalized.set(5, refTime.get(5));
        refTime = Calendar.getInstance();
        refTime.setTime(time);
        normalized.set(11, refTime.get(11));
        normalized.set(12, refTime.get(12));
        normalized.set(13, 0);
        normalized.set(14, 0);
        return normalized.getTime();
    }

    protected String getHolidayDescriptionFor(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.set(14, 0);
        if (this.holidays != null) {
            Calendar holiday = Calendar.getInstance();
            for (MarketHoliday day : this.holidays) {
                holiday.setTime(day.getDate());
                if (calendar.get(1) != holiday.get(1) || calendar.get(2) != holiday.get(2) || calendar.get(5) != holiday.get(5)) continue;
                return day.getDescription();
            }
        }
        return null;
    }

    @Override
    public IMarketDay getToday() {
        return this.getMarketDayFor(Calendar.getInstance().getTime());
    }

    protected MarketDay getMarketDayFor(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.set(14, 0);
        if (this.holidays != null) {
            Calendar holiday = Calendar.getInstance();
            for (MarketHoliday day : this.holidays) {
                holiday.setTime(day.getDate());
                if (calendar.get(1) != holiday.get(1) || calendar.get(2) != holiday.get(2) || calendar.get(5) != holiday.get(5)) continue;
                if (day.getOpenTime() == null || day.getCloseTime() == null) {
                    return new MarketDay(null, null, day.getDescription());
                }
                return new MarketDay(this.getCombinedDateTime(day.getOpenTime(), day.getOpenTime()), this.getCombinedDateTime(day.getCloseTime(), day.getCloseTime()), day.getDescription());
            }
        }
        if (this.weekDays != null && !this.weekDays.contains(calendar.get(7))) {
            return new MarketDay(null, null, null);
        }
        if (this.schedule != null) {
            Date closeTime;
            Date openTime;
            for (MarketTime marketTime : this.schedule) {
                openTime = this.getCombinedDateTime(time, marketTime.getOpenTime());
                closeTime = this.getCombinedDateTime(time, marketTime.getCloseTime());
                if (marketTime.isExcluded(time) || !time.equals(openTime) && !time.after(openTime) || !time.before(closeTime)) continue;
                return new MarketDay(openTime, closeTime, marketTime.getDescription());
            }
            for (MarketTime marketTime : this.schedule) {
                openTime = this.getCombinedDateTime(time, marketTime.getOpenTime());
                closeTime = this.getCombinedDateTime(time, marketTime.getCloseTime());
                if (!openTime.equals(time) && !openTime.after(time)) continue;
                return new MarketDay(openTime, closeTime, null);
            }
        }
        return new MarketDay(null, null, null);
    }

    @Override
    public IMarketDay getNextDay() {
        return this.getNextMarketDayFor(Calendar.getInstance().getTime());
    }

    protected MarketDay getNextMarketDayFor(Date time) {
        Calendar calendar = Calendar.getInstance(this.timeZone != null ? this.timeZone : TimeZone.getDefault());
        calendar.setTime(time);
        calendar.set(14, 0);
        MarketDay day = this.getMarketDayFor(time);
        if (day.getOpenTime() != null && time.before(day.getOpenTime())) {
            return day;
        }
        if (this.schedule != null && this.schedule.size() != 0) {
            Calendar refTime = Calendar.getInstance();
            refTime.setTime(this.schedule.first().getOpenTime());
            calendar.set(11, refTime.get(11));
            calendar.set(12, refTime.get(12));
            calendar.set(13, 0);
            calendar.set(14, 0);
            int i = 0;
            while (i < 7) {
                calendar.add(5, 1);
                day = this.getMarketDayFor(calendar.getTime());
                if (day.isOpen(calendar.getTime())) {
                    return day;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public void addMembers(ISecurity[] securities) {
        if (this.members == null) {
            this.members = new ArrayList<ISecurity>();
        }
        ISecurity[] oldValue = this.getMembers();
        ISecurity[] iSecurityArray = securities;
        int n = securities.length;
        int n2 = 0;
        while (n2 < n) {
            ISecurity security = iSecurityArray[n2];
            if (!this.members.contains(security)) {
                this.members.add(security);
            }
            ++n2;
        }
        this.propertyChangeSupport.firePropertyChange("members", oldValue, this.getMembers());
    }

    @Override
    public void removeMembers(ISecurity[] securities) {
        if (this.members != null) {
            ISecurity[] oldValue = this.getMembers();
            this.members.removeAll(Arrays.asList(securities));
            this.propertyChangeSupport.firePropertyChange("members", oldValue, this.getMembers());
        }
    }

    @Override
    @XmlTransient
    public ISecurity[] getMembers() {
        if (this.members == null) {
            return new ISecurity[0];
        }
        return this.members.toArray(new ISecurity[this.members.size()]);
    }

    @Override
    public boolean hasMember(ISecurity security) {
        return this.members != null && this.members.contains(security);
    }

    @Override
    @XmlTransient
    public IFeedConnector getLiveFeedConnector() {
        return this.liveFeedConnector != null ? this.liveFeedConnector.getConnector() : null;
    }

    public void setLiveFeedConnector(IFeedConnector liveFeedConnector) {
        IFeedConnector oldValue = this.liveFeedConnector != null ? this.liveFeedConnector.getConnector() : null;
        this.liveFeedConnector = liveFeedConnector != null ? new MarketConnector(liveFeedConnector) : null;
        this.propertyChangeSupport.firePropertyChange("live-feed-connector", oldValue, this.liveFeedConnector != null ? this.liveFeedConnector.getConnector() : null);
    }

    @Override
    @XmlTransient
    public IBackfillConnector getBackfillConnector() {
        return this.backfillConnector != null ? this.backfillConnector.getConnector() : null;
    }

    public void setBackfillConnector(IBackfillConnector backfillConnector) {
        this.backfillConnector = backfillConnector != null ? new MarketBackfillConnector(backfillConnector) : null;
    }

    @Override
    @XmlTransient
    public IBackfillConnector getIntradayBackfillConnector() {
        return this.intradayBackfillConnector != null ? this.intradayBackfillConnector.getConnector() : null;
    }

    public void setIntradayBackfillConnector(IBackfillConnector intradayBackfillConnector) {
        this.intradayBackfillConnector = intradayBackfillConnector != null ? new MarketBackfillConnector(intradayBackfillConnector) : null;
    }

    public int hashCode() {
        return 7 * this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(PropertyChangeSupport.class)) {
            return this.propertyChangeSupport;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return super.getAdapter(adapter);
    }
}

