/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.markets;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.markets.Market;
import org.eclipsetrader.core.internal.markets.MarketList;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.markets.IMarketStatusListener;
import org.eclipsetrader.core.markets.MarketStatusEvent;
import org.osgi.framework.Bundle;

public class MarketService
extends Observable
implements IMarketService,
Runnable {
    public static final String REPOSITORY_FILE = "markets.xml";
    private static IMarketService instance;
    private List<Market> marketsList = new ArrayList<Market>();
    private ListenerList listeners = new ListenerList(1);
    private Thread thread;
    private boolean stopping = false;

    public MarketService() {
        instance = this;
    }

    public static IMarketService getInstance() {
        return instance;
    }

    public void startUp(IProgressMonitor monitor) throws Exception {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MarketList.class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.core", 0, "Error validating XML: " + event.getMessage(), null);
                CoreActivator.getDefault().getLog().log((IStatus)status);
                return true;
            }
        });
        MarketList list = null;
        File file = CoreActivator.getDefault().getStateLocation().append(REPOSITORY_FILE).toFile();
        if (file.exists()) {
            list = (MarketList)unmarshaller.unmarshal(file);
        } else {
            try {
                list = (MarketList)unmarshaller.unmarshal(FileLocator.openStream((Bundle)CoreActivator.getDefault().getBundle(), (IPath)new Path("data").append(Locale.getDefault().getLanguage()).append(REPOSITORY_FILE), (boolean)false));
            }
            catch (Exception exception) {
                list = (MarketList)unmarshaller.unmarshal(FileLocator.openStream((Bundle)CoreActivator.getDefault().getBundle(), (IPath)new Path("data").append(REPOSITORY_FILE), (boolean)false));
            }
        }
        if (list != null) {
            this.marketsList = list.getList();
            for (Market market : this.marketsList) {
                if (market.getTimeZone() == null) continue;
                market.setTimeZone(market.getTimeZone());
            }
        }
        if (this.thread == null) {
            this.stopping = false;
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown(IProgressMonitor monitor) throws Exception {
        File file;
        this.stopping = true;
        if (this.thread != null) {
            try {
                Thread thread = this.thread;
                synchronized (thread) {
                    this.thread.notify();
                }
                this.thread.join(30000L);
            }
            catch (InterruptedException e) {
                Status status = new Status(4, "org.eclipsetrader.core", 0, "Error stopping thread", (Throwable)e);
                CoreActivator.log((IStatus)status);
            }
            this.thread = null;
        }
        if ((file = CoreActivator.getDefault().getStateLocation().append(REPOSITORY_FILE).toFile()).exists()) {
            file.delete();
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MarketList.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.core", 0, "Error validating XML: " + event.getMessage(), null);
                CoreActivator.getDefault().getLog().log((IStatus)status);
                return true;
            }
        });
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
        marshaller.marshal((Object)new MarketList(this.marketsList), (Writer)new FileWriter(file));
    }

    public void addMarket(Market market) {
        this.marketsList.add(market);
        this.setChanged();
        this.notifyObservers();
    }

    public void deleteMarket(Market market) {
        this.marketsList.remove(market);
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public IMarket[] getMarkets() {
        return this.marketsList.toArray(new IMarket[this.marketsList.size()]);
    }

    @Override
    public IMarket getMarket(String name) {
        for (Market market : this.marketsList) {
            if (!market.getName().equals(name)) continue;
            return market;
        }
        return null;
    }

    @Override
    public IMarket[] getOpenMarkets() {
        ArrayList<Market> l = new ArrayList<Market>();
        for (Market market : this.marketsList) {
            if (!market.isOpen()) continue;
            l.add(market);
        }
        return l.toArray(new IMarket[l.size()]);
    }

    @Override
    public IMarket[] getOpenMarkets(Date time) {
        ArrayList<Market> l = new ArrayList<Market>();
        for (Market market : this.marketsList) {
            if (!market.isOpen(time)) continue;
            l.add(market);
        }
        return l.toArray(new IMarket[l.size()]);
    }

    @Override
    public void addMarketStatusListener(IMarketStatusListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeMarketStatusListener(IMarketStatusListener listener) {
        this.listeners.remove((Object)listener);
    }

    public boolean isRunning() {
        return this.thread != null;
    }

    protected boolean isStopping() {
        return this.stopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        statusMap = new HashMap<IMarket, Boolean>();
        messageMap = new HashMap<IMarket, String>();
        for (IMarket var3_6 : this.marketsList) {
            statusMap.put(var3_6, var3_6.isOpen());
        }
        var3_7 = this.thread;
        synchronized (var3_7) {
            while (true) {
                if (this.isStopping()) {
                    return;
                }
                var5_8 = this.marketsList.iterator();
                while (true) {
                    if (!var5_8.hasNext()) {
                        ** try [egrp 1[TRYBLOCK] [0 : 234->259)] { 
lbl17:
                        // 1 sources

                        break;
                    }
                    var4_4 = var5_8.next();
                    oldStatus = (Boolean)statusMap.get(var4_4);
                    newStatus = var4_4.isOpen();
                    oldMessage = (String)messageMap.get(var4_4);
                    newMessage = var4_4.getToday().getMessage();
                    if (oldStatus == newStatus && (newMessage == null || newMessage.equals(oldMessage)) && (oldMessage == null || oldMessage.equals(newMessage))) continue;
                    statusMap.put(var4_4, newStatus);
                    messageMap.put(var4_4, newMessage);
                    this.fireMarketStatusEvent(var4_4);
                }
                {
                    var4_5 = 60000L - System.currentTimeMillis() % 60000L;
                    this.thread.wait(var4_5);
                    continue;
                }
lbl33:
                // 1 sources

                catch (InterruptedException v0) {}
            }
        }
    }

    protected void fireMarketStatusEvent(IMarket market) {
        MarketStatusEvent event = new MarketStatusEvent(market);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            Status status;
            try {
                ((IMarketStatusListener)l[i]).marketStatusChanged(event);
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipsetrader.core", 0, "Error notifying market status update", (Throwable)e);
                CoreActivator.log((IStatus)status);
            }
            catch (LinkageError e) {
                status = new Status(4, "org.eclipsetrader.core", 0, "Error notifying market status update", (Throwable)e);
                CoreActivator.log((IStatus)status);
            }
            ++i;
        }
    }

    @Override
    public IMarket getMarketForSecurity(ISecurity security) {
        IMarket[] iMarketArray = this.getMarkets();
        int n = iMarketArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarket market = iMarketArray[n2];
            if (market.hasMember(security)) {
                return market;
            }
            ++n2;
        }
        return null;
    }
}

