/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.markets;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.eclipsetrader.core.internal.markets.MarketTimeExclude;
import org.eclipsetrader.core.internal.markets.TimeAdapter;

@XmlRootElement(name="time")
@XmlType(name="org.eclipsetrader.core.markets.MarketTime")
public class MarketTime
implements Comparable<MarketTime> {
    @XmlAttribute(name="description")
    private String description;
    @XmlAttribute(name="close")
    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    private Date closeTime;
    @XmlAttribute(name="open")
    @XmlJavaTypeAdapter(value=TimeAdapter.class)
    private Date openTime;
    @XmlElementRef
    private SortedSet<MarketTimeExclude> exclude;

    protected MarketTime() {
    }

    public MarketTime(Date openTime, Date closeTime) {
        this(openTime, closeTime, null);
    }

    public MarketTime(Date openTime, Date closeTime, String description) {
        this.openTime = openTime;
        this.closeTime = closeTime;
        this.description = description;
    }

    @XmlTransient
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlTransient
    public Date getOpenTime() {
        return this.openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    @XmlTransient
    public Date getCloseTime() {
        return this.closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    @XmlTransient
    public MarketTimeExclude[] getExclude() {
        if (this.exclude == null) {
            return new MarketTimeExclude[0];
        }
        return this.exclude.toArray(new MarketTimeExclude[this.exclude.size()]);
    }

    public void setExclude(MarketTimeExclude[] exclude) {
        this.exclude = exclude != null && exclude.length != 0 ? new TreeSet<MarketTimeExclude>(Arrays.asList(exclude)) : null;
    }

    public boolean isExcluded(Date date) {
        if (this.exclude != null) {
            Calendar day = Calendar.getInstance();
            day.setTime(date);
            day.set(11, 0);
            day.set(12, 0);
            day.set(13, 0);
            day.set(14, 0);
            date = day.getTime();
            for (MarketTimeExclude excludeDay : this.exclude) {
                if (date.equals(excludeDay.getFromDate()) || date.equals(excludeDay.getToDate())) {
                    return true;
                }
                if (!date.after(excludeDay.getFromDate()) || !date.before(excludeDay.getToDate())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(MarketTime o) {
        return this.openTime.compareTo(o.getOpenTime());
    }
}

