/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.trading;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.internal.trading.AlertElement;
import org.eclipsetrader.core.internal.trading.InstrumentElement;
import org.eclipsetrader.core.internal.trading.ParameterElement;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.markets.MarketPricingEnvironment;
import org.eclipsetrader.core.trading.AlertEvent;
import org.eclipsetrader.core.trading.IAlert;
import org.eclipsetrader.core.trading.IAlertListener;
import org.eclipsetrader.core.trading.IAlertService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class AlertService
implements IAlertService {
    MarketPricingEnvironment pricingEnvironment;
    Map<ISecurity, List<IAlert>> map = new HashMap<ISecurity, List<IAlert>>();
    Map<ISecurity, List<IAlert>> triggeredMap = new HashMap<ISecurity, List<IAlert>>();
    ListenerList listeners = new ListenerList(1);
    private IPricingListener pricingListener = new IPricingListener(){

        @Override
        public void pricingUpdate(PricingEvent event) {
            AlertService.this.doPricingUpdate(event);
        }
    };

    public void startUp() throws Exception {
        BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(IMarketService.class.getName());
        this.pricingEnvironment = new MarketPricingEnvironment((IMarketService)context.getService(serviceReference));
        context.ungetService(serviceReference);
        this.load(CoreActivator.getDefault().getStateLocation().append("alerts.xml").toFile());
        for (ISecurity instrument : this.map.keySet()) {
            this.pricingEnvironment.addSecurity(instrument);
            ITrade trade = this.pricingEnvironment.getTrade(instrument);
            IQuote quote = this.pricingEnvironment.getQuote(instrument);
            for (IAlert alert : this.map.get(instrument)) {
                alert.setInitialValues(trade, quote);
            }
        }
        this.pricingEnvironment.addPricingListener(this.pricingListener);
    }

    void load(File file) throws JAXBException {
        if (!file.exists()) {
            return;
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{InstrumentElement[].class});
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.core", 0, "Error validating XML: " + event.getMessage(), null);
                CoreActivator.log((IStatus)status);
                return true;
            }
        });
        JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(file), InstrumentElement[].class);
        if (element == null) {
            return;
        }
        InstrumentElement[] instrumentElementArray = (InstrumentElement[])element.getValue();
        int n = instrumentElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            InstrumentElement ie = instrumentElementArray[n2];
            ISecurity instrument = ie.getInstrument();
            ArrayList<IAlert> list = new ArrayList<IAlert>();
            AlertElement[] alerts = ie.getAlerts();
            int ii = 0;
            while (ii < alerts.length) {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                ParameterElement[] parameterElementArray = alerts[ii].getParameters();
                int n3 = parameterElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ParameterElement param = parameterElementArray[n4];
                    parameters.put(param.getName(), ParameterElement.convert(param));
                    ++n4;
                }
                IAlert alert = alerts[ii].getAlert();
                if (alert != null) {
                    alert.setParameters(parameters);
                    list.add(alert);
                }
                ++ii;
            }
            this.map.put(instrument, list);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doPricingUpdate(PricingEvent event) {
        List<IAlert> triggeredList;
        List<IAlert> set = this.map.get(event.getSecurity());
        if (set == null) {
            return;
        }
        ArrayList<IAlert> list = new ArrayList<IAlert>();
        Map<ISecurity, List<IAlert>> map = this.triggeredMap;
        synchronized (map) {
            triggeredList = this.triggeredMap.get(event.getSecurity());
            if (triggeredList == null) {
                triggeredList = new ArrayList<IAlert>();
                this.triggeredMap.put(event.getSecurity(), triggeredList);
            }
        }
        block3: for (IAlert alert : set) {
            if (triggeredList.contains(alert)) continue;
            PricingDelta[] pricingDeltaArray = event.getDelta();
            int n = pricingDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                PricingDelta delta = pricingDeltaArray[n2];
                if (delta.getNewValue() instanceof ITrade) {
                    alert.setTrade((ITrade)delta.getNewValue());
                    if (alert.isTriggered()) {
                        triggeredList.add(alert);
                        list.add(alert);
                        continue block3;
                    }
                }
                if (delta.getNewValue() instanceof IQuote) {
                    alert.setQuote((IQuote)delta.getNewValue());
                    if (alert.isTriggered()) {
                        triggeredList.add(alert);
                        list.add(alert);
                        continue block3;
                    }
                }
                ++n2;
            }
        }
        if (list.size() != 0) {
            ITrade trade = this.pricingEnvironment.getTrade(event.getSecurity());
            IQuote quote = this.pricingEnvironment.getQuote(event.getSecurity());
            AlertEvent alertEvent = new AlertEvent(event.getSecurity(), trade, quote, list.toArray(new IAlert[list.size()]));
            this.fireAlertTriggeredEvent(alertEvent);
        }
    }

    protected void fireAlertTriggeredEvent(AlertEvent alertEvent) {
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IAlertListener)l[i]).alertTriggered(alertEvent);
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.eclipsetrader.core", 0, "Error notifying listeners", t);
                CoreActivator.log((IStatus)status);
            }
            ++i;
        }
    }

    @Override
    public void addAlertListener(IAlertListener l) {
        this.listeners.add((Object)l);
    }

    @Override
    public void removeAlertListener(IAlertListener l) {
        this.listeners.remove((Object)l);
    }

    @Override
    public void resetTrigger(IAlert alert) {
        for (List<IAlert> triggeredList : this.triggeredMap.values()) {
            triggeredList.remove(alert);
        }
    }

    @Override
    public void resetAllTriggers() {
        this.triggeredMap.clear();
    }

    public void shutDown() throws IllegalStateException, JAXBException, IOException {
        this.pricingEnvironment.dispose();
        this.listeners.clear();
        ArrayList<InstrumentElement> list = new ArrayList<InstrumentElement>();
        for (ISecurity instrument : this.map.keySet()) {
            ArrayList<AlertElement> alertList = new ArrayList<AlertElement>();
            for (IAlert alert : this.map.get(instrument)) {
                alertList.add(new AlertElement(alert));
            }
            list.add(new InstrumentElement(instrument, alertList));
        }
        this.save(CoreActivator.getDefault().getStateLocation().append("alerts.xml").toFile(), list.toArray(new InstrumentElement[list.size()]));
    }

    void save(File file, InstrumentElement[] elements) throws JAXBException, IOException {
        if (file.exists()) {
            file.delete();
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{InstrumentElement[].class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                Status status = new Status(2, "org.eclipsetrader.core", 0, "Error validating XML: " + event.getMessage(), null);
                CoreActivator.log((IStatus)status);
                return true;
            }
        });
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", (Object)System.getProperty("file.encoding"));
        JAXBElement element = new JAXBElement(new QName("list"), InstrumentElement[].class, (Object)elements);
        marshaller.marshal((Object)element, (Writer)new FileWriter(file));
    }

    @Override
    public IAlert[] getAlerts(ISecurity instrument) {
        List<IAlert> list = this.map.get(instrument);
        if (list == null) {
            return new IAlert[0];
        }
        return list.toArray(new IAlert[list.size()]);
    }

    @Override
    public void setAlerts(ISecurity instrument, IAlert[] alerts) {
        List<IAlert> oldList;
        if (!this.map.containsKey(instrument)) {
            this.pricingEnvironment.addSecurity(instrument);
        }
        if ((oldList = this.map.get(instrument)) != null) {
            ITrade trade = this.pricingEnvironment.getTrade(instrument);
            IQuote quote = this.pricingEnvironment.getQuote(instrument);
            int i = 0;
            while (i < alerts.length) {
                if (!oldList.contains(alerts[i])) {
                    alerts[i].setInitialValues(trade, quote);
                }
                ++i;
            }
        }
        this.map.put(instrument, new ArrayList<IAlert>(Arrays.asList(alerts)));
    }

    @Override
    public IAlert[] getTriggeredAlerts(ISecurity instrument) {
        List<IAlert> list = this.triggeredMap.get(instrument);
        if (list == null) {
            return new IAlert[0];
        }
        return list.toArray(new IAlert[list.size()]);
    }

    @Override
    public boolean hasTriggeredAlerts(ISecurity instrument) {
        List<IAlert> list = this.triggeredMap.get(instrument);
        if (list == null) {
            return false;
        }
        return !list.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetTriggers(ISecurity instrument) {
        ITrade trade = this.pricingEnvironment.getTrade(instrument);
        IQuote quote = this.pricingEnvironment.getQuote(instrument);
        Map<ISecurity, List<IAlert>> map = this.triggeredMap;
        synchronized (map) {
            for (IAlert alert : this.triggeredMap.get(instrument)) {
                alert.setInitialValues(trade, quote);
            }
            this.triggeredMap.remove(instrument);
        }
        this.fireAlertTriggeredEvent(new AlertEvent(instrument, trade, quote, new IAlert[0]));
    }
}

