/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.trading;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.trading.BrokerException;
import org.eclipsetrader.core.trading.IAccount;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderChangeListener;
import org.eclipsetrader.core.trading.IOrderMonitor;
import org.eclipsetrader.core.trading.IOrderRoute;
import org.eclipsetrader.core.trading.IOrderSide;
import org.eclipsetrader.core.trading.IOrderType;
import org.eclipsetrader.core.trading.IOrderValidity;
import org.eclipsetrader.core.trading.ITradingService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class BrokerAdapter
extends XmlAdapter<String, IBroker> {
    public String marshal(IBroker v) throws Exception {
        return v != null ? v.getId() : null;
    }

    public IBroker unmarshal(String v) throws Exception {
        if (v == null) {
            return null;
        }
        IBroker connector = null;
        try {
            BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(ITradingService.class.getName());
            ITradingService tradingService = (ITradingService)context.getService(serviceReference);
            connector = tradingService.getBroker(v);
            context.ungetService(serviceReference);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.core", 0, "Error reading feed service", (Throwable)e);
            CoreActivator.log((IStatus)status);
        }
        if (connector == null) {
            Status status = new Status(2, "org.eclipsetrader.core", 0, "Failed to load broker " + v, null);
            CoreActivator.log((IStatus)status);
            return new FailsafeBroker(v);
        }
        return connector;
    }

    public class FailsafeBroker
    implements IBroker {
        private String id;

        public FailsafeBroker(String id) {
            this.id = id;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.id;
        }

        @Override
        public boolean canTrade(ISecurity security) {
            return false;
        }

        @Override
        public void connect() {
        }

        @Override
        public void disconnect() {
        }

        @Override
        public IOrderSide[] getAllowedSides() {
            return null;
        }

        @Override
        public IOrderType[] getAllowedTypes() {
            return null;
        }

        @Override
        public IOrderValidity[] getAllowedValidity() {
            return null;
        }

        @Override
        public IOrderRoute[] getAllowedRoutes() {
            return null;
        }

        @Override
        public IOrderMonitor[] getOrders() {
            return null;
        }

        @Override
        public IOrderMonitor prepareOrder(IOrder order) throws BrokerException {
            return null;
        }

        @Override
        public ISecurity getSecurityFromSymbol(String symbol) {
            return null;
        }

        @Override
        public String getSymbolFromSecurity(ISecurity security) {
            return null;
        }

        @Override
        public void addOrderChangeListener(IOrderChangeListener listener) {
        }

        @Override
        public void removeOrderChangeListener(IOrderChangeListener listener) {
        }

        @Override
        public IAccount[] getAccounts() {
            return new IAccount[0];
        }
    }
}

