/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.trading;

import java.net.URI;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.instruments.IUserProperties;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.repositories.IRepository;
import org.eclipsetrader.core.repositories.IRepositoryService;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class SecurityAdapter
extends XmlAdapter<String, ISecurity> {
    private static IRepositoryService repositoryService;

    public static void setRepositoryService(IRepositoryService service) {
        repositoryService = service;
    }

    public String marshal(ISecurity v) throws Exception {
        if (v == null) {
            return null;
        }
        IStoreObject storeObject = (IStoreObject)v.getAdapter(IStoreObject.class);
        return storeObject.getStore().toURI().toString();
    }

    public ISecurity unmarshal(String v) throws Exception {
        ISecurity security;
        Status status;
        if (v == null) {
            return null;
        }
        URI uri = new URI(v);
        if (repositoryService == null) {
            try {
                BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
                ServiceReference serviceReference = context.getServiceReference(IRepositoryService.class.getName());
                repositoryService = (IRepositoryService)context.getService(serviceReference);
                context.ungetService(serviceReference);
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipsetrader.core", 0, "Error reading repository service", (Throwable)e);
                CoreActivator.log((IStatus)status);
            }
        }
        ISecurity iSecurity = security = repositoryService != null ? repositoryService.getSecurityFromURI(uri) : null;
        if (security == null) {
            status = new Status(2, "org.eclipsetrader.core", 0, "Failed to load security " + uri.toString(), null);
            CoreActivator.log((IStatus)status);
            return new FailsafeSecurity(uri);
        }
        return security;
    }

    public class FailsafeSecurity
    implements ISecurity,
    IStoreObject,
    IStore {
        private URI uri;

        public FailsafeSecurity(URI uri) {
            this.uri = uri;
        }

        @Override
        public IFeedIdentifier getIdentifier() {
            return null;
        }

        @Override
        public String getName() {
            return this.uri.toString();
        }

        @Override
        public IUserProperties getProperties() {
            return null;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.isAssignableFrom(this.getClass())) {
                return this;
            }
            return null;
        }

        @Override
        public IStore getStore() {
            return this;
        }

        @Override
        public IStoreProperties getStoreProperties() {
            return null;
        }

        @Override
        public void setStore(IStore store) {
        }

        @Override
        public void setStoreProperties(IStoreProperties storeProperties) {
        }

        @Override
        public void delete(IProgressMonitor monitor) throws CoreException {
        }

        @Override
        public IStoreProperties fetchProperties(IProgressMonitor monitor) {
            return null;
        }

        @Override
        public IStore[] fetchChilds(IProgressMonitor monitor) {
            return null;
        }

        @Override
        public IStore createChild() {
            return null;
        }

        @Override
        public IRepository getRepository() {
            return null;
        }

        @Override
        public void putProperties(IStoreProperties properties, IProgressMonitor monitor) {
        }

        @Override
        public URI toURI() {
            return this.uri;
        }
    }
}

