/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.internal.trading;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.ILauncher;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.ITradingService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class TradingServiceLauncher
implements ILauncher,
IExecutableExtension {
    private String id;
    private String name;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute("id");
        this.name = config.getAttribute("name");
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void launch(IProgressMonitor monitor) {
        IBroker[] brokerConnector = this.getTradingService().getBrokers();
        int i = 0;
        while (i < brokerConnector.length) {
            brokerConnector[i].connect();
            ++i;
        }
    }

    @Override
    public void terminate(IProgressMonitor monitor) {
        IBroker[] brokerConnector = this.getTradingService().getBrokers();
        int i = 0;
        while (i < brokerConnector.length) {
            brokerConnector[i].disconnect();
            ++i;
        }
    }

    protected ITradingService getTradingService() {
        try {
            BundleContext context = CoreActivator.getDefault().getBundle().getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(ITradingService.class);
            ITradingService service = (ITradingService)context.getService(serviceReference);
            context.ungetService(serviceReference);
            return service;
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipsetrader.core", 0, "Error reading trading service", (Throwable)e);
            CoreActivator.log((IStatus)status);
            return null;
        }
    }
}

