/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.markets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipsetrader.core.feed.Bar;
import org.eclipsetrader.core.feed.IBar;
import org.eclipsetrader.core.feed.IBarOpen;
import org.eclipsetrader.core.feed.IBook;
import org.eclipsetrader.core.feed.IConnectorOverride;
import org.eclipsetrader.core.feed.IFeedConnector;
import org.eclipsetrader.core.feed.IFeedConnector2;
import org.eclipsetrader.core.feed.IFeedIdentifier;
import org.eclipsetrader.core.feed.IFeedSubscription;
import org.eclipsetrader.core.feed.IFeedSubscription2;
import org.eclipsetrader.core.feed.ILastClose;
import org.eclipsetrader.core.feed.IPrice;
import org.eclipsetrader.core.feed.IPricingEnvironment;
import org.eclipsetrader.core.feed.IPricingListener;
import org.eclipsetrader.core.feed.IQuote;
import org.eclipsetrader.core.feed.ISubscriptionListener;
import org.eclipsetrader.core.feed.ITodayOHL;
import org.eclipsetrader.core.feed.ITrade;
import org.eclipsetrader.core.feed.PricingDelta;
import org.eclipsetrader.core.feed.PricingEvent;
import org.eclipsetrader.core.feed.QuoteDelta;
import org.eclipsetrader.core.feed.QuoteEvent;
import org.eclipsetrader.core.feed.TimeSpan;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.internal.CoreActivator;
import org.eclipsetrader.core.markets.IMarket;
import org.eclipsetrader.core.markets.IMarketService;
import org.eclipsetrader.core.markets.IMarketStatusListener;
import org.eclipsetrader.core.markets.MarketStatusEvent;

public class MarketPricingEnvironment
implements IPricingEnvironment {
    private IMarketService marketService;
    private Map<ISecurity, PricingStatus> securitiesMap = new HashMap<ISecurity, PricingStatus>();
    private Map<IFeedIdentifier, SubscriptionStatus> identifiersMap = new HashMap<IFeedIdentifier, SubscriptionStatus>();
    private Map<IFeedIdentifier, SubscriptionStatus2> identifiersMap2 = new HashMap<IFeedIdentifier, SubscriptionStatus2>();
    private ListenerList listeners = new ListenerList(1);
    private ISubscriptionListener listener = new ISubscriptionListener(){

        @Override
        public void quoteUpdate(QuoteEvent event) {
            MarketPricingEnvironment.this.processUpdateQuotes(event.getIdentifier(), event.getDelta());
        }
    };
    private PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof IMarket) {
                MarketPricingEnvironment.this.handleMarketChanges((IMarket)evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
            if (evt.getSource() instanceof IFeedIdentifier) {
                Iterator iter = MarketPricingEnvironment.this.identifiersMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (entry.getKey() != evt.getSource()) continue;
                    iter.remove();
                    MarketPricingEnvironment.this.identifiersMap.put((IFeedIdentifier)evt.getSource(), (SubscriptionStatus)entry.getValue());
                    break;
                }
            }
        }
    };
    private IMarketStatusListener marketStatusListener = new IMarketStatusListener(){

        @Override
        public void marketStatusChanged(MarketStatusEvent event) {
            IMarket market = event.getMarket();
            market.isOpen();
        }
    };

    protected MarketPricingEnvironment() {
    }

    public MarketPricingEnvironment(IMarketService marketService) {
        this(marketService, null);
    }

    public MarketPricingEnvironment(IMarketService marketService, ISecurity[] securities) {
        this.marketService = marketService;
        marketService.addMarketStatusListener(this.marketStatusListener);
        IMarket[] iMarketArray = marketService.getMarkets();
        int n = iMarketArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarket market = iMarketArray[n2];
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)market.getAdapter(PropertyChangeSupport.class);
            if (propertyChangeSupport != null) {
                propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
            }
            ++n2;
        }
        if (securities != null) {
            this.addSecurities(securities);
        }
    }

    protected IMarket getMarketsForSecurity(ISecurity security) {
        if (this.marketService != null) {
            IMarket[] iMarketArray = this.marketService.getMarkets();
            int n = iMarketArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarket market = iMarketArray[n2];
                if (market.hasMember(security)) {
                    return market;
                }
                ++n2;
            }
        }
        return null;
    }

    public void addSecurity(ISecurity security) {
        IConnectorOverride override;
        IFeedConnector connector = this.getDefaultConnector();
        IMarket market = this.getMarketsForSecurity(security);
        if (market != null && market.getLiveFeedConnector() != null) {
            connector = market.getLiveFeedConnector();
        }
        if ((override = (IConnectorOverride)AdapterManager.getDefault().getAdapter((Object)security, IConnectorOverride.class)) != null && override.getLiveFeedConnector() != null) {
            connector = override.getLiveFeedConnector();
        }
        if (connector != null) {
            this.subscribeSecurity(security, connector);
        }
    }

    public void addSecurities(ISecurity[] securities) {
        ISecurity[] iSecurityArray = securities;
        int n = securities.length;
        int n2 = 0;
        while (n2 < n) {
            ISecurity security = iSecurityArray[n2];
            this.addSecurity(security);
            ++n2;
        }
    }

    public void addLevel2Security(ISecurity security) {
        IFeedConnector2 connector = null;
        IMarket market = this.getMarketsForSecurity(security);
        if (market != null && market.getLiveFeedConnector() instanceof IFeedConnector2) {
            connector = (IFeedConnector2)market.getLiveFeedConnector();
        }
        if (connector != null) {
            this.subscribeSecurity2(security, connector);
        }
    }

    protected IFeedConnector getDefaultConnector() {
        if (CoreActivator.getDefault() == null) {
            return null;
        }
        return CoreActivator.getDefault().getDefaultConnector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribeSecurity(ISecurity security, IFeedConnector connector) {
        PricingStatus pricingStatus;
        IFeedIdentifier identifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
        Map<ISecurity, PricingStatus> map = this.securitiesMap;
        synchronized (map) {
            pricingStatus = this.securitiesMap.get(security);
            if (pricingStatus == null) {
                pricingStatus = new PricingStatus();
                this.securitiesMap.put(security, pricingStatus);
            }
        }
        if (identifier != null) {
            SubscriptionStatus subscriptionStatus = this.identifiersMap.get(identifier);
            if (subscriptionStatus == null) {
                subscriptionStatus = new SubscriptionStatus();
                this.identifiersMap.put(identifier, subscriptionStatus);
                PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)identifier.getAdapter(PropertyChangeSupport.class);
                if (propertyChangeSupport != null) {
                    propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
                }
            }
            subscriptionStatus.securities.add(security);
            IFeedSubscription subscription = subscriptionStatus.subscriptions.get(connector);
            if (subscription == null) {
                subscription = connector.subscribe(identifier);
                subscriptionStatus.subscriptions.put(connector, subscription);
                subscription.addSubscriptionListener(this.listener);
            }
            pricingStatus.trade = subscription.getTrade();
            if (pricingStatus.trade != null) {
                pricingStatus.deltas.add(new PricingDelta(null, pricingStatus.trade));
            }
            pricingStatus.quote = subscription.getQuote();
            if (pricingStatus.quote != null) {
                pricingStatus.deltas.add(new PricingDelta(null, pricingStatus.quote));
            }
            pricingStatus.todayOHL = subscription.getTodayOHL();
            if (pricingStatus.todayOHL != null) {
                pricingStatus.deltas.add(new PricingDelta(null, pricingStatus.todayOHL));
            }
            pricingStatus.lastClose = subscription.getLastClose();
            if (pricingStatus.lastClose != null) {
                pricingStatus.deltas.add(new PricingDelta(null, pricingStatus.lastClose));
            }
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribeSecurity2(ISecurity security, IFeedConnector2 connector) {
        IFeedIdentifier identifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
        Map<ISecurity, PricingStatus> map = this.securitiesMap;
        synchronized (map) {
            PricingStatus pricingStatus = this.securitiesMap.get(security);
            if (pricingStatus == null) {
                pricingStatus = new PricingStatus();
                this.securitiesMap.put(security, pricingStatus);
            }
        }
        if (identifier != null) {
            SubscriptionStatus2 subscriptionStatus = this.identifiersMap2.get(identifier);
            if (subscriptionStatus == null) {
                subscriptionStatus = new SubscriptionStatus2();
                this.identifiersMap2.put(identifier, subscriptionStatus);
                PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)identifier.getAdapter(PropertyChangeSupport.class);
                if (propertyChangeSupport != null) {
                    propertyChangeSupport.addPropertyChangeListener(this.propertyChangeListener);
                }
            }
            subscriptionStatus.securities.add(security);
            IFeedSubscription2 subscription = subscriptionStatus.subscriptions.get(connector);
            if (subscription == null) {
                subscription = connector.subscribeLevel2(identifier);
                subscriptionStatus.subscriptions.put(connector, subscription);
                subscription.addSubscriptionListener(this.listener);
            }
            pricingStatus.trade = subscription.getTrade();
            pricingStatus.quote = subscription.getQuote();
            pricingStatus.todayOHL = subscription.getTodayOHL();
            pricingStatus.lastClose = subscription.getLastClose();
            pricingStatus.book = subscription.getBook();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSecurity(ISecurity security) {
        SubscriptionStatus subscriptionStatus;
        IFeedIdentifier identifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
        if (identifier != null && (subscriptionStatus = this.identifiersMap.get(identifier)) != null) {
            subscriptionStatus.securities.remove(security);
            if (subscriptionStatus.securities.size() == 0) {
                for (IFeedSubscription subscription : subscriptionStatus.subscriptions.values()) {
                    subscription.removeSubscriptionListener(this.listener);
                    subscription.dispose();
                }
                this.identifiersMap.remove(identifier);
                PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)identifier.getAdapter(PropertyChangeSupport.class);
                if (propertyChangeSupport != null) {
                    propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
                }
            }
        }
        Map<ISecurity, PricingStatus> map = this.securitiesMap;
        synchronized (map) {
            if (!this.identifiersMap.containsKey(identifier) && !this.identifiersMap2.containsKey(identifier)) {
                this.securitiesMap.remove(security);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLevel2Security(ISecurity security) {
        SubscriptionStatus2 subscriptionStatus2;
        IFeedIdentifier identifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
        if (identifier != null && (subscriptionStatus2 = this.identifiersMap2.get(identifier)) != null) {
            subscriptionStatus2.securities.remove(security);
            if (subscriptionStatus2.securities.size() == 0) {
                for (IFeedSubscription2 subscription : subscriptionStatus2.subscriptions.values()) {
                    subscription.removeSubscriptionListener(this.listener);
                    subscription.dispose();
                }
                this.identifiersMap2.remove(identifier);
                PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)identifier.getAdapter(PropertyChangeSupport.class);
                if (propertyChangeSupport != null) {
                    propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
                }
            }
        }
        Map<ISecurity, PricingStatus> map = this.securitiesMap;
        synchronized (map) {
            if (!this.identifiersMap.containsKey(identifier) && !this.identifiersMap2.containsKey(identifier)) {
                this.securitiesMap.remove(security);
            }
        }
    }

    public void removeSecurities(ISecurity[] securities) {
        ISecurity[] iSecurityArray = securities;
        int n = securities.length;
        int n2 = 0;
        while (n2 < n) {
            ISecurity security = iSecurityArray[n2];
            this.removeSecurity(security);
            ++n2;
        }
    }

    protected void handleMarketChanges(IMarket market, String propertyName, Object oldValue, Object newValue) {
        if ("live-feed-connector".equals(propertyName)) {
            IFeedConnector oldConnector = (IFeedConnector)oldValue;
            IFeedConnector newConnector = (IFeedConnector)newValue;
            if (newConnector == null) {
                newConnector = this.getDefaultConnector();
            }
            ISecurity[] iSecurityArray = market.getMembers();
            int n = iSecurityArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFeedIdentifier identifier;
                ISecurity security = iSecurityArray[n2];
                if (this.securitiesMap.containsKey(security) && (identifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class)) != null) {
                    IFeedSubscription subscription;
                    SubscriptionStatus subscriptionStatus = this.identifiersMap.get(identifier);
                    if (subscriptionStatus != null && (subscription = subscriptionStatus.subscriptions.get(oldConnector)) != null) {
                        subscription.removeSubscriptionListener(this.listener);
                        subscription.dispose();
                    }
                    if (newConnector != null) {
                        subscription = newConnector.subscribe(identifier);
                        subscriptionStatus.subscriptions.put(newConnector, subscription);
                        subscription.addSubscriptionListener(this.listener);
                        PricingStatus pricingStatus = this.securitiesMap.get(security);
                        pricingStatus.deltas.add(new PricingDelta(pricingStatus.trade, subscription.getTrade()));
                        pricingStatus.deltas.add(new PricingDelta(pricingStatus.quote, subscription.getQuote()));
                        pricingStatus.deltas.add(new PricingDelta(pricingStatus.todayOHL, subscription.getTodayOHL()));
                        pricingStatus.deltas.add(new PricingDelta(pricingStatus.lastClose, subscription.getLastClose()));
                        pricingStatus.trade = subscription.getTrade();
                        pricingStatus.quote = subscription.getQuote();
                        pricingStatus.todayOHL = subscription.getTodayOHL();
                        pricingStatus.lastClose = subscription.getLastClose();
                    }
                }
                ++n2;
            }
            this.notifyListeners();
        }
    }

    @Override
    public void addPricingListener(IPricingListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removePricingListener(IPricingListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public void dispose() {
        this.marketService.removeMarketStatusListener(this.marketStatusListener);
        IMarket[] iMarketArray = this.marketService.getMarkets();
        int n = iMarketArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarket market = iMarketArray[n2];
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)market.getAdapter(PropertyChangeSupport.class);
            if (propertyChangeSupport != null) {
                propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
            }
            ++n2;
        }
        this.listeners.clear();
        for (Map.Entry<IFeedIdentifier, SubscriptionStatus> entry : this.identifiersMap.entrySet()) {
            for (IFeedSubscription subscription : entry.getValue().subscriptions.values()) {
                subscription.removeSubscriptionListener(this.listener);
                subscription.dispose();
            }
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)entry.getKey().getAdapter(PropertyChangeSupport.class);
            if (propertyChangeSupport == null) continue;
            propertyChangeSupport.removePropertyChangeListener(this.propertyChangeListener);
        }
        this.identifiersMap.clear();
        this.securitiesMap.clear();
    }

    @Override
    public ITrade getTrade(ISecurity security) {
        return this.securitiesMap.get(security) != null ? this.securitiesMap.get((Object)security).trade : null;
    }

    @Override
    public IQuote getQuote(ISecurity security) {
        return this.securitiesMap.get(security) != null ? this.securitiesMap.get((Object)security).quote : null;
    }

    @Override
    public ITodayOHL getTodayOHL(ISecurity security) {
        return this.securitiesMap.get(security) != null ? this.securitiesMap.get((Object)security).todayOHL : null;
    }

    @Override
    public ILastClose getLastClose(ISecurity security) {
        return this.securitiesMap.get(security) != null ? this.securitiesMap.get((Object)security).lastClose : null;
    }

    @Override
    public IBook getBook(ISecurity security) {
        return this.securitiesMap.get(security) != null ? this.securitiesMap.get((Object)security).book : null;
    }

    protected void processUpdateQuotes(IFeedIdentifier identifier, QuoteDelta[] delta) {
        SubscriptionStatus subscriptionStatus = this.identifiersMap.get(identifier);
        if (subscriptionStatus != null) {
            for (ISecurity security : subscriptionStatus.securities) {
                PricingStatus pricingStatus = this.securitiesMap.get(security);
                if (pricingStatus == null) continue;
                int i = 0;
                while (i < delta.length) {
                    Object oldValue;
                    if (delta[i].getNewValue() instanceof ITrade) {
                        oldValue = pricingStatus.trade;
                        pricingStatus.trade = (ITrade)delta[i].getNewValue();
                        pricingStatus.deltas.add(new PricingDelta(oldValue, delta[i].getNewValue()));
                    }
                    if (delta[i].getNewValue() instanceof IQuote) {
                        oldValue = pricingStatus.quote;
                        pricingStatus.quote = (IQuote)delta[i].getNewValue();
                        pricingStatus.deltas.add(new PricingDelta(oldValue, delta[i].getNewValue()));
                    }
                    if (delta[i].getNewValue() instanceof ITodayOHL) {
                        oldValue = pricingStatus.todayOHL;
                        pricingStatus.todayOHL = (ITodayOHL)delta[i].getNewValue();
                        pricingStatus.deltas.add(new PricingDelta(oldValue, delta[i].getNewValue()));
                    }
                    if (delta[i].getNewValue() instanceof ILastClose) {
                        oldValue = pricingStatus.lastClose;
                        pricingStatus.lastClose = (ILastClose)delta[i].getNewValue();
                        pricingStatus.deltas.add(new PricingDelta(oldValue, delta[i].getNewValue()));
                    }
                    if (delta[i].getNewValue() instanceof IBook) {
                        oldValue = pricingStatus.book;
                        pricingStatus.book = (IBook)delta[i].getNewValue();
                        pricingStatus.deltas.add(new PricingDelta(oldValue, delta[i].getNewValue()));
                    }
                    if (delta[i].getNewValue() instanceof IBarOpen) {
                        pricingStatus.todayBarOpen = (IBarOpen)delta[i].getNewValue();
                        pricingStatus.deltas.add(new PricingDelta(null, delta[i].getNewValue()));
                    }
                    if (delta[i].getNewValue() instanceof IBar) {
                        pricingStatus.todayBar = (IBar)delta[i].getNewValue();
                        pricingStatus.deltas.add(new PricingDelta(null, delta[i].getNewValue()));
                    }
                    if (delta[i].getNewValue() instanceof IPrice) {
                        pricingStatus.deltas.add(new PricingDelta(null, delta[i].getNewValue()));
                    }
                    ++i;
                }
            }
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        ISecurity[] securities;
        Object[] l = this.listeners.getListeners();
        Map<ISecurity, PricingStatus> map = this.securitiesMap;
        synchronized (map) {
            Set<ISecurity> set = this.securitiesMap.keySet();
            securities = set.toArray(new ISecurity[set.size()]);
        }
        ISecurity[] iSecurityArray = securities;
        int n = securities.length;
        int n2 = 0;
        while (n2 < n) {
            ISecurity security = iSecurityArray[n2];
            PricingStatus pricingStatus = this.securitiesMap.get(security);
            if (pricingStatus != null && pricingStatus.deltas.size() != 0) {
                PricingEvent event = new PricingEvent(security, pricingStatus.deltas.toArray(new PricingDelta[pricingStatus.deltas.size()]));
                int i = 0;
                while (i < l.length) {
                    Status status;
                    try {
                        ((IPricingListener)l[i]).pricingUpdate(event);
                    }
                    catch (Exception e) {
                        status = new Status(4, "org.eclipsetrader.core", 0, "Error running pricing environment listener", (Throwable)e);
                        CoreActivator.log((IStatus)status);
                    }
                    catch (LinkageError e) {
                        status = new Status(4, "org.eclipsetrader.core", 0, "Error running pricing environment listener", (Throwable)e);
                        CoreActivator.log((IStatus)status);
                    }
                    ++i;
                }
                pricingStatus.deltas.clear();
            }
            ++n2;
        }
    }

    PricingStatus getPricingStatus(ISecurity security) {
        return this.securitiesMap.get(security);
    }

    SubscriptionStatus getSubscriptionStatus(ISecurity security) {
        IFeedIdentifier identifier = (IFeedIdentifier)security.getAdapter(IFeedIdentifier.class);
        return identifier != null ? this.identifiersMap.get(identifier) : null;
    }

    protected void fireTodayBarCloseEvent() {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        for (ISecurity security : this.securitiesMap.keySet()) {
            Bar newValue;
            PricingStatus pricingStatus = this.securitiesMap.get(security);
            if (pricingStatus == null || pricingStatus.todayOHL == null || pricingStatus.trade == null || ((Object)(newValue = new Bar(c.getTime(), TimeSpan.days(1), pricingStatus.todayOHL.getOpen(), pricingStatus.todayOHL.getHigh(), pricingStatus.todayOHL.getLow(), pricingStatus.trade.getPrice(), pricingStatus.trade.getVolume()))).equals(pricingStatus.todayBar)) continue;
            pricingStatus.todayBar = newValue;
            System.out.println(String.format("%s: %s", security.getName(), newValue));
            pricingStatus.deltas.add(new PricingDelta(null, newValue));
        }
        this.notifyListeners();
    }

    class PricingStatus {
        ITrade trade;
        IQuote quote;
        ITodayOHL todayOHL;
        ILastClose lastClose;
        IBook book;
        IBarOpen todayBarOpen;
        IBar todayBar;
        List<PricingDelta> deltas = new ArrayList<PricingDelta>();

        PricingStatus() {
        }
    }

    class SubscriptionStatus {
        Map<IFeedConnector, IFeedSubscription> subscriptions = new HashMap<IFeedConnector, IFeedSubscription>();
        List<ISecurity> securities = new ArrayList<ISecurity>();

        SubscriptionStatus() {
        }
    }

    class SubscriptionStatus2 {
        Map<IFeedConnector2, IFeedSubscription2> subscriptions = new HashMap<IFeedConnector2, IFeedSubscription2>();
        List<ISecurity> securities = new ArrayList<ISecurity>();

        SubscriptionStatus2() {
        }
    }
}

