/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.trading;

import java.beans.PropertyChangeSupport;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipsetrader.core.trading.BrokerException;
import org.eclipsetrader.core.trading.IBroker;
import org.eclipsetrader.core.trading.IOrder;
import org.eclipsetrader.core.trading.IOrderMonitor;
import org.eclipsetrader.core.trading.IOrderMonitorListener;
import org.eclipsetrader.core.trading.IOrderStatus;
import org.eclipsetrader.core.trading.OrderMonitorEvent;

public class OrderMonitor
implements IOrderMonitor,
IAdaptable {
    private IOrder order;
    private IBroker brokerConnector;
    private String id;
    private Long filledQuantity;
    private Double averagePrice;
    private IOrderStatus status = IOrderStatus.New;
    private String message;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private ListenerList listeners = new ListenerList(1);

    public OrderMonitor(IBroker brokerConnector, IOrder order) {
        this.brokerConnector = brokerConnector;
        this.order = order;
    }

    @Override
    public IBroker getBrokerConnector() {
        return this.brokerConnector;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String assignedId) {
        this.id = assignedId;
    }

    @Override
    public IOrder getOrder() {
        return this.order;
    }

    @Override
    public void submit() throws BrokerException {
    }

    @Override
    public void cancel() throws BrokerException {
    }

    @Override
    public boolean allowModify() {
        return false;
    }

    @Override
    public void modify(IOrder order) throws BrokerException {
        throw new BrokerException("Modify not allowed");
    }

    @Override
    public void addOrderMonitorListener(IOrderMonitorListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeOrderMonitorListener(IOrderMonitorListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public IOrderStatus getStatus() {
        return this.status;
    }

    public void setStatus(IOrderStatus status) {
        IOrderStatus oldValue = this.status;
        if (this.status != status) {
            this.status = status;
            this.propertyChangeSupport.firePropertyChange("status", oldValue, this.status);
        }
    }

    @Override
    public Long getFilledQuantity() {
        return this.filledQuantity;
    }

    public void setFilledQuantity(Long filledQuantity) {
        Long oldValue = this.filledQuantity;
        if (filledQuantity != null && !filledQuantity.equals(this.filledQuantity)) {
            this.filledQuantity = filledQuantity;
            this.propertyChangeSupport.firePropertyChange("filledQuantity", oldValue, this.filledQuantity);
        }
    }

    @Override
    public Double getAveragePrice() {
        return this.averagePrice;
    }

    public void setAveragePrice(Double averagePrice) {
        Double oldValue = this.averagePrice;
        if (averagePrice != null && !averagePrice.equals(this.averagePrice)) {
            this.averagePrice = averagePrice;
            this.propertyChangeSupport.firePropertyChange("averagePrice", oldValue, this.averagePrice);
        }
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.propertyChangeSupport.getClass())) {
            return this.propertyChangeSupport;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    protected void fireOrderCompletedEvent() {
        OrderMonitorEvent event = new OrderMonitorEvent(this, this.order);
        Object[] l = this.listeners.getListeners();
        int i = 0;
        while (i < l.length) {
            try {
                ((IOrderMonitorListener)l[i]).orderCompleted(event);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    public String toString() {
        return "OrderMonitor: id=" + this.getId() + ", status=" + this.getStatus() + ", filledQuantity=" + this.getFilledQuantity() + ", averagePrice=" + this.getAveragePrice() + " [" + this.order.toString() + "]";
    }
}

