/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.views;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipsetrader.core.instruments.ISecurity;
import org.eclipsetrader.core.repositories.IStore;
import org.eclipsetrader.core.repositories.IStoreObject;
import org.eclipsetrader.core.repositories.IStoreProperties;
import org.eclipsetrader.core.repositories.StoreProperties;
import org.eclipsetrader.core.views.IColumn;
import org.eclipsetrader.core.views.IHolding;
import org.eclipsetrader.core.views.IWatchList;
import org.eclipsetrader.core.views.IWatchListColumn;
import org.eclipsetrader.core.views.IWatchListElement;
import org.eclipsetrader.core.views.IWatchListVisitor;
import org.eclipsetrader.core.views.WatchListColumn;
import org.eclipsetrader.core.views.WatchListElement;

public class WatchList
implements IWatchList,
IStoreObject {
    private String name;
    private List<IWatchListColumn> columns = new ArrayList<IWatchListColumn>();
    private List<IWatchListElement> items = new ArrayList<IWatchListElement>();
    private IStore store;
    private IStoreProperties storeProperties;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected WatchList() {
    }

    public WatchList(String name, IWatchListColumn[] columns) {
        this.name = name;
        this.setColumns(columns);
    }

    public WatchList(IStore store, IStoreProperties storeProperties) {
        this.setStore(store);
        this.setStoreProperties(storeProperties);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", oldValue, this.name);
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public IWatchListColumn[] getColumns() {
        return this.columns.toArray(new IWatchListColumn[this.columns.size()]);
    }

    public void setColumns(IWatchListColumn[] columns) {
        IWatchListColumn[] oldValue = this.columns.toArray(new IWatchListColumn[this.columns.size()]);
        this.columns = new ArrayList<IWatchListColumn>(Arrays.asList(columns));
        this.propertyChangeSupport.firePropertyChange("columns", oldValue, this.columns.toArray(new IWatchListColumn[this.columns.size()]));
    }

    @Override
    public int getItemCount() {
        return this.items.size();
    }

    @Override
    public IWatchListElement[] getItems() {
        return this.items.toArray(new IWatchListElement[this.items.size()]);
    }

    @Override
    public IWatchListElement getItem(int index) {
        if (index < 0 || index >= this.items.size()) {
            throw new IllegalArgumentException(String.valueOf(index) + " index out of range");
        }
        return this.items.get(index);
    }

    @Override
    public IWatchListElement[] getItem(ISecurity security) {
        ArrayList<IWatchListElement> list = new ArrayList<IWatchListElement>();
        for (IWatchListElement element : this.items) {
            if (element.getSecurity() != security) continue;
            list.add(element);
        }
        return list.toArray(new IWatchListElement[list.size()]);
    }

    public void setItems(IWatchListElement[] items) {
        IWatchListElement[] oldValue = this.items.toArray(new IWatchListElement[this.items.size()]);
        this.items = new ArrayList<IWatchListElement>(Arrays.asList(items));
        this.propertyChangeSupport.firePropertyChange("holdings", oldValue, this.items.toArray(new IWatchListElement[this.items.size()]));
    }

    @Override
    public void accept(IWatchListVisitor visitor) {
        if (visitor.visit(this)) {
            for (IWatchListColumn c : this.columns) {
                visitor.visit(c);
            }
            for (IWatchListElement e : this.items) {
                visitor.visit(e);
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(this.propertyChangeSupport.getClass())) {
            return this.propertyChangeSupport;
        }
        if (adapter.isAssignableFrom(IStoreProperties.class)) {
            return this.getStoreProperties();
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    @Override
    public IStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(IStore store) {
        this.store = store;
    }

    @Override
    public IStoreProperties getStoreProperties() {
        if (this.storeProperties == null) {
            this.storeProperties = new StoreProperties();
        }
        this.storeProperties.setProperty("type", IWatchList.class.getName());
        this.storeProperties.setProperty("name", this.getName());
        this.storeProperties.setProperty("columns", this.columns.toArray(new IColumn[this.columns.size()]));
        this.storeProperties.setProperty("holdings", this.items.toArray(new IHolding[this.items.size()]));
        return this.storeProperties;
    }

    @Override
    public void setStoreProperties(IStoreProperties storeProperties) {
        int n;
        this.storeProperties = storeProperties;
        this.name = (String)storeProperties.getProperty("name");
        this.columns = new ArrayList<IWatchListColumn>();
        IColumn[] columns = (IColumn[])storeProperties.getProperty("columns");
        if (columns != null) {
            IColumn[] iColumnArray = columns;
            n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                IColumn column = iColumnArray[n2];
                this.columns.add(new WatchListColumn(column));
                ++n2;
            }
        }
        this.items = new ArrayList<IWatchListElement>();
        IHolding[] holdings = (IHolding[])storeProperties.getProperty("holdings");
        if (holdings != null) {
            IHolding[] iHoldingArray = holdings;
            int n3 = holdings.length;
            n = 0;
            while (n < n3) {
                IHolding holding = iHoldingArray[n];
                this.items.add(new WatchListElement(holding));
                ++n;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public String toString() {
        return this.name;
    }
}

