/*
 * Decompiled with CFR 0.152.
 */
package org.eclipsetrader.core.views;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipsetrader.core.views.IColumn;
import org.eclipsetrader.core.views.IDataProviderFactory;
import org.eclipsetrader.core.views.IWatchListColumn;

public class WatchListColumn
implements IWatchListColumn {
    private String name;
    private IDataProviderFactory dataProviderFactory;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    protected WatchListColumn() {
    }

    public WatchListColumn(IColumn column) {
        this(column.getName(), column.getDataProviderFactory());
    }

    public WatchListColumn(String name, IDataProviderFactory dataProviderFactory) {
        this.name = name;
        this.dataProviderFactory = dataProviderFactory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("name", oldValue, this.name);
    }

    @Override
    public IDataProviderFactory getDataProviderFactory() {
        return this.dataProviderFactory;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(PropertyChangeSupport.class)) {
            return this.propertyChangeSupport;
        }
        if (adapter.isAssignableFrom(this.getClass())) {
            return this;
        }
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

