package info.dragonlady.scriptlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;

/**
 * T[oTChXNvg̏ǂݍ݁AуV_̎svsA<br>
 * t[[N̒jNX<br>
 * ScriptletNX́AKexecuteScript֐ďoKv܂B
 * @author nobu
 *
 */
public class ESEngine {
	//ǉ^O
	protected static final String serverScriptTag = "<serverscript>";
	protected static final String serverValidationTag = "<servervalidation>";
	protected static final String serverScriptEndTag = "</serverscript>";
	protected static final String serverValidationEndTag = "</servervalidation>";

	/**
	 * T[oTChXNvg̉̓NX<br>
	 * JNX̂߁Aȗ
	 * @author nobu
	 *
	 */
	private class HtmlParser {
		protected ESCylinder cylinder = null;
		protected PrintWriter writer = null;
		
		public HtmlParser(ESCylinder cyl, Scriptlet scriptlet) throws IOException {
			cylinder = cyl;
			writer = scriptlet.getResponse().getWriter();
		}
		
		public void parse(String script) throws ESException{
			int scriptIdx = script.indexOf(serverScriptTag);
			int validateIdx = script.indexOf(serverValidationTag);
			if(scriptIdx > 0 || validateIdx > 0) {
				if((scriptIdx > 0 && scriptIdx < validateIdx) || validateIdx < 0) {
					writer.write(script.substring(0, scriptIdx));
					parse(execScript(script.substring(scriptIdx+serverScriptTag.length())));
				}else
				if((validateIdx > 0 && validateIdx <  scriptIdx) || scriptIdx < 0){
					writer.write(script.substring(0, validateIdx));
					parse(execValidation(script.substring(validateIdx+serverValidationTag.length())));
				}
			}
			if(scriptIdx < 0 && validateIdx < 0) {
				writer.write(script);
			}
		}
		
		protected String execScript(String script) throws ESException{
			int scriptIdx = script.indexOf(serverScriptEndTag);
			String scriptValue = removeStartLF(script.substring(0, scriptIdx));
			cylinder.process(scriptValue);
			return script.substring(scriptIdx+serverScriptEndTag.length());
		}
		
		protected String execValidation(String script) throws ESException{
			int validateIdx = script.indexOf(serverValidationEndTag);
			String validationValue = removeStartLF(script.substring(0, validateIdx));
			cylinder.validate(validationValue);
			return script.substring(validateIdx+serverValidationEndTag.length());
		}
		
		private String removeStartLF(String value) {
			if(value.startsWith("\n")) {
				return value.substring(1);
			}
			return value;
		}
	}
	
	//T[oTChXNvgi[obt@
	private static HashMap<String, String> scriptsMap = new HashMap<String, String>();
	private static HashMap<String, Long> scriptsLastModify = new HashMap<String, Long>();
	//T[oTChXNvg̎i[pX
	private String scriptPath = "WEB-INF"+File.separator+"scriptlet"+File.separator;
	//T[oTChXNvg̃t@CK
	private static final String initSuffix = "_init.ses";
	private static final String execSuffix = "_exec.ses";
	private static final String errorSufttix = "_error.ses";
	
	private ESEngine() {
	}

	/**
	 * JNXHtmlParser𐶐֐
	 * @param cylinderFV_
	 * @param scriptletFĂяõXNvgbg
	 * @returnFHtmlParserNX̃CX^X
	 * @throws IOException
	 */
	protected final HtmlParser craeteHtmlParser(ESCylinder cylinder, Scriptlet scriptlet) throws IOException{
		return new HtmlParser(cylinder, scriptlet);
	}

	/**
	 * T[oTChXNvgǂݍފ֐
	 * @param fileFT[oTChXNvg̃t@C
	 * @returnFǂݍ񂾃T[oTChXNvg̕
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	protected final String loadScript(File file) throws FileNotFoundException, IOException {
		StringBuffer script = new StringBuffer();
		BufferedReader reader = new BufferedReader(new FileReader(file));
		String line = null;
		while((line = reader.readLine()) != null) {
			script.append(line);
			script.append("\n");
		}
		return script.toString();
	}
	
	/**
	 * ̃NX̃CX^XɈxs鏉֐
	 * @param basePathFT[oTChXNvg̊i[pX
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	protected void initialize(String basePath) throws FileNotFoundException, IOException {
		if(scriptsMap.size() < 2) {
			File scriptsDir = new File(basePath);
			if(scriptsDir.isDirectory()) {
				for(int i=0;i<scriptsDir.listFiles().length;i++) {
					//TODO
					//TufBNgΉ
					if(!scriptsDir.listFiles()[i].isDirectory()) {
						scriptsMap.put(scriptsDir.list()[i], loadScript(scriptsDir.listFiles()[i]));
						scriptsLastModify.put(scriptsDir.list()[i], scriptsDir.listFiles()[i].lastModified());
					}
				}
			}
		}
	}
	
	/**
	 * T[oTChXNvgs֐<br>
	 * ̃XNvgt@CFT[ubg_init.ses<br>
	 * s̃XNvgt@CFT[ubg_exec.ses<br>
	 * ÕXNvgt@CFT[ubg_error.ses<br>
	 * T[ubgweb.xmlɒ`ꂽurl-patternvf̒l
	 * @param scriptletFĂяõXNvgbg
	 * @throws ESException
	 */
	public static void executeScript(Scriptlet scriptlet) throws ESException{
		ESCylinder cylinder = null;
		String errorFileName = null;
		ESEngine engine = new ESEngine();
		try {
			engine.scriptPath = scriptlet.getServletContext().getRealPath("/") + engine.scriptPath;
			engine.initialize(engine.scriptPath);
			String scriptFileName = scriptlet.getRequest().getRequestURL().toString();
			scriptFileName = scriptFileName.endsWith("/") ? "index" : scriptFileName.substring(scriptFileName.lastIndexOf("/")+1);
			errorFileName = scriptFileName + errorSufttix;
			if(scriptlet.isExecute()) {
				scriptFileName += execSuffix;
			}else{
				scriptFileName += initSuffix;
			}
			
			File scriptFile = new File(engine.scriptPath+scriptFileName);
			if(scriptsLastModify.get(scriptFileName) != scriptFile.lastModified()) {
				scriptsMap.put(scriptFileName, engine.loadScript(scriptFile));
				scriptsLastModify.put(scriptFileName, scriptFile.lastModified());
			}
			
			File errorFile = new File(engine.scriptPath+errorFileName);
			if(errorFile.exists()) {
				scriptsMap.put(errorFileName, engine.loadScript(errorFile));
				scriptsLastModify.put(errorFileName, errorFile.lastModified());
			}
			
			String script = scriptsMap.get(scriptFileName);
			cylinder = ESCylinder.createInstanse(scriptlet);
			HtmlParser htmlParser = engine.craeteHtmlParser(cylinder, scriptlet);

			htmlParser.parse(script);
			scriptlet.setSequence();
		}
		catch(Exception e) {
			if(cylinder != null) {
				cylinder.exit();
			}
			exceptionProc(scriptlet, e);
		}
		finally{
			if(cylinder != null) {
				cylinder.exit();
			}
		}
	}
	
	/**
	 * G[̃XNvgs֐<br>
	 * ÕXNvgt@CFT[ubg_error.ses<br>
	 * T[ubgweb.xmlɒ`ꂽurl-patternvf̒l
	 * @param scriptletFĂяõXNvgbg
	 * @param eFXNvgɓnOIuWFNg
	 * @throws ESException
	 */
	public static void exceptionProc(Scriptlet scriptlet, Exception e) throws ESException{
		ESEngine engine = new ESEngine();
		String errorFileName = scriptlet.getRequest().getRequestURL().toString();
		errorFileName = errorFileName.endsWith("/") ? "index" : errorFileName.substring(errorFileName.lastIndexOf("/")+1);
		errorFileName = errorFileName + errorSufttix;
		ESCylinder cylinder = null;
		if(scriptsMap.containsKey(errorFileName)) {
			try {
				String script = scriptsMap.get(errorFileName);
				cylinder = ESCylinder.createInstanse(scriptlet);
				ESException ex = new ESException(e);
				ex.setInitFullURL(scriptlet.getRequest().getRequestURL().toString());
				ex.setInitURL(scriptlet.getRequest().getServletPath());
				cylinder.setException(ex);
				HtmlParser htmlParser = engine.craeteHtmlParser(cylinder, scriptlet);
				htmlParser.parse(script);
				scriptlet.setSequence();
			}
			catch(Exception ex) {
				ex.printStackTrace(System.out);
				throw new ESException(e);
			}
		}else{
			throw new ESException(e);
		}
	}
}
