package info.dragonlady.scriptlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/**
 * V[PX̑Ó؂Ajavax.servlet.http.HttpServleťpNXłB
 * ScriptletNX̊NXŁÃNX𒼐ڌp邱Ƃ͂܂B
 * @author nobu
 *
 */
abstract public class SecureServlet extends HttpServlet {

	private static final long serialVersionUID = -1783518376805871958L;
	private static final String DEFAULT_CHARSET = "Shift-jis";
	private static final String DEFAULT_CONTENT_TYPE = "text/html";
	private HttpSession session = null;
	private HttpServletRequest request = null;
	private HttpServletResponse response = null;
	protected static final String SEQUENCE_KEY = "info.dragonlady.scriptlet.SecureServlet#SEQUENCE_KEY";
	protected int sequenceId = INIT_SEQUENCE;
	public static final int INIT_SEQUENCE = 0;
	public static final int EXEC_SEQUENCE = 1;
	public static final int INVALID_SEQUENCE = 99;
	
	/**
	 * serialVersionUID鉼z֐
	 * @return
	 */
	abstract public long getSerialVersionUID();

	/**
	 * @throws IllegalAccessException
	 */
	protected void initialize() throws IllegalAccessException{
		sequenceId = verifySequence();
		if(sequenceId == INVALID_SEQUENCE) {
			//TODO
			//V[PXG[̓V[PXIuWFNg폜
			session.setAttribute(SEQUENCE_KEY, null);
			throw new IllegalAccessException("Invalid sequence detected.");
		}
	}
	
	/**
	 * {@link HttpServlet#service(javax.servlet.ServletRequest, javax.servlet.ServletResponse)}
	 */
	protected final void service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException{
		try {
			session = req.getSession();
			request = req;
			response = res;
			res.setContentType(getContentTypeValue());
			initialize();
			super.service(req, res);
		}
		catch(IllegalAccessException e) {
			//TODO
			e.printStackTrace(System.out);
			res.sendError(403, e.getMessage());
		}
		catch(IOException e) {
			//TODO
			e.printStackTrace(System.out);
			res.sendError(404, e.getMessage());
		}
		catch(ServletException e) {
			//TODO
			e.printStackTrace(System.out);
			res.sendError(404, e.getMessage());
		}
		catch(Exception e) {
			//TODO
			e.printStackTrace(System.out);
			res.sendError(404, e.getMessage());
		}
	}
	
	/**
	 * ȃV[PXŗvĂ邩؂܂B
	 * ftHgł́AԂn̔ʂs܂B
	 * V[PXgꍇAI[o[ChĎĂB
	 * @param servlet
	 * @return
	 */
	protected int verifySequence() {
		int result = INIT_SEQUENCE;
		Object sessionSeqVal = session.getAttribute(SEQUENCE_KEY);
		String pathName = request.getRequestURL().toString();
		pathName = pathName.startsWith("/") ? pathName.substring(1) : pathName;
		String svu = Long.toString(getSerialVersionUID());
		if(sessionSeqVal != null){
			if(sessionSeqVal.equals(getInitSequence())){
				result = INIT_SEQUENCE;
			}else
			if(sessionSeqVal.equals(pathName+svu)) {
				if(request.getParameterMap().isEmpty()) {
					result = INIT_SEQUENCE;
				}else{
					result = EXEC_SEQUENCE;
				}
			}else{
				result = getDefaultSequence();
			}
		}else{
			if(getInitSequence() != sessionSeqVal) {
				result = INVALID_SEQUENCE;
			}
		}
		
		return result;
	}
	
	/**
	 * ̃V[PXɈڍsہAV[PXł邽߂̃tBK[vgݒ肵܂B
	 * ftHgł́ANX{serialVersionUIDZbVɒǉB
	 * @param servlet
	 */
	protected void setSequence() {
		String pathName = request.getRequestURL().toString();
		pathName = pathName.startsWith("/") ? pathName.substring(1) : pathName;
		String svu = Long.toString(getSerialVersionUID());
		if(isExecute()) {
			session.setAttribute(SEQUENCE_KEY, getNextInitSequence());
		}else{
			session.setAttribute(SEQUENCE_KEY, pathName+svu);
		}
	}
	
	/**
	 * ݐݒ肳ĂV[PXIuWFNg擾֐
	 * @returnFV[PXIuWFNg
	 */
	protected String getSequence() {
		return session.getAttribute(SEQUENCE_KEY) == null ? null : session.getAttribute(SEQUENCE_KEY).toString();
	}
	
	/**
	 * V[PXKȂꍇ́Aݒ܂B
	 * ftHg͏ԂB
	 * .NȂT[ubg"INVALID_SEQUENCE"悤AI[o[ChKv܂B
	 * @return
	 */
	protected int getDefaultSequence() {
		return INIT_SEQUENCE;
	}

	/**
	 * [hAs[hB
	 * @return
	 */
	public boolean isExecute() {
		if(sequenceId == EXEC_SEQUENCE) {
			return true;
		}
		return false;
	}

	/**
	 * ̏V[PXiScriptletjverifySequence()ɂāA
	 * `FbN镶Ԃz֐
	 * @return
	 */
	abstract public String getNextInitSequence();
	/**
	 * V[PXiScriptletjverifySequence()ɂāA
	 * `FbN镶Ԃz֐
	 * @return
	 */
	abstract public String getInitSequence();

	/**
	 * HttpSessionNX̃CX^X܂B
	 * @returnFHttpSessionNX̃CX^X
	 */
	public HttpSession getSession() {
		return session;
	}
	
	/**
	 * HttpServletRequestNX̃CX^X܂B
	 * @returnFHttpServletRequestNX̃CX^X
	 */
	public HttpServletRequest getRequest() {
		return request;
	}
	
	/**
	 * HttpServletResponseNX̃CX^X܂B
	 * @returnFHttpServletResponseNX̃CX^X
	 */
	public HttpServletResponse getResponse() {
		return response;
	}
	
	/**
	 * HttpServletResponse#setContentTypeɎw肷A<br>
	 * CharSet̒l܂B<br>
	 * ftHgShift-jisłBύXꍇ̓I[o[Ch
	 * @returnFR[h̕iIANAj
	 */
	protected String getCharSet() {
		return DEFAULT_CHARSET;
	}
	
	/**
	 * HttpServletResponse#setContentTypeɎw肷A<br>
	 * ContentType̒l܂B<br>
	 * ftHgtext/htmlłBύXꍇ̓I[o[Ch
	 * @returnFReg^Cv̕
	 */
	protected String getContentType() {
		return DEFAULT_CONTENT_TYPE;
	}
	
	private String getContentTypeValue() {
		return getContentType() + "; charset=" + getCharSet();
	}

}
