package info.dragonlady.scriptlet.demo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import info.dragonlady.scriptlet.ESEngine;
import info.dragonlady.scriptlet.ESException;
import info.dragonlady.scriptlet.Scriptlet;

/**
 * XgƉʃXN[̃Tv
 * @author nobu
 *
 */
public class ListScrollScriptlet extends Scriptlet {

	private static final long serialVersionUID = 5807625851996996258L;
	private HashMap<String, Object> globalObjMap = new HashMap<String, Object>();
	
	private HashMap<String, Vector<String>> tableMap = new HashMap<String, Vector<String>>();
	private String sequenceObj = null;

	@Override
	public String getEScriptErrorMsg() {
		return "XNvgG[";
	}

	@Override
	public String getInvalidParamErrorMsg() {
		return "p[^G[";
	}

	@Override
	public String getInvalidValidationParamErrorMsg() {
		return "؃[G[";
	}

	@Override
	public String getRequiredParamErrorMsg() {
		return "K{p[^w";
	}

	@Override
	public Map<String, Object> getScriptNewProperties() {
		return globalObjMap;
	}

	@Override
	public String getInitSequence() {
		// TODO ꂽ\bhEX^u
		return null;
	}

	@Override
	public String getNextInitSequence() {
		return sequenceObj;
	}

	@Override
	public long getSerialVersionUID() {
		return serialVersionUID;
	}
	
	/**
	 * \[XListScroll.csṽIuWFNgNX
	 * @author nobu
	 *
	 */
	public class CsvDataObject {
		private HashMap<String, Vector<String>> csvMap = null;
		private int current = 0;
		private int left = 0;
		private int last = 0;
		private int length = 0;
		private int dis = 0;
		
		public CsvDataObject(HashMap<String, Vector<String>> map) {
			csvMap = map;
			last = csvMap.keySet().size();
		}
		
		public void setParam(int s, int len) {
			current = s;
			left = 0;
			length = s+len;
			dis = len;
		}
		
		public String nextTitle() {
			String result = null;
			if(current < last) {
				result =  csvMap.keySet().toArray()[current].toString();
				current++;
			}
			return result;
		}
		
		public boolean hasNextTitle() {
			if(current < last && current < length) {
				return true;
			}
			return false;
		}
		
		public String nextValue(String title) {
			String result = null;
			Vector<String> values = csvMap.get(title);
			if(left < values.size()) {
				result = values.get(left);
				left++;
			}
			return result;
		}
		
		public boolean hasNextValue(String title) {
			Vector<String> values = csvMap.get(title);
			if(left < values.size()) {
				return true;
			}
			left = 0;
			return false;
		}
		
		public boolean isLast() {
			if(current < last) {
				return false;
			}
			return true;
		}
		
		public boolean isTop() {
			if(current-dis > 0) {
				return false;
			}
			return true;
		}
	}

	protected void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
		try {
			//\[XListScroll.csvǂݍ݁ACsvDataObject̃CX^X𐶐
			URL propertiesResource = this.getClass().getClassLoader().getResource("/info/dragonlady/scriptlet/demo/ListScroll.csv");
			BufferedReader br = new BufferedReader(new InputStreamReader(propertiesResource.openStream()));
			String line = null;
			String key = new String();
			while((line = br.readLine()) != null) {
				Vector<String> vals = new Vector<String>();
				int i=0;
				String datas[] = line.split(",");
				for(String data : datas) {
					if(i==0) {
						key = data;
					}else{
						vals.add(data);
					}
					i++;
				}
				tableMap.put(key, vals);
			}
			CsvDataObject dataObj = new CsvDataObject(tableMap);
			globalObjMap.put("csvdatas", dataObj);
			
			//XN[Ẍׂ̃V[PXIuWFNgݒ
			if(req.getParameter("prev") != null || req.getParameter("next") != null) {
				sequenceObj = getSequence();
			}else{
				sequenceObj = null;
			}
			
			//XNvgs
			ESEngine.executeScript(this);
		}
		catch(ESException e) {
			//TODO
			e.printStackTrace(System.out);
			res.sendError(403, e.getMessage());
		}
	}
	
	protected void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
		doPost(req, res);
	}
}
