/*
 * Decompiled with CFR 0.152.
 */
package info.dragonlady.scriptlet;

import info.dragonlady.scriptlet.IllegalAccessException;
import info.dragonlady.scriptlet.Scriptlet;
import info.dragonlady.scriptlet.SystemErrorException;
import info.dragonlady.util.DBAccesser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SecureServlet
extends HttpServlet {
    private static final long serialVersionUID = -1783518376805871958L;
    private static final String DEFAULT_CHARSET = "Shift-jis";
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    private HttpSession session = null;
    private HttpServletRequest request = null;
    private HttpServletResponse response = null;
    private String SCRIPTLET_PATH = "scriptlet_path";
    private String SITEMAP_PATH = "sitemap";
    private String DBCONFIG_PATH = "dbconfig";
    private String DBOBJECT_CONTROL = "dbobject";
    private String EXT_NAME = "extendName";
    private boolean sequenceControl = true;
    protected static final String SEQUENCE_KEY = "info.dragonlady.scriptlet.SecureServlet#SEQUENCE_KEY";
    protected static final String SITEMAP_KEY = "info.dragonlady.scriptlet.SecureServlet#SITEMAP_KEY";
    protected int sequenceId = 0;
    protected String charset = "Shift-jis";
    protected String contentType = "text/html";
    protected String scriptletPath = "WEB-INF" + File.separator + "scriptlet" + File.separator;
    protected String sitemapPath = "WEB-INF" + File.separator + "sitemap.xml";
    protected String dbConfigPath = "WEB-INF" + File.separator + "db_config.xml";
    protected Document sitemapXML = null;
    protected String defaultScriptClassName = null;
    protected DBAccesser dbaccesser = null;
    protected String extendName = null;
    private Properties properties = new Properties();
    public static final int CORRECT_SEQUENCE = 0;
    public static final int CONTEXT_ACCESS_SEQUENCE = 97;
    public static final int IGNORE_SEQUENCE = 98;
    public static final int INVALID_SEQUENCE = 99;
    public static final String WILD_CARD_SEQUENCE = "*";

    protected void setupSiteMap() throws SystemErrorException {
        try {
            Element siteNode;
            DocumentBuilderFactory factory;
            File sitemapXMLFile;
            String sitemapXMLPath = String.valueOf(this.getServletContext().getRealPath("/")) + this.sitemapPath;
            if (this.properties.getProperty(this.SITEMAP_PATH) != null && this.properties.getProperty(this.SITEMAP_PATH).length() > 2) {
                sitemapXMLPath = this.properties.getProperty(this.SITEMAP_PATH);
                sitemapXMLFile = new File(sitemapXMLPath);
                if (this.sitemapXML != null && this.session.getAttribute(SITEMAP_KEY) != null) {
                    if (Long.parseLong(this.session.getAttribute(SITEMAP_KEY).toString()) != sitemapXMLFile.lastModified()) {
                        factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        this.sitemapXML = builder.parse(sitemapXMLPath);
                        this.session.setAttribute(SITEMAP_KEY, (Object)sitemapXMLFile.lastModified());
                    }
                } else {
                    factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    this.sitemapXML = builder.parse(sitemapXMLPath);
                    this.session.setAttribute(SITEMAP_KEY, (Object)sitemapXMLFile.lastModified());
                }
            } else {
                sitemapXMLFile = new File(sitemapXMLPath);
                if (this.sitemapXML != null && this.session.getAttribute(SITEMAP_KEY) != null) {
                    if (Long.parseLong(this.session.getAttribute(SITEMAP_KEY).toString()) != sitemapXMLFile.lastModified()) {
                        factory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        this.sitemapXML = builder.parse(sitemapXMLPath);
                        this.session.setAttribute(SITEMAP_KEY, (Object)sitemapXMLFile.lastModified());
                    }
                } else {
                    factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    this.sitemapXML = builder.parse(sitemapXMLPath);
                    this.session.setAttribute(SITEMAP_KEY, (Object)sitemapXMLFile.lastModified());
                }
            }
            if (this.sitemapXML == null) {
                throw new SystemErrorException("SITE-MAP XML NOT FOUND.");
            }
            NodeList siteNodes = this.sitemapXML.getElementsByTagName("site");
            if (siteNodes != null && siteNodes.getLength() > 0 && (siteNode = (Element)siteNodes.item(0)).hasAttribute("class")) {
                this.defaultScriptClassName = siteNode.getAttribute("class");
                return;
            }
            throw new SystemErrorException("'SITE' ATTRIBUTE or 'CLASS' ATTRIBUTE NOT FOUND IN SITE_MAP XML.");
        }
        catch (SystemErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SystemErrorException(e);
        }
    }

    protected void setupDBObject() throws SystemErrorException {
        try {
            if (this.useDBObject()) {
                String dbConfigXMLPath = String.valueOf(this.getServletContext().getRealPath("/")) + this.dbConfigPath;
                if (this.properties.getProperty(this.DBCONFIG_PATH) != null && this.properties.getProperty(this.DBCONFIG_PATH).length() > 2) {
                    dbConfigXMLPath = this.properties.getProperty(this.DBCONFIG_PATH);
                }
                this.dbaccesser = new DBAccesser(new FileInputStream(dbConfigXMLPath));
            }
        }
        catch (Exception e) {
            throw new SystemErrorException(e);
        }
    }

    public boolean useDBObject() {
        return this.properties.getProperty(this.DBOBJECT_CONTROL) != null && Boolean.parseBoolean(this.properties.getProperty(this.DBOBJECT_CONTROL));
    }

    public DBAccesser getDBAccessObject() {
        return this.dbaccesser;
    }

    protected void initialize() throws IllegalAccessException, SystemErrorException {
        if (this.properties.getProperty("sequence_control") != null) {
            this.sequenceControl = Boolean.parseBoolean(this.properties.getProperty("sequence_control"));
        }
        this.extendName = this.properties.getProperty(this.EXT_NAME);
        if (this.extendName == null) {
            this.extendName = new String();
        }
        this.setContentType(DEFAULT_CONTENT_TYPE);
        this.setupSiteMap();
        this.setupDBObject();
        this.sequenceId = this.verifySequence();
        if (this.sequenceId == 99) {
            this.session.setAttribute(SEQUENCE_KEY, null);
            throw new IllegalAccessException("Invalid sequence detected.");
        }
    }

    protected Scriptlet buildScriptlet() throws SystemErrorException, ClassNotFoundException, InstantiationException, java.lang.IllegalAccessException {
        String myself = this.getRelativePath();
        NodeList pageNodes = this.sitemapXML.getElementsByTagName("page");
        int i = 0;
        while (i < pageNodes.getLength()) {
            Element pageNode = (Element)pageNodes.item(i);
            if (pageNode.hasAttribute("path") && pageNode.getAttribute("path").equals(myself)) {
                Class<?> loadClass;
                Object scriptlet;
                if (pageNode.hasAttribute("class")) {
                    String className = pageNode.getAttribute("class");
                    Class<?> loadClass2 = ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
                    Object scriptlet2 = loadClass2.newInstance();
                    if (scriptlet2 instanceof Scriptlet) {
                        return (Scriptlet)scriptlet2;
                    }
                }
                if ((scriptlet = (loadClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.defaultScriptClassName)).newInstance()) instanceof Scriptlet) {
                    return (Scriptlet)scriptlet;
                }
            }
            ++i;
        }
        throw new SystemErrorException(String.format("Scriptlet not found(%s)", myself));
    }

    protected final void service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        try {
            this.session = req.getSession();
            this.request = req;
            this.response = res;
            String paramPath = String.valueOf(this.getServletContext().getRealPath("/")) + "WEB-INF" + File.separator + "config.xml";
            this.properties.loadFromXML(new FileInputStream(paramPath));
            this.initialize();
            if (this.sequenceId == 98) {
                String ignoreFilePath = String.valueOf(this.getScriptletPath()) + this.getRelativePath();
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(ignoreFilePath));
                BufferedOutputStream bos = new BufferedOutputStream((OutputStream)res.getOutputStream());
                int readLen = 0;
                byte[] readBuffer = new byte[2048];
                while ((readLen = bis.read(readBuffer)) > 0) {
                    bos.write(readBuffer, 0, readLen);
                    bos.flush();
                }
                bos.flush();
            } else if (this.sequenceId == 97) {
                res.sendRedirect(String.valueOf(this.request.getContextPath()) + "/");
            } else if (this.sequenceId == 0) {
                Scriptlet scriptlet = this.buildScriptlet();
                scriptlet.setServlet(this);
                scriptlet.start();
                res.setContentType(this.getContentTypeValue());
            } else {
                res.sendError(404, String.format("NOT FOUND PATH(%s)", this.getRelativePath()));
            }
        }
        catch (SystemErrorException e) {
            e.printStackTrace(System.out);
            res.sendError(500, e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace(System.out);
            res.sendError(403, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            res.sendError(404, e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            res.sendError(404, e.getMessage());
        }
    }

    protected boolean checkSitemap(String sessionSeqVal, String sequenceValue) {
        NodeList pageNodes = this.sitemapXML.getElementsByTagName("page");
        int i = 0;
        while (i < pageNodes.getLength()) {
            Element pageNode = (Element)pageNodes.item(i);
            if (pageNode.hasAttribute("path") && pageNode.getAttribute("path").equals(sequenceValue)) {
                Element parentNode = (Element)pageNode.getParentNode();
                if (parentNode.hasAttribute("path") && parentNode.getAttribute("path").equals(sessionSeqVal)) {
                    return true;
                }
                if (sequenceValue.equals(sessionSeqVal)) {
                    return true;
                }
                if (pageNode.hasAttribute("backward") && Boolean.parseBoolean(pageNode.getAttribute("backward"))) {
                    NodeList children = pageNode.getChildNodes();
                    int j = 0;
                    while (j < children.getLength()) {
                        Element child;
                        if (children.item(j).getNodeType() == 1 && (child = (Element)children.item(j)).hasAttribute("path") && child.getAttribute("path").equals(sessionSeqVal)) {
                            return true;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return false;
    }

    protected int verifySequence() throws IllegalAccessException {
        int result;
        int n = result = this.sequenceControl ? 99 : 0;
        if (this.request.getRequestURI().endsWith(this.request.getContextPath()) && !this.request.getRequestURI().endsWith("/")) {
            return 97;
        }
        if (this.sequenceControl) {
            Object sessionSeqVal = this.session.getAttribute(SEQUENCE_KEY);
            String sequenceValue = this.getInitSequence();
            if (sequenceValue != null && sequenceValue.equals(WILD_CARD_SEQUENCE)) {
                result = 0;
            } else if (sessionSeqVal != null) {
                if (this.checkSitemap(sessionSeqVal.toString(), sequenceValue)) {
                    result = 0;
                } else if (!sequenceValue.endsWith(this.extendName)) {
                    result = 98;
                }
            } else {
                throw new IllegalAccessException("Invalid sequece check process.");
            }
        }
        return result;
    }

    protected void setSequence() {
        this.session.setAttribute(SEQUENCE_KEY, (Object)this.getFingerprintForSequence());
    }

    protected String getSequence() {
        return this.session.getAttribute(SEQUENCE_KEY) == null ? null : this.session.getAttribute(SEQUENCE_KEY).toString();
    }

    protected String getFingerprintForSequence() {
        return this.getRelativePath();
    }

    protected String getRelativePath() {
        String contextPath;
        String path = this.request.getRequestURI();
        if (path.startsWith(contextPath = this.request.getContextPath())) {
            path = path.substring(contextPath.length());
        }
        if (path == null || path.length() < 2) {
            path = "/index" + this.getScriptExtName();
        }
        return path;
    }

    public String getInitSequence() throws IllegalAccessException {
        String myself = this.getRelativePath();
        NodeList pageNodes = this.sitemapXML.getElementsByTagName("page");
        int i = 0;
        while (i < pageNodes.getLength()) {
            Element pageNode = (Element)pageNodes.item(i);
            if (pageNode.hasAttribute("path") && pageNode.getAttribute("path").equals(myself)) {
                if (pageNode.hasAttribute("anyaccess") && Boolean.parseBoolean(pageNode.getAttribute("anyaccess"))) {
                    return WILD_CARD_SEQUENCE;
                }
                return myself;
            }
            ++i;
        }
        if (!myself.endsWith(this.extendName)) {
            return myself;
        }
        throw new IllegalAccessException("not found path on site-map(" + myself + ")");
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    protected String getCharSet() {
        return this.charset;
    }

    public void setCharSet(String code) {
        this.charset = code;
        this.response.setCharacterEncoding(this.charset);
    }

    public String getScriptletPath() {
        String path = String.valueOf(this.getServletContext().getRealPath("/")) + this.scriptletPath;
        if (this.properties.getProperty(this.SCRIPTLET_PATH) != null && this.properties.getProperty(this.SCRIPTLET_PATH).length() > 2) {
            path = this.properties.getProperty(this.SCRIPTLET_PATH);
        }
        if (path.endsWith(File.separator)) {
            path = path.substring(0, path.lastIndexOf(File.separator));
        }
        return path;
    }

    protected String getContentType() {
        return this.contentType;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    private String getContentTypeValue() {
        return String.valueOf(this.getContentType()) + "; charset=" + this.getCharSet();
    }

    public String getScriptExtName() {
        return this.extendName;
    }
}

