/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE CMP3FraunhoferWriter SOURCE CODE.        *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE CMP3FraunhoferWriter SOURCE CODE IS (C) COPYRIGHT 2008 Cocha  *
 * http://sourceforge.jp/projects/directshow/                       *
 *                                                                  *
 ********************************************************************/

#include "MP3FraunhoferWriter.h"

// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::GetInFormat(WAVEFORMATEX *pwf)
{  // ̓s̃tH[}bg擾

   CheckPointer(m_pInputPin, E_POINTER);

   if(m_pInputPin->IsConnected() == FALSE)
      return VFW_E_NOT_CONNECTED;

   return m_pInputPin->GetInFormat(pwf);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::CheckBitrate(int nOutBitrate)
{  // nOutBitratẽrbg[gŏo͂ł邩`FbN

   CheckPointer(m_pInputPin, E_POINTER);

   if(m_pInputPin->IsConnected() == FALSE)
      return VFW_E_NOT_CONNECTED;

   return m_pInputPin->CheckBitrate(nOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::CheckBitrate(WAVEFORMATEX *pInFormat, int nOutBitrate)
{  // pInFormat̓͂̏ꍇɁAnOutBitratẽrbg[gŏo͂ł邩`FbN

   CheckPointer(m_pInputPin, E_POINTER);

   return m_pInputPin->CheckBitrate(pInFormat, nOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::GetBitrate(int *pnOutBitrate)
{  // o͂̃rbg[g擾

   CheckPointer(m_pInputPin, E_POINTER);
   return m_pInputPin->GetBitrate(pnOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::SetBitrate(int nOutBitrate)
{  // o͂̃rbg[gݒ肷

   CheckPointer(m_pInputPin, E_POINTER);
   return m_pInputPin->SetBitrate(nOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::Pause()
{
   CAutoLock cObjectLock(m_pLock);

   HRESULT hr = S_OK;

   if(m_State == State_Stopped)
      hr = m_pInputPin->StartStreaming();

   if(SUCCEEDED(hr))
      hr = CBaseFilter::Pause();

   return hr;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   if(m_pInputPin != NULL)
      m_pInputPin->Stop();
    
    return CBaseFilter::Stop();
}
// -----------------------------------------------------------------------------------------------------------------------------------
int CMP3FraunhoferWriter::GetPinCount()
{  // s̐Ԃ(tB^[͓̓s1)

   if(m_pInputPin == NULL)
      return 0;

   return 1;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CBasePin *CMP3FraunhoferWriter::GetPin(int n)
{  // nԖڂ̃s̃|C^Ԃ(tB^[͓̓s1)

   if(n == 0)
      return m_pInputPin;

   return NULL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::NonDelegatingQueryInterface(REFIID riid, void ** ppv)
{  // C^[tFCX擾AQƃJEgCNg

   CheckPointer(ppv, E_POINTER);
   CAutoLock lock(&m_Lock);

   if (riid == IID_IFileSinkFilter)
   {
      return GetInterface((IFileSinkFilter *)this, ppv);
   }
   else if (riid == IID_IMediaPosition || riid == IID_IMediaSeeking)
   {
      if (m_pPosition == NULL) 
      {
         HRESULT hr = S_OK;
         m_pPosition = new CPosPassThru(NAME("MP3FraunhoferEnc Pass Through"), (IUnknown *) GetOwner(), (HRESULT *) &hr, m_pInputPin);

         if (m_pPosition == NULL) 
            return E_OUTOFMEMORY;

         if (FAILED(hr)) 
         {
            delete m_pPosition;
            m_pPosition = NULL;
            return hr;
         }
      }

      return m_pPosition->NonDelegatingQueryInterface(riid, ppv);
   } 

   return CBaseFilter::NonDelegatingQueryInterface(riid, ppv);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CMP3FraunhoferWriter::CMP3FraunhoferWriter(LPUNKNOWN pUnk, HRESULT *phr)
   : CBaseFilter(NAME("MP3FraunhoferEnc"), pUnk, &m_Lock, CLSID_MP3FraunhoferWriter) , m_pPosition(NULL)
{  // RXgN^
   ASSERT(phr);


   // ̓s̍쐬
   m_pInputPin = new CInputPin(this, GetOwner(), &m_Lock, &m_ReceiveLock, phr);
   if (m_pInputPin == NULL)
   {
      if(phr)
         *phr = E_OUTOFMEMORY;

      return;
   }

   if(phr)
      *phr = S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CMP3FraunhoferWriter::~CMP3FraunhoferWriter()
{  // fXgN^

   if(m_pPosition != NULL)
   {
      delete m_pPosition;
      m_pPosition = NULL;
   }

   // ̓s̉
   if(m_pInputPin != NULL)
   {
      delete m_pInputPin;
      m_pInputPin = NULL;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::SetFileName(LPCOLESTR pszFileName,const AM_MEDIA_TYPE *pmt)
{  // o̓t@Cݒ肷

   CheckPointer(pszFileName,E_POINTER);
   if(wcslen(pszFileName) > MAX_PATH)
      return ERROR_FILENAME_EXCED_RANGE;

   // łɃt@C݂ȂAt@C폜
   if(::PathFileExists(pszFileName) != FALSE)
   {
      if(::DeleteFile(pszFileName) == FALSE)
         return E_FAIL; // t@C폜Ɏs
   }

   // t@C쐬ł邩`FbN
   HANDLE hFile = NULL;
   hFile = ::CreateFile(pszFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);
   if(hFile == INVALID_HANDLE_VALUE)
      return E_FAIL; // t@C쐬Ɏs

   ::CloseHandle(hFile);

   // t@Ci[Ă
   lstrcpyW(m_awFileName, pszFileName);
   m_pInputPin->SetFileName(pszFileName);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CMP3FraunhoferWriter::GetCurFile(LPOLESTR * ppszFileName,AM_MEDIA_TYPE *pmt)
{  // o̓t@C擾

   CheckPointer(ppszFileName, E_POINTER);
   *ppszFileName = NULL;

   if (m_awFileName != NULL) 
   {
      *ppszFileName = (LPOLESTR)
      QzTaskMemAlloc(sizeof(WCHAR) * (1+lstrlenW(m_awFileName)));

        if (*ppszFileName != NULL) 
            lstrcpyW(*ppszFileName, m_awFileName);
   }

   if(pmt != NULL)
   {
      ZeroMemory(pmt, sizeof(*pmt));
      pmt->majortype = MEDIATYPE_NULL;
      pmt->subtype = MEDIASUBTYPE_NULL;
   }

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
