/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE ECODECOAACWRITER SOURCE CODE.           *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE ECODECOAACWRITER SOURCE CODE IS (C) COPYRIGHT 2008 Cocha     *
 *                                                                  *
 ********************************************************************/

#include "EcoDecoAacWriter.h"

// ------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::Receive(IMediaSample *pSample)
{
   BOOL flag;
   HRESULT hr;
   DWORD dwWritten;

   CheckPointer(pSample, E_POINTER);

   CAutoLock lock(m_pReceiveLock);

   REFERENCE_TIME tStart, tStop;
   pSample->GetTime(&tStart, &tStop);

   BYTE *pbData;
   hr = pSample->GetPointer(&pbData);
   if(FAILED(hr))
      return hr;

   if(m_hFile == NULL)
   {
      // t@C쐬
      m_hFile = ::CreateFile(m_awFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);

      // ADTSwb_쐬
      m_adtsHeader[0] = 0xff;
      m_adtsHeader[1] = 0xf9;
      m_adtsHeader[2] = 0x40;

      HRESULT hr;
      AM_MEDIA_TYPE am;

      hr = ConnectionMediaType(&am);
      if(hr != S_OK)
         return hr;

      WAVEFORMATEX *pwf = (WAVEFORMATEX *)am.pbFormat;

      switch(pwf->nSamplesPerSec)
      {
         case 96000: break;
         case 88200: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x01 << 2); break;
         case 64000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x02 << 2); break;
         case 48000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x03 << 2); break;
         case 44100: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x04 << 2); break;
         case 32000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x05 << 2); break;
         case 24000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x06 << 2); break;
         case 22050: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x07 << 2); break;
         case 16000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x08 << 2); break;
         case 12000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x09 << 2); break;
         case 11025: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x0a << 2); break;
         case  8000: m_adtsHeader[2] = m_adtsHeader[2] | (BYTE)(0x0b << 2); break;
      }

      m_adtsHeader[3] = 0x00;

      if(pwf->nChannels >= 4)
      {
         m_adtsHeader[2] = m_adtsHeader[2] | 0x01;
         m_adtsHeader[3] = m_adtsHeader[3] | ( (pwf->nChannels & 0x03) << 6 );
      }
      else
         m_adtsHeader[3] = ( pwf->nChannels << 6 );

      m_adtsHeader[4] = 0;
      m_adtsHeader[5] = 0x1f;
      m_adtsHeader[6] = 0xfc;
   }

   int nLength;
   nLength = pSample->GetActualDataLength() + 7;

   // ADTSwb_̏C
   m_adtsHeader[4] = (BYTE)(nLength >> 3);
   m_adtsHeader[5] = ((BYTE)(nLength & 0x07) << 5) | 0x1f; // vbr

   // ADTSwb_t@Co
   flag = ::WriteFile(m_hFile, (PVOID)m_adtsHeader, 7, &dwWritten, NULL);
   if(flag == FALSE) return S_FALSE;

   // f[^t@Co
   flag = ::WriteFile(m_hFile, (PVOID)pbData, (DWORD)pSample->GetActualDataLength(), &dwWritten, NULL);
   if(flag == FALSE) return S_FALSE;

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   if(m_hFile != NULL)
   {  // t@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CInputPin::EndOfStream(void)
{  // 󂯎f[^ȂꍇɌĂ΂

   CAutoLock lock(m_pReceiveLock);

   if(m_hFile != NULL)
   {  // t@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   return CRenderedInputPin::EndOfStream();
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::CheckMediaType(const CMediaType *pMediaType)
{  // ̓sق̃sƌqɌĂ΂

   if(*pMediaType->Subtype() == MEDIASUBTYPE_AAC)
      return S_OK;

   return VFW_E_TYPE_NOT_ACCEPTED;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::BreakConnect()
{
   if(m_pFilter->m_pPosition != NULL)
      m_pFilter->m_pPosition->ForceRefresh();

   return CRenderedInputPin::BreakConnect();
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CInputPin::SetFileName(LPCOLESTR pszFileName)
{
   // t@Ci[Ă
   lstrcpyW(m_awFileName, pszFileName);

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CInputPin::CInputPin(CEcoDecoAacWriter *pFilter, LPUNKNOWN pUnk, CCritSec *pLock, CCritSec *pReceiveLock, HRESULT *phr)
   : CRenderedInputPin(NAME("Input"), pFilter, pLock, phr, L"Input"), m_pReceiveLock(pReceiveLock), m_pFilter(pFilter)
{  // CInputPiñRXgN^

   m_hFile = NULL;
}
// ------------------------------------------------------------------------------------------------------------------------
CInputPin::~CInputPin()
{  // CInputPiñfXgN^

   if(m_hFile != NULL)
   {  // ܂t@CĂȂȂAt@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }
}
// ------------------------------------------------------------------------------------------------------------------------
