/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE ECODECOINPLACE SOURCE CODE.             *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE ECODECOINPLACE SOURCE CODE IS (C) COPYRIGHT 2008 Cocha       *
 * http://sourceforge.jp/projects/directshow/                       *
 * http://sourceforge.jp/projects/ecodecotool/                      *
 *                                                                  *
 ********************************************************************/

#include "EcoDecoInPlace.h"

// NXt@Ngpev[g
const AMOVIESETUP_MEDIATYPE sudInPinTypes[] =
{
   { &MEDIATYPE_Audio, &MEDIASUBTYPE_PCM}
};

const AMOVIESETUP_MEDIATYPE sudOutPinTypes[] =
{
   { &MEDIATYPE_Audio, &MEDIASUBTYPE_PCM}
};

const AMOVIESETUP_PIN sudPins[] =
{
{
    L"Input",               // Pin string name
    FALSE,                  // Is it rendered
    FALSE,                  // Is it an output
    FALSE,                  // Allowed none
    FALSE,                  // Likewise many
    &CLSID_NULL,            // Connects to filter
    NULL,                   // Connects to pin
    1,                      // Number of types
    sudInPinTypes           // Pin information
},
{
    L"Output",              // Pin string name
    FALSE,                  // Is it rendered
    TRUE,                   // Is it an output
    FALSE,                  // Allowed none
    FALSE,                  // Likewise many
    &CLSID_NULL,            // Connects to filter
    NULL,                   // Connects to pin
    1,                      // Number of types
    sudOutPinTypes          // Pin information
}
};

const AMOVIESETUP_FILTER filterInfo =
{
    &CLSID_EcoDecoInPlace,   // Filter CLSID
    FILTER_NAME,             // String name
    MERIT_DO_NOT_USE,        // Filter merit
    NUMELMS(sudPins),        // Number pins
    sudPins                  // Pin details
};


CFactoryTemplate g_Templates [] = {
   { FILTER_NAME, &CLSID_EcoDecoInPlace, CEcoDecoInPlace::CreateInstance, NULL, &filterInfo }
};

int g_cTemplates = sizeof(g_Templates) / sizeof(g_Templates[0]);


// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CEcoDecoInPlace::GetInFormat(WAVEFORMATEX *pwf)
{  // ̓s̃tH[}bg擾

   CheckPointer(pwf, E_POINTER);
   CheckPointer(m_pInput, E_POINTER);

   if(m_pInput->IsConnected() == FALSE)
      return VFW_E_NOT_CONNECTED;

   pwf->cbSize = m_inFormat.cbSize;
   pwf->nAvgBytesPerSec = m_inFormat.nAvgBytesPerSec;
   pwf->nBlockAlign = m_inFormat.nBlockAlign;
   pwf->nChannels = m_inFormat.nChannels;
   pwf->nSamplesPerSec = m_inFormat.nSamplesPerSec;
   pwf->wBitsPerSample = m_inFormat.wBitsPerSample;
   pwf->wFormatTag = m_inFormat.wFormatTag;

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CEcoDecoInPlace::GetTransformedBytes(LONGLONG *pllTransformedBytes)
{  // ̓s̃tH[}bg擾

   *pllTransformedBytes = m_llTransformedBytes;

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CEcoDecoInPlace::CEcoDecoInPlace(IUnknown *pUnk, HRESULT *phr) :
   CTransInPlaceFilter(FILTER_NAME, pUnk, CLSID_EcoDecoInPlace, phr, false)
{  // RXgN^

   // ϐ̏
   m_llTransformedBytes = 0;
   ::ZeroMemory(&m_inFormat, sizeof(m_inFormat));

   if(phr)
      *phr = S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CEcoDecoInPlace::~CEcoDecoInPlace()
{  // fXgN^

}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CEcoDecoInPlace::CheckInputType(const CMediaType *mtIn)
{  // ̓s󂯓邩`FbN

   CAutoLock cObjectLock(m_pLock);

   // kPCM(WAVE_FORMAT_PCM or WAVE_FORMAT_IEEE_FLOAT)ŁA߂ꂽg&rbg&`lȂ󂯓
   if(*mtIn->Subtype() == MEDIASUBTYPE_PCM || *mtIn->Subtype() == MEDIASUBTYPE_IEEE_FLOAT)
   {
      if(*mtIn->FormatType() == FORMAT_WaveFormatEx)
      {
         WAVEFORMATEX *pwf = (WAVEFORMATEX *)mtIn->pbFormat;

         // TvOg`FbN
         int i;
         int nAcceptSamplingRate[] = {8000, 11025, 12000, 16000, 22050, 24000, 32000, 44100, 48000, 88200, 96000, 176400, 192000};

         for(i=0;i<13;i++)
         {
            if(pwf->nSamplesPerSec == nAcceptSamplingRate[i])
               break;
         }

         if(i == 13)
            return S_FALSE;

         // rbg`FbN
         if(pwf->wFormatTag == WAVE_FORMAT_PCM)
         {
            if(pwf->wBitsPerSample != 8 && pwf->wBitsPerSample != 16 && pwf->wBitsPerSample != 24 && pwf->wBitsPerSample != 32)
               return S_FALSE;
         }
         else if(pwf->wFormatTag == WAVE_FORMAT_IEEE_FLOAT)
         {
            if(pwf->wBitsPerSample != 32 && pwf->wBitsPerSample != 64)
               return S_FALSE;
         }
         else
            return S_FALSE;

         // `l`FbN
         if(pwf->nChannels != 1 && pwf->nChannels != 2)
            return S_FALSE;

        // ̓tH[}bgi[Ă
        m_inFormat.cbSize = pwf->cbSize;
        m_inFormat.nAvgBytesPerSec = pwf->nAvgBytesPerSec;
        m_inFormat.nBlockAlign = pwf->nBlockAlign;
        m_inFormat.nChannels = pwf->nChannels;
        m_inFormat.nSamplesPerSec = pwf->nSamplesPerSec;
        m_inFormat.wBitsPerSample = pwf->wBitsPerSample;
        m_inFormat.wFormatTag = pwf->wFormatTag;

         return S_OK;
      }
   }

   return S_FALSE;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CEcoDecoInPlace::Transform(IMediaSample *pMediaSample)
{
   m_llTransformedBytes += (LONGLONG)pMediaSample->GetActualDataLength();

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CEcoDecoInPlace::Pause()
{
   CAutoLock cObjectLock(m_pLock);

   HRESULT hr = S_OK;

   if(m_State == State_Stopped)
      m_llTransformedBytes = 0;

   if(SUCCEEDED(hr))
      hr = CBaseFilter::Pause();

   return hr;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CEcoDecoInPlace::NonDelegatingQueryInterface(REFIID riid, void ** ppv)
{  // C^[tFCX擾AQƃJEgCNg

   CheckPointer(ppv, E_POINTER);
   CAutoLock cObjectLock(m_pLock);

   if(riid == IID_IEcoDecoInterface)
   {
      return GetInterface((IEcoDecoInterface *)this, ppv);
   }

   return CTransInPlaceFilter::NonDelegatingQueryInterface(riid, ppv);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CEcoDecoInPlace::CreateInstance(LPUNKNOWN punk, HRESULT *phr)
{  // IuWFNg쐬

   ASSERT(phr);
    
   CEcoDecoInPlace *pNewObject = new CEcoDecoInPlace(punk, phr);
   if (pNewObject == NULL)
   {
      if(phr != NULL)
         *phr = E_OUTOFMEMORY;
   }

   return dynamic_cast<CUnknown *>(pNewObject);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDAPI DllRegisterServer()
{
   return AMovieDllRegisterServer2(TRUE);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDAPI DllUnregisterServer()
{
   return AMovieDllRegisterServer2(FALSE);
}
// -----------------------------------------------------------------------------------------------------------------------------------
// DllEntryPoint
extern "C" {
	BOOL WINAPI DllEntryPoint(HINSTANCE, ULONG, LPVOID);
};

BOOL APIENTRY DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
   return DllEntryPoint((HINSTANCE)(hModule), dwReason, lpReserved);
}
