/********************************************************************
 *                                                                  *
 * THIS FILE IS PART OF THE ECODECOINPLACE SOURCE CODE.             *
 * USE, DISTRIBUTION AND REPRODUCTION OF THIS LIBRARY SOURCE IS     *
 * GOVERNED BY A BSD-STYLE SOURCE LICENSE INCLUDED WITH THIS SOURCE *
 * IN 'COPYING'. PLEASE READ THESE TERMS BEFORE DISTRIBUTING.       *
 *                                                                  *
 * THE ECODECOINPLACE SOURCE CODE IS (C) COPYRIGHT 2008 Cocha       *
 * http://sourceforge.jp/projects/directshow/                       *
 * http://sourceforge.jp/projects/ecodecotool/                      *
 *                                                                  *
 ********************************************************************/

#ifndef __EcoDecoInPlace_h__
#define __EcoDecoInPlace_h__

#include <windows.h>
#include <streams.h>

#define WAVE_FORMAT_IEEE_FLOAT 0x0003
#define SAFE_RELEASE(p) { if(p!=NULL) { (p)->Release(); (p)=NULL; } }

// tB^̖O
#define FILTER_NAME L"EcoDecoInPlace"

// {6E94D0BB-0567-4ef6-AC5D-7BF29BF117E3}
static const GUID CLSID_EcoDecoInPlace =
{ 0x6e94d0bb, 0x567, 0x4ef6, { 0xac, 0x5d, 0x7b, 0xf2, 0x9b, 0xf1, 0x17, 0xe3 } };

// {1BB79127-E01D-4f40-9257-BBC622437FB7}
static const GUID IID_IEcoDecoInterface =
{ 0x1bb79127, 0xe01d, 0x4f40, { 0x92, 0x57, 0xbb, 0xc6, 0x22, 0x43, 0x7f, 0xb7 } };

// ------------------------------------------------------------------------------------------------------------------------
// o͐ݒC^[tFCX
__interface
__declspec(uuid("{F42CA3D6-A5EB-4167-9B04-18A8B2AC7A3B}"))
IEcoDecoInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP GetTransformedBytes(LONGLONG *);
};
// ------------------------------------------------------------------------------------------------------------------------
class CEcoDecoInPlace : public CTransInPlaceFilter, public IEcoDecoInterface
{
public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CEcoDecoInPlace(LPUNKNOWN pUnk,HRESULT *phr);
   virtual ~CEcoDecoInPlace();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // CTransInPlaceFilteȑz\bh
   HRESULT CheckInputType(const CMediaType *);
   HRESULT Transform(IMediaSample *);

   // CTransInPlaceFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP Pause();

   // IEcoDecoInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP GetTransformedBytes(LONGLONG *);

private:

   // [Uϐ
   LONGLONG m_llTransformedBytes;
   WAVEFORMATEX m_inFormat;
};

// -----------------------------------------------------------------------------------------------------------------------------------
#endif __EcoDecoInPlace_h__
