/* 
 * Copyright (C) 2008 cocha,hozumi
 * http:
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 	
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "EcoDecoTooL.h"

#define TIMER_GETINPUTFILENAME 1
#define TIMER_CONVERT          2
#define TIMER_GETPERCENT       3

static CConvertDialog *g_pMyClass = NULL; 

CConvertDialog::CConvertDialog()
{
   
   g_pMyClass = this;
   m_pDirectShow = NULL;

   m_bExit = false;

   m_nCurrentNumber = 0;
   m_nErrorCount = 0;
   m_nCurrentPercent = 0;
   ::ZeroMemory(m_awCurrentOutputFileName, sizeof(m_awCurrentOutputFileName));

   m_dropFileList.clear();
   m_inputFileList.clear();

   m_pDirectShow = new CDirectShow();
}

CConvertDialog::~CConvertDialog()
{
   if(m_pDirectShow != NULL)
   {
      delete m_pDirectShow;
      m_pDirectShow = NULL;
   }
}

void CConvertDialog::AddListFromFolder(HWND hWnd, WCHAR *pwFilePath)
{  

   HANDLE handle = NULL;
   WIN32_FIND_DATA find_data;
   WCHAR szSearch[MAX_PATH], awInputFileName[MAX_PATH];

   
   if(pwFilePath[::lstrlen(pwFilePath)-1] != '\\')
      ::lstrcat(pwFilePath, TEXT("\\"));

   
   ::lstrcpy(szSearch, pwFilePath);
   ::lstrcat(szSearch,TEXT("*.*"));

   
   handle = ::FindFirstFile(szSearch, &find_data);

   if (handle == INVALID_HANDLE_VALUE)
   {
      if(handle != NULL)
         ::FindClose(handle);

      return;
   }

   do
   {
      DoEvents(hWnd);

      
      if(m_bExit == true)
      {
         ::FindClose(handle);
         return;
      }

      if(::lstrcmp(find_data.cFileName, TEXT(".")) == 0 ||
         ::lstrcmp(find_data.cFileName, TEXT("..")) == 0)
      {  
      }
      else if( (find_data.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) !=0)
      {  

         WCHAR awNextFolder[MAX_PATH];
         ::wsprintf(awNextFolder, TEXT("%s%s"), pwFilePath, find_data.cFileName);

         if(::PathIsSystemFolder(awNextFolder, 0) == FALSE)
            AddListFromFolder(hWnd, awNextFolder);
      }
      else
      {  

         ::lstrcpy(awInputFileName, pwFilePath);
         ::lstrcat(awInputFileName, find_data.cFileName);

         m_inputFileList.push_back(awInputFileName);

         if((int)m_inputFileList.size() % 10 == 0)
         {
            WCHAR awText[MAX_PATH];

            ::wsprintf(awText, TEXT("t@CJEg %d"), (int)m_inputFileList.size());
            ::SetWindowText(hWnd, awText);
            DoEvents(hWnd);
         }

      }
   } while (::FindNextFile(handle, &find_data));

   ::FindClose(handle);
}

void CConvertDialog::GetInputFileName(HWND hWnd)
{  

   int i, nSize;
   WCHAR awText[MAX_PATH];

   
   ::SetDlgItemText(hWnd, IDC_STATIC_CONVERT_FILENAME, TEXT("hbvt@C"));

   nSize = (int)m_dropFileList.size();
   for(i=0;i<nSize;i++)
   {
      if(::PathIsDirectory(m_dropFileList[i].c_str()) == FALSE)
      {
         m_inputFileList.push_back(m_dropFileList[i].c_str());

         if((int)m_inputFileList.size() % 10 == 0)
         {
            ::wsprintf(awText, TEXT("t@CJEg %d"), (int)m_inputFileList.size());
            ::SetWindowText(hWnd, awText);
            DoEvents(hWnd);
         }
      }
      else
      {
         ::lstrcpy(awText, m_dropFileList[i].c_str());
         AddListFromFolder(hWnd, awText);
      }

      
      if(m_bExit == true)
         return;
   }
}

void CConvertDialog::DoEvents(HWND hWnd)
{
   MSG msg;

   while(::PeekMessage(&msg, hWnd, 0, 0, PM_REMOVE))
   {
      ::TranslateMessage(&msg);
      ::DispatchMessage(&msg); 
   }
}

void CConvertDialog::Convert(HWND hWnd)
{  

   bool flag;
   int nListSize;
   WCHAR awText[MAX_PATH]; 
   WCHAR awInputFileName[MAX_PATH], awOutputFileName[MAX_PATH];

   nListSize = (int)m_inputFileList.size();

   
   if(m_nCurrentNumber % 100 == 99)
   {
      ::CoUninitialize();
      ::CoInitialize(NULL);
   }

   
   if(nListSize == 1)
      ::lstrcpy(awText, TEXT("ϊJn"));
   else
      ::wsprintf(awText, TEXT("[%d/%d] ϊJn"), m_nCurrentNumber+1, nListSize);

   ::SetWindowText(hWnd, awText);

   
   ::lstrcpy(awInputFileName, m_inputFileList[m_nCurrentNumber].c_str());
   ::SetDlgItemText(hWnd, IDC_STATIC_CONVERT_FILENAME, ::PathFindFileName(awInputFileName));

   ::InvalidateRect(hWnd, NULL, TRUE);
   DoEvents(hWnd);

   
   GetOutputFileName(awOutputFileName, &m_convertData, awInputFileName);

   
   m_nCurrentPercent = 0;

   
   if(m_bExit == true)
      return;

   
   ::lstrcpy(m_awCurrentOutputFileName, awOutputFileName);
   flag = ConvertStart(hWnd, &m_convertData, awInputFileName, awOutputFileName);

   
   if(m_bExit == true)
      return;

   if(flag == true)
   {  

      if(m_convertData.nContainerFormat < CONTAINER_RAW)
      {
         if(nListSize == 1)
            ::wsprintf(awText, TEXT("ϊJn"));
         else
            ::wsprintf(awText, TEXT("[%d/%d] ϊJn"), m_nCurrentNumber+1, nListSize);
      }
      else
      {
         if(nListSize == 1)
            ::wsprintf(awText, TEXT("o"));
         else
            ::wsprintf(awText, TEXT("[%d/%d] o"), m_nCurrentNumber+1, nListSize);
      }

      ::SetWindowText(hWnd, awText);

      if(m_convertData.nContainerFormat < CONTAINER_RAW)
      {  

         WAVEFORMATEX inputFormat, outputFormat;

         m_pDirectShow->GetFormat(&inputFormat, &outputFormat);

         ::wsprintf(awText, TEXT("͉F%6dHz %2dbit %dch"), inputFormat.nSamplesPerSec, inputFormat.wBitsPerSample, inputFormat.nChannels);
         ::SetDlgItemText(hWnd, IDC_STATIC_CONVERT_INPUT_FORMAT, awText);

         if(m_convertData.nContainerFormat == CONTAINER_WAV_SAME_FORMAT)
         {
            ::lstrcpy(awText, TEXT("o͉F͂Ɠ"));
            ::SetDlgItemText(hWnd, IDC_STATIC_CONVERT_OUTPUT_FORMAT, awText);
         }
         else
         {
            ::wsprintf(awText, TEXT("o͉F%6dHz %2dbit %dch"), outputFormat.nSamplesPerSec, outputFormat.wBitsPerSample, outputFormat.nChannels);
            ::SetDlgItemText(hWnd, IDC_STATIC_CONVERT_OUTPUT_FORMAT, awText);
         }
      }
      else
      {  
         int nFileType;

         nFileType = m_pDirectShow->GetRawFileType();

         if(nFileType == CONTAINER_RAW_AAC)
            ::lstrcpy(awText, TEXT("oFaac"));
         else if(nFileType == CONTAINER_RAW_MP2)
            ::lstrcpy(awText, TEXT("oFmp2"));
         else 
            ::lstrcpy(awText, TEXT("oFmp3"));

         ::SetDlgItemText(hWnd, IDC_STATIC_CONVERT_INPUT_FORMAT, awText);

         ::lstrcpy(awText, TEXT(""));
         ::SetDlgItemText(hWnd, IDC_STATIC_CONVERT_OUTPUT_FORMAT, awText);
      }

      ::InvalidateRect(hWnd, NULL, TRUE);

      
      ::SetTimer(hWnd, TIMER_GETPERCENT, 110, NULL);
   }
   else
   {  

      m_nErrorCount++;
      m_nCurrentNumber++;

      m_pDirectShow->Release();

      
      if(::PathFileExists(m_awCurrentOutputFileName) != FALSE)
         ::DeleteFile(m_awCurrentOutputFileName);

      
      ::wsprintf(awText, TEXT("F%d@/ sF%d"), m_nCurrentNumber - m_nErrorCount, m_nErrorCount);
      ::SetDlgItemText(hWnd, IDC_STATIC_CONVERT_RESULT, awText);
      ::InvalidateRect(hWnd, NULL, TRUE);
      DoEvents(hWnd);

      if(m_nCurrentNumber < (int)m_inputFileList.size())
      {  

         
         ::SetTimer(hWnd, TIMER_CONVERT, 55, NULL);
      }
      else
      {  

         if(m_nErrorCount < (int)m_inputFileList.size())
         {
            
            ::PlaySound(MAKEINTRESOURCE(IDR_WAVE), ::GetModuleHandle(NULL), SND_RESOURCE|SND_ASYNC);

            
            for (int i=0;i<4;i++)
            {
               ::FlashWindow(hWnd, TRUE);
               ::Sleep(500);
               ::FlashWindow(hWnd, FALSE);
            }
         }
         else
         {
            ::MessageBox(hWnd, TEXT("ϊł܂łB"), TEXT("EcoDecoTooL G["), MB_OK);
         }

         
         m_bExit = true;
         EndDialog(hWnd);
         ::EndDialog(hWnd, IDOK);
      }
   }

}

void CConvertDialog::GetOutputFileName(WCHAR *pawOutputFileName, CONVERTDATA *pConvertData, WCHAR *pawInputFileName)
{  

   WCHAR awFileExt[MAX_PATH];

   if(pConvertData->nOutputFolder == OUTPUT_SAME_FOLDER)
      ::lstrcpy(pawOutputFileName, pawInputFileName);
   else  
      ::wsprintf(pawOutputFileName, TEXT("%s\\%s"), pConvertData->awOutputFolder, ::PathFindFileName(pawInputFileName));

   switch(pConvertData->nContainerFormat)
   {
   case CONTAINER_WAV_SAME_FORMAT:
   case CONTAINER_WAV_CHANGE_FORMAT:
      ::PathRenameExtension(pawOutputFileName, TEXT(".wav"));
      break;

   case CONTAINER_MP3_FRAUNHOFER_CBR:
   case CONTAINER_MP3_LAME_CBR:
   case CONTAINER_MP3_LAME_VBR:
      ::PathRenameExtension(pawOutputFileName, TEXT(".mp3"));
      break;

   case CONTAINER_OGG_AOTUV_CBR:
   case CONTAINER_OGG_AOTUV_VBR:
   case CONTAINER_OGG_LANCER_CBR:
   case CONTAINER_OGG_LANCER_VBR:
      ::PathRenameExtension(pawOutputFileName, TEXT(".ogg"));
      break;

   case CONTAINER_RAW:
      ::PathRemoveExtension(pawOutputFileName);
      break;
   }

   if(::lstrcmpi(pawInputFileName, pawOutputFileName) == 0)
   {  
      ::lstrcpy(awFileExt, ::PathFindExtension(pawOutputFileName));
      ::PathRemoveExtension(pawOutputFileName);
      ::lstrcat(pawOutputFileName, TEXT("_"));
      ::lstrcat(pawOutputFileName, awFileExt);
   }

   
   if(::PathFileExists(pawOutputFileName) != FALSE)
   {
      if(::DeleteFile(pawOutputFileName) == FALSE)
      {  
         ::lstrcpy(awFileExt, ::PathFindExtension(pawOutputFileName));
         ::PathRemoveExtension(pawOutputFileName);
         ::lstrcat(pawOutputFileName, TEXT("_"));
         ::lstrcat(pawOutputFileName, awFileExt);
      }
   }
}

bool CConvertDialog::ConvertStart(HWND hWnd, CONVERTDATA *pConvertData, WCHAR *pawInputFileName, WCHAR *pawOutputFileName)
{  

   switch(pConvertData->nContainerFormat)
   {
   case CONTAINER_WAV_SAME_FORMAT:
      return (m_pDirectShow->ConvertToWav(hWnd, pawInputFileName, pawOutputFileName, NULL));
   case CONTAINER_WAV_CHANGE_FORMAT:
      return (m_pDirectShow->ConvertToWav(hWnd, pawInputFileName, pawOutputFileName, &pConvertData->wf));

   case CONTAINER_MP3_FRAUNHOFER_CBR:
      return (m_pDirectShow->ConvertToFraunhoferMP3(hWnd, pawInputFileName, pawOutputFileName, pConvertData->nCBRVBR));

   case CONTAINER_MP3_LAME_CBR:
      return (m_pDirectShow->ConvertToLameMP3(hWnd, pawInputFileName, pawOutputFileName, CONTAINER_MP3_LAME_CBR, pConvertData->nCBRVBR));
   case CONTAINER_MP3_LAME_VBR:
      return (m_pDirectShow->ConvertToLameMP3(hWnd, pawInputFileName, pawOutputFileName, CONTAINER_MP3_LAME_VBR, pConvertData->nCBRVBR));

   case CONTAINER_OGG_AOTUV_CBR:
      return (m_pDirectShow->ConvertToOgg(hWnd, pawInputFileName, pawOutputFileName, CONTAINER_OGG_AOTUV_CBR, pConvertData->nCBRVBR, pConvertData->fVBR));
   case CONTAINER_OGG_AOTUV_VBR:
      return (m_pDirectShow->ConvertToOgg(hWnd, pawInputFileName, pawOutputFileName, CONTAINER_OGG_AOTUV_VBR, pConvertData->nCBRVBR, pConvertData->fVBR));

   case CONTAINER_OGG_LANCER_CBR:
      return (m_pDirectShow->ConvertToOgg(hWnd, pawInputFileName, pawOutputFileName, CONTAINER_OGG_LANCER_CBR, pConvertData->nCBRVBR, pConvertData->fVBR));
   case CONTAINER_OGG_LANCER_VBR:
      return (m_pDirectShow->ConvertToOgg(hWnd, pawInputFileName, pawOutputFileName, CONTAINER_OGG_LANCER_VBR, pConvertData->nCBRVBR, pConvertData->fVBR));

   case CONTAINER_RAW:
      return (m_pDirectShow->ConvertRaw(hWnd, pawInputFileName, pawOutputFileName));
   }

   return false;
}

void CConvertDialog::ConvertGetPercent(HWND hWnd)
{
   WCHAR awText[MAX_PATH];

   if(m_convertData.nContainerFormat < CONTAINER_RAW)
   {  

      int nNewPercent;

      nNewPercent = m_pDirectShow->GetPercent();
      if(nNewPercent >= 0)
      {
         if(nNewPercent > 100)
            nNewPercent = 100;

         if(nNewPercent != m_nCurrentPercent)
         {
            if((int)m_inputFileList.size() == 1)
               ::wsprintf(awText, TEXT("%3d%% ϊ"), nNewPercent);
            else
               ::wsprintf(awText, TEXT("[%d/%d]%3d%% ϊ"), m_nCurrentNumber+1, (int)m_inputFileList.size(), nNewPercent);

             ::SetWindowText(hWnd, awText);
             m_nCurrentPercent = nNewPercent;
         }
      }
      else
      {  

         if((int)m_inputFileList.size() == 1)
            ::lstrcpy(awText, TEXT("ϊ"));
         else
            ::wsprintf(awText, TEXT("[%d/%d] ϊ"), m_nCurrentNumber+1, (int)m_inputFileList.size());

         for(int j=0;j<m_nCurrentPercent;j++)
            ::lstrcat(awText, TEXT("."));

         ::SetWindowText(hWnd, awText);

         m_nCurrentPercent++;
         if(m_nCurrentPercent > 3)
            m_nCurrentPercent = 0;
      }
   }
   else
   {  

      if((int)m_inputFileList.size() == 1)
         ::lstrcpy(awText, TEXT("o"));
      else
         ::wsprintf(awText, TEXT("[%d/%d] o"), m_nCurrentNumber+1, (int)m_inputFileList.size());

      for(int j=0;j<m_nCurrentPercent;j++)
         ::lstrcat(awText, TEXT("."));

      ::SetWindowText(hWnd, awText);

      m_nCurrentPercent++;
      if(m_nCurrentPercent > 3)
         m_nCurrentPercent = 0;
   }
}

void CConvertDialog::ConvertExit(HWND hWnd)
{  

   
   ::KillTimer(hWnd, TIMER_GETINPUTFILENAME);
   ::KillTimer(hWnd, TIMER_CONVERT);
   ::KillTimer(hWnd, TIMER_GETPERCENT);

   m_pDirectShow->Release();

   
   if(::PathFileExists(m_awCurrentOutputFileName) != FALSE)
      ::DeleteFile(m_awCurrentOutputFileName);
}

void CConvertDialog::ConvertEnd(HWND hWnd, int nEndState)
{
   WCHAR awText[MAX_PATH];

   
   ::KillTimer(hWnd, TIMER_GETPERCENT);

   m_pDirectShow->Release();

   if(nEndState == EC_COMPLETE)
   {  

      if(m_convertData.nContainerFormat < CONTAINER_RAW)
      {  

         if((int)m_inputFileList.size() == 1)
            ::wsprintf(awText, TEXT("100%% ϊ"));
         else
            ::wsprintf(awText, TEXT("[%d/%d]100%% ϊ"), m_nCurrentNumber+1, (int)m_inputFileList.size());

         ::SetWindowText(hWnd, awText);
      }
 

   }
   else
   {  

      m_nErrorCount++;

      
      if(::PathFileExists(m_awCurrentOutputFileName) != FALSE)
         ::DeleteFile(m_awCurrentOutputFileName);
   }

   m_nCurrentNumber++;

   
   ::wsprintf(awText, TEXT("F%d@/ sF%d"), m_nCurrentNumber - m_nErrorCount, m_nErrorCount);
   ::SetDlgItemText(hWnd, IDC_STATIC_CONVERT_RESULT, awText);
   ::InvalidateRect(hWnd, NULL, TRUE);
   DoEvents(hWnd);


   if(m_nCurrentNumber < (int)m_inputFileList.size())
   {  

      
      ::SetTimer(hWnd, TIMER_CONVERT, 55, NULL);
   }
   else
   {  

      if(m_nErrorCount < (int)m_inputFileList.size())
      {
         
         ::PlaySound(MAKEINTRESOURCE(IDR_WAVE), ::GetModuleHandle(NULL), SND_RESOURCE|SND_ASYNC);

         
         for (int i=0;i<4;i++)
         {
            DoEvents(hWnd);
            ::FlashWindow(hWnd, TRUE);
            ::Sleep(500);
            DoEvents(hWnd);
            ::FlashWindow(hWnd, FALSE);
            DoEvents(hWnd);
         }
      }
      else
      {
         ::MessageBox(hWnd, TEXT("ϊł܂łB"), TEXT("EcoDecoTooL G["), MB_OK);
      }

      
      m_bExit = true;
      EndDialog(hWnd);
      ::EndDialog(hWnd, IDOK);
   }
}

void CConvertDialog::Show(CONVERTDATA *pData, vector<std::wstring> dropList)
{
   int i;

   for(i=0;i<(int)dropList.size();i++)
      m_dropFileList.push_back(dropList[i].c_str());

   ::CopyMemory(&m_convertData, pData, sizeof(m_convertData));

   
   i = ::DialogBox(::GetModuleHandle(NULL), MAKEINTRESOURCE(IDD_DIALOG_CONVERT), NULL, (DLGPROC)DialogProc);
}

void CConvertDialog::InitDialog(HWND hWnd)
{
   
   WCHAR awIniFileName[MAX_PATH];
   ::GetModuleFileName(NULL, awIniFileName, MAX_PATH);
   ::PathRemoveFileSpec(awIniFileName);
   ::lstrcat(awIniFileName, TEXT("\\EcoDecoTooL.ini"));

   RECT r1, r2;
   POINT p;

   p.x = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("ConvertWindowLeft"), -10, awIniFileName);
   p.y = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("ConvertWindowTop"), -10, awIniFileName);

   if(p.x == -10 && p.y == -10)
   {  

      p.x = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("MainWindowLeft"), 100, awIniFileName);
      p.y = (int)::GetPrivateProfileInt(TEXT("Setting"), TEXT("MainWindowTop"), 100, awIniFileName);
      p.y += 220;
   }

   ::SystemParametersInfo(SPI_GETWORKAREA, 0, &r1, 0);
   ::GetWindowRect(hWnd, &r2);

   if(p.x < 0)
      p.x = 0;
   else if( ((r1.right- r1.left) - (r2.right - r2.left)) < p.x)
      p.x = (r1.right- r1.left) - (r2.right - r2.left);

   if(p.y < 0)
      p.y = 0;
   else if( ((r1.bottom- r1.top) - (r2.bottom - r2.top)) < p.y)
      p.y = (r1.bottom- r1.top) - (r2.bottom - r2.top);

   
   ::SetWindowPos(hWnd, HWND_TOPMOST, p.x, p.y, 0, 0, SWP_NOSIZE);
   ::SetForegroundWindow(hWnd);
   ::UpdateWindow(hWnd);
   ::SetWindowPos(hWnd, HWND_NOTOPMOST, p.x, p.y, 0, 0, SWP_NOSIZE);
   ::UpdateWindow(hWnd);
   ::InvalidateRect(hWnd, NULL, TRUE);
   DoEvents(hWnd);

   
   GetInputFileName(hWnd);

   
   WCHAR awText[MAX_PATH];
   ::lstrcpy(awText, TEXT("F0@/ sF0"));
   ::SetDlgItemText(hWnd, IDC_STATIC_CONVERT_RESULT, awText);
   ::SetDlgItemText(hWnd, IDC_STATIC_CONVERT_FILENAME, TEXT(""));
   ::InvalidateRect(hWnd, NULL, TRUE);
   DoEvents(hWnd);

   ::SetTimer(hWnd, TIMER_CONVERT, 55, NULL);
}

void CConvertDialog::EndDialog(HWND hWnd)
{
   
   if(m_bExit == false)
   {
      m_bExit = true;
      ::Sleep(500);
   }
   
   WCHAR awText[MAX_PATH], awIniFileName[MAX_PATH];

   ::GetModuleFileName(NULL, awIniFileName, MAX_PATH);
   ::PathRemoveFileSpec(awIniFileName);
   ::lstrcat(awIniFileName, TEXT("\\EcoDecoTooL.ini"));

   WINDOWPLACEMENT wndpl;
   ::GetWindowPlacement(hWnd, &wndpl);
   ::wsprintf(awText, TEXT("%d"), wndpl.rcNormalPosition.left);
   ::WritePrivateProfileString(TEXT("Setting"), TEXT("ConvertWindowLeft"), awText, awIniFileName);
   ::wsprintf(awText, TEXT("%d"), wndpl.rcNormalPosition.top);
   ::WritePrivateProfileString(TEXT("Setting"), TEXT("ConvertWindowTop"), awText, awIniFileName);
}

LRESULT CALLBACK CConvertDialog::DialogProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
   switch (msg)
   {
   case WM_INITDIALOG:
      g_pMyClass->InitDialog(hWnd);
      return TRUE;

   case WM_CTLCOLORSTATIC:
      ::SetBkMode((HDC)wParam, TRANSPARENT);
      return (BOOL)(HBRUSH)GetStockObject(NULL_BRUSH);

   case WM_CONVERT:
      g_pMyClass->Convert(hWnd);
      return TRUE;

   case WM_GRAPHNOTIFY:

      switch(g_pMyClass->m_pDirectShow->PlayEnd())
      {
         case EC_COMPLETE:
            g_pMyClass->ConvertEnd(hWnd, EC_COMPLETE);
            return TRUE;
         case EC_ERRORABORT:
            g_pMyClass->ConvertEnd(hWnd, EC_ERRORABORT);
            return TRUE;
      }

      return FALSE;

   case WM_TIMER:

      switch(wParam)
      {
      case TIMER_GETINPUTFILENAME:
         ::KillTimer(hWnd, TIMER_GETINPUTFILENAME);
         g_pMyClass->GetInputFileName(hWnd);
         break;
      case TIMER_CONVERT:
         ::KillTimer(hWnd, TIMER_CONVERT);
         g_pMyClass->Convert(hWnd);
         break;
      case TIMER_GETPERCENT:
         g_pMyClass->ConvertGetPercent(hWnd);
         break;
      }

      return TRUE;

   case WM_CTLCOLORDLG:
      
      ::SetBkMode((HDC)wParam, OPAQUE);
      return (LRESULT)::GetStockObject(WHITE_BRUSH);

   case WM_DESTROY:
      ::PostQuitMessage(0); 
      return TRUE;

   case WM_CLOSE:
      g_pMyClass->ConvertExit(hWnd);
      g_pMyClass->EndDialog(hWnd);
      ::EndDialog(hWnd ,IDCANCEL);
      return TRUE;
   }

	return FALSE;
}

