/* 
 * Copyright (C) 2008 cocha,hozumi
 * http://sourceforge.jp/projects/ecodecotool
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 	
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef ___ECODECOTOOL_H_INCLUDED___
#define ___ECODECOTOOL_H_INCLUDED___

#include <windows.h>
#include <shlobj.h>
#include <Shlwapi.h>
#include <process.h>
#include <streams.h>
#include <dmoreg.h>
#include <dmodshow.h>

#include<vector>
using namespace std;

#include "DShowTool.h"
#include "resource.h"

#define WM_CONVERT     WM_USER+1
#define WM_GRAPHNOTIFY WM_USER+2
#define WAVE_FORMAT_IEEE_FLOAT 0x0003


#define SAFE_RELEASE(p) { if(p!=NULL) { (p)->Release(); (p)=NULL; } }

#define CONTAINER_WAV_SAME_FORMAT     0
#define CONTAINER_WAV_CHANGE_FORMAT   1
#define CONTAINER_MP3_FRAUNHOFER_CBR 10
#define CONTAINER_MP3_LAME_CBR       20
#define CONTAINER_MP3_LAME_VBR       21
#define CONTAINER_OGG_AOTUV_CBR      30
#define CONTAINER_OGG_AOTUV_VBR      31
#define CONTAINER_OGG_LANCER_CBR     40
#define CONTAINER_OGG_LANCER_VBR     41
#define CONTAINER_RAW               100
#define CONTAINER_RAW_AAC           101
#define CONTAINER_RAW_MP2           102
#define CONTAINER_RAW_MP3           103
#define CONTAINER_RAW_OGG           104
#define CONTAINER_RAW_WAV           105


#define OUTPUT_SAME_FOLDER 0
#define OUTPUT_DIFF_FOLDER 1
// ----------------------------------------------------------------------------------------------------------------------------
__interface
__declspec(uuid("{F42CA3D6-A5EB-4167-9B04-18A8B2AC7A3B}"))
IEcoDecoInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP GetTransformedBytes(LONGLONG *);
};
// ------------------------------------------------------------------------------------------------------------------------
__interface
__declspec(uuid("{C8636C72-D4A6-4810-9A1A-1A11AA6C8E90}"))
IEcoDecoWriterInterface : public IUnknown
{
public:
   int GetOutputMode(void);
   STDMETHODIMP SetFileName(WCHAR *);
};
// ------------------------------------------------------------------------------------------------------------------------
__interface
__declspec(uuid("{DBE16C61-1BAD-4373-A382-4BCCAD99EB91}"))
IWavConInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP GetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetQuality(int);
};
// ------------------------------------------------------------------------------------------------------------------------
__interface
__declspec(uuid("{16F5105B-7322-4a62-9284-992DD186F6A1}"))
IMp3DecInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(void *);
   STDMETHODIMP GetOutFormat(void *);
   STDMETHODIMP SetOutFormat(void *);
};
// ------------------------------------------------------------------------------------------------------------------------
__interface
__declspec(uuid("{60DE31EA-E970-4ed7-8FD4-991C29206462}"))
IFraunhoferWriterInterface : public IUnknown
{
public:
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, int);
   STDMETHODIMP SetBitrate(int);
   STDMETHODIMP SetFileName(WCHAR *);
};
// ------------------------------------------------------------------------------------------------------------------------
__interface
__declspec(uuid("{00465F16-8051-4024-97FA-835E05A19AD2}"))
ILameWriterInterface : public IUnknown
{
public:
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, void *);
   STDMETHODIMP SetOutFormat(void *);
   STDMETHODIMP SetFileName(WCHAR *);
};
// ------------------------------------------------------------------------------------------------------------------------
__interface
__declspec(uuid("{16F5105B-7322-4a62-9284-992DD186F6A1}"))
IaoTuVWriterInterface : public IUnknown
{
public:
   STDMETHODIMP SetVorbisFormat(void *);
   STDMETHODIMP GetVorbisFormat(void *);
   STDMETHODIMP SetVorbisTag(void *);
   STDMETHODIMP SetFileName(WCHAR *);
};
// ------------------------------------------------------------------------------------------------------------------------
__interface
__declspec(uuid("{635001D9-A56C-4724-996E-3B2AD67FCDDB}"))
IaoTuvDecInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(void *);
   STDMETHODIMP GetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetOutBitsPerSample(WORD, WORD);
};
// ------------------------------------------------------------------------------------------------------------------------
typedef struct tagVORBISFORMAT
{
	WORD  nChannels;
	long  nSamplesPerSec;
	long  nMinBitsPerSec;
	long  nAvgBitsPerSec;
	long  nMaxBitsPerSec;
	float fQuality;
} VORBISFORMAT;
// ------------------------------------------------------------------------------------------------------------------------
typedef struct
{
   int nMode;
   int nQuality;

   struct
   {
      DWORD dwBitrate;
   } abr;

   struct
   {
      DWORD dwBitrate;
   } cbr;

   struct
   {
      int nVBRQuality;
      DWORD dwMinBitrate;
      DWORD dwMaxBitrate;
   } vbr;
} LAME_CONFIG, *PLAME_CONFIG;
// ------------------------------------------------------------------------------------------------------------------------
struct CONVERTDATA
{
   int nContainerFormat;
   int nOutputFolder;
   WCHAR awOutputFolder[MAX_PATH];

   WAVEFORMATEX wf;
   int nCBRVBR;
   float fVBR;
};
// ------------------------------------------------------------------------------------------------------------------------
class CDirectShow
{
private:
   IPin* GetAudioOutputPin(IBaseFilter *);
   IBaseFilter*ConnectAudio(IBaseFilter *);
   HRESULT RenderWmvRaw(WCHAR *, IBaseFilter *);
   HRESULT RenderWma(WCHAR *, IBaseFilter *);
   HRESULT RenderAudio(WCHAR *, IBaseFilter *);

   IGraphBuilder *m_pGraphBuilder;
   IMediaEventEx *m_pMediaEventEx;
   IMediaControl *m_pMediaControl;
   CDShowTool *pDShowTool;
   LONGLONG m_llTotalBytes;
   WAVEFORMATEX m_InputFormat;
   WAVEFORMATEX m_OutputFormat;
   IEcoDecoInterface *m_pEcoDecoInterface;

   int m_nRawFileType;

public:
   CDirectShow();
   ~CDirectShow();

   void Release();
   int PlayEnd(void);
   int GetRawFileType(void);
   int GetPercent(void);
   void GetFormat(WAVEFORMATEX *, WAVEFORMATEX *);
   bool ConvertToWav(HWND, WCHAR *, WCHAR *, WAVEFORMATEX *);
   bool ConvertToFraunhoferMP3(HWND, WCHAR *, WCHAR *, int);
   bool ConvertToLameMP3(HWND, WCHAR *, WCHAR *, int, int);
   bool ConvertToOgg(HWND, WCHAR *, WCHAR *, int, int, float);
   bool ConvertRaw(HWND, WCHAR *, WCHAR *);
};
// ----------------------------------------------------------------------------------------------------------------------------
class CConvertDialog
{
private:

   void AddListFromFolder(HWND, WCHAR *);
   void GetInputFileName(HWND);
   void DoEvents(HWND);
   void Convert(HWND);
   void GetOutputFileName(WCHAR *, CONVERTDATA *, WCHAR *);
   bool ConvertStart(HWND, CONVERTDATA *, WCHAR *, WCHAR *);
   void ConvertGetPercent(HWND);
   void ConvertExit(HWND);
   void ConvertEnd(HWND, int);

   void InitDialog(HWND);
   void EndDialog(HWND);
   static LRESULT CALLBACK DialogProc(HWND, UINT, WPARAM, LPARAM);

   bool m_bExit;
   int m_nCurrentNumber;
   int m_nErrorCount;
   int m_nCurrentPercent;
   WCHAR m_awCurrentOutputFileName[MAX_PATH];
   vector<std::wstring> m_dropFileList;
   vector<std::wstring> m_inputFileList;
   CONVERTDATA m_convertData;
   CDirectShow *m_pDirectShow;

public:
   CConvertDialog();
   ~CConvertDialog();
   void Show(CONVERTDATA *, vector<std::wstring>);
};
// ----------------------------------------------------------------------------------------------------------------------------
class CCustomMainDialog
{
private:
   HRGN m_hRgn;

public:
   CCustomMainDialog();
   void Paint(HDC);
   void DrawCustomRoundRect(HDC, RECT *);
   void CreateRgnWindow(HWND);
   void DeleteRgnWindow(void);
   void MeasureItem(HWND, MEASUREITEMSTRUCT *);
   void DrawHoverButton(DRAWITEMSTRUCT *, int);
   void DrawItem(DRAWITEMSTRUCT *);
};
// ----------------------------------------------------------------------------------------------------------------------------
class CMainDialog
{
   friend class CCustomMainDialog;

private:
   bool ExistsFraunhoferPro(void);
   bool ExistsLameEnc(void);
   void SelectComboBox(HWND, int);
   void SelectFolder(HWND);
   void LoadSetting(HWND);
   void SaveSetting(HWND);
   bool DropFiles(HWND, HDROP);
   static int CALLBACK SHBrowseProc(HWND, UINT, LPARAM, LPARAM);
   static LRESULT CALLBACK LinkLabelProc(HWND, UINT, WPARAM, LPARAM);
   static LRESULT CALLBACK ButtonProc(HWND, UINT, WPARAM, LPARAM);
   static LRESULT CALLBACK DialogWaveFormatProc(HWND, UINT, WPARAM, LPARAM);
   static LRESULT CALLBACK DialogProc(HWND, UINT, WPARAM, LPARAM);
   void InitDialog(HWND);
   void EndDialog(HWND);

   WNDPROC m_defButtonMinProc;
   WNDPROC m_defButtonCloseProc;
   WNDPROC m_defButtonHelpProc;
   WNDPROC m_defLinkLabelFraunhoferProc;
   WNDPROC m_defLinkLabelLameProc;
   WNDPROC m_defButtonDropFileHelpProc;
   int m_nMinResourceID;
   int m_nCloseResourceID;
   int m_nAlpha;
   WAVEFORMATEX m_waveFormat;
   CONVERTDATA m_convertData;
   vector<std::wstring> m_dropList;
   bool m_bExistsFraunhoferPro;
   bool m_bExistsLameEnc;
   CCustomMainDialog customMainDialog;

public:
   CMainDialog();
   ~CMainDialog();
   bool Show(CONVERTDATA *, vector<std::wstring> *);
};
// ----------------------------------------------------------------------------------------------------------------------------


#endif ___ECODECOTOOL_H_INCLUDED___
