/**************************************************************************
 *	Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#ifndef __EcoDecoWav_h__
#define __EcoDecoWav_h__

#include <windows.h>
#include <streams.h>
#include <math.h>

#define WAVE_FORMAT_IEEE_FLOAT 0x0003

#define SAFE_RELEASE(p) { if(p!=NULL) { (p)->Release(); (p)=NULL; } }
struct SmplData{double l,r;};


// tB^̖O
#define FILTER_NAME L"WavConFilter"

// {EFBF44B7-BB1F-48c8-BA59-EB9803579B1E}
static const GUID CLSID_WavConFilter = 
{ 0xefbf44b7, 0xbb1f, 0x48c8, { 0xba, 0x59, 0xeb, 0x98, 0x3, 0x57, 0x9b, 0x1e } };

// {BDA4CAB0-2EB2-42cb-A631-E89E82352DD1}
static const GUID IID_IWavConInterface = 
{ 0xbda4cab0, 0x2eb2, 0x42cb, { 0xa6, 0x31, 0xe8, 0x9e, 0x82, 0x35, 0x2d, 0xd1} };

// -----------------------------------------------------------------------------------------------------------------------------------
// o͐ݒC^[tFCX
__interface
__declspec(uuid("{DBE16C61-1BAD-4373-A382-4BCCAD99EB91}"))
IWavConInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP GetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetQuality(int);
};
// -----------------------------------------------------------------------------------------------------------------------------------
class CSamplingConv
{
public:

   // [U֐
   HRESULT ConvertInit(WAVEFORMATEX *, WAVEFORMATEX *, int);
   void Convert(struct SmplData *, int, BYTE *, int *);
   void ConvertSSE2(struct SmplData *, int, BYTE *, int *);
   void ConvertEnd(struct SmplData *, int, BYTE *, int *);

private:

   // [U֐
   double bessel0(double);

   // [Uϐ
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;

   int iptr;
	int ismd, ismr;
   long firodrv;
   int isrm, osrm;
   int sptr, sptrr, eptr, eptrr;
   double m_hfir[65536];
   double m_dMaxData, m_dMinData;
   double m_dRatioPlus, m_dRatioMinus;
};
// -----------------------------------------------------------------------------------------------------------------------------------
class CChannelConv
{
public:

   // [U֐
   HRESULT SetFormat(WAVEFORMATEX *, WAVEFORMATEX *);
   HRESULT Convert(BYTE *, int, BYTE *, int *);
   HRESULT Convert(BYTE *, int, int *);

private:

   // [Uϐ
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;

};
// -----------------------------------------------------------------------------------------------------------------------------------
class CBitConv
{
public:

   // [U֐
   HRESULT SetFormat(WAVEFORMATEX *, WAVEFORMATEX *);
   HRESULT Convert(BYTE *, int, BYTE *, int *);

private:

   // [Uϐ
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;
   double m_dRatio;

   // [U֐
   HRESULT Convert8(BYTE *, int, BYTE *, int *);
   HRESULT Convert16(BYTE *, int, BYTE *, int *);
   HRESULT Convert24(BYTE *, int, BYTE *, int *);
   HRESULT Convert32i(BYTE *, int, BYTE *, int *);
   HRESULT Convert32f(float *, int, BYTE *, int *);
   HRESULT Convert64(double *, int, BYTE *, int *);
};
// -----------------------------------------------------------------------------------------------------------------------------------
class CWavConFilterInputPin : public CTransformInputPin
{
public:
   CWavConFilterInputPin(TCHAR *pObjectName, CTransformFilter *pTransformFilter, HRESULT *phr, LPCWSTR pName) :
      CTransformInputPin(pObjectName, pTransformFilter, phr, pName ) { }

   STDMETHODIMP GetAllocatorRequirements(ALLOCATOR_PROPERTIES *pProps);
};
// -----------------------------------------------------------------------------------------------------------------------------------
class CWavConFilter : public CTransformFilter, public IWavConInterface
{
   friend class CBitConv;
   friend class CChannelConv;
   friend class CSamplingConv;
   friend class CWavConFilterInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CWavConFilter(LPUNKNOWN pUnk,HRESULT *phr);
   virtual ~CWavConFilter();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // CTransformFilteȑz\bh
   HRESULT CheckInputType(const CMediaType *);
   HRESULT CheckTransform(const CMediaType *,const CMediaType *);
   HRESULT GetMediaType(int iPosition,CMediaType *);
   HRESULT DecideBufferSize(IMemAllocator *, ALLOCATOR_PROPERTIES *);

   // CTransformFilter̃I[o[Ch
   HRESULT StartStreaming(void);
   HRESULT Receive(IMediaSample *);
   HRESULT StopStreaming();
   HRESULT EndOfStream(void);
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);

   // IWavConInterface
   STDMETHODIMP GetInFormat(WAVEFORMATEX *);
   STDMETHODIMP GetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetQuality(int);

private:

   // [U֐
   void ConvertToDouble(BYTE *, int);
   HRESULT Convert(BYTE *, int, BYTE *, int *);

   // [Uϐ
   bool m_bSetOutFormat;
   bool m_bUseSSE2;
   int m_nAccurate;
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;
   CBitConv *m_pBitConv;
   CCritSec m_myLock;
   CChannelConv *m_pChannelConv;
   CSamplingConv *m_pSamplingConv;
   int m_nSmplSize;
   struct SmplData *m_smpld;
};
// -----------------------------------------------------------------------------------------------------------------------------------

#endif __EcoDecoWav_h__
