/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoMp3.h"

// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFraunhoferWriterInputPin::CheckBitrate(WAVEFORMATEX *pInFormat, int nOutBitrate)
{  // pInFormat̓͂̏ꍇɁAnOutBitratẽrbg[gŏo͂ł邩`FbN

   return m_pAcmFraunhofer->CheckFormat(pInFormat, nOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFraunhoferWriterInputPin::SetBitrate(int nOutBitrate)
{  // o͂̃rbg[gݒ肷

   m_nBitrate = nOutBitrate;
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CFraunhoferWriterInputPin::StartStreaming()
{
   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFraunhoferWriterInputPin::Receive(IMediaSample *pSample)
{
   HRESULT hr;

   CAutoLock lock(m_pReceiveLock);

   BYTE *pbData;
   hr = pSample->GetPointer(&pbData);
   if(FAILED(hr))
      return hr;

   int nLength = 0;

   // acmŕϊ
   hr = m_pAcmFraunhofer->Convert(m_hFile, pbData, pSample->GetActualDataLength());

   if(hr != S_OK)
      return S_FALSE;

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CFraunhoferWriterInputPin::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   if(m_hFile != NULL)
   {  // t@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFraunhoferWriterInputPin::EndOfStream(void)
{  // 󂯎f[^ȂꍇɌĂ΂

   CAutoLock lock(m_pReceiveLock);

   // acmŕϊ
   m_pAcmFraunhofer->ConvertEnd(m_hFile);

   if(m_hFile != NULL)
   {  // t@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   return CRenderedInputPin::EndOfStream();
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CFraunhoferWriterInputPin::CheckMediaType(const CMediaType *pMediaType)
{  // ̓sق̃sƌqɌĂ΂

   if(*pMediaType->Type() == MEDIATYPE_Audio && *pMediaType->Subtype() == MEDIASUBTYPE_PCM)
   {
      if(*pMediaType->FormatType() == FORMAT_WaveFormatEx)
      {
         WAVEFORMATEX *pwf = (WAVEFORMATEX *)pMediaType->Format();

         if(pwf->wFormatTag == WAVE_FORMAT_PCM && pwf->wBitsPerSample == 16 && pwf->nSamplesPerSec <= 48000)
         {
            ::CopyMemory(&m_inFormat, (WAVEFORMATEX *)pMediaType->Format(), sizeof(m_inFormat));
            return S_OK;
         }
      }
   }

   return S_FALSE;
}
// -----------------------------------------------------------------------------------------------------------------------------------
HRESULT CFraunhoferWriterInputPin::BreakConnect()
{
   if(m_pFilter->m_pPosition != NULL)
      m_pFilter->m_pPosition->ForceRefresh();

   return CRenderedInputPin::BreakConnect();
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFraunhoferWriterInputPin::SetFileName(WCHAR *pwFileName)
{
   if(m_hFile != NULL)
   {
      BOOL flag;

      flag = ::CloseHandle(m_hFile);
      if(flag == FALSE)
         return E_FAIL;

      m_hFile = NULL;
   }

   // ͂̃f[^TCY擾
   HRESULT hr;

   ALLOCATOR_PROPERTIES InProps;
   IMemAllocator * pInAlloc = NULL;

   hr = GetAllocator(&pInAlloc);
   if(FAILED(hr)) return hr;

   hr = pInAlloc->GetProperties(&InProps);
   if(FAILED(hr))
   {
      SAFE_RELEASE(pInAlloc);
      return hr;
   }

   SAFE_RELEASE(pInAlloc);

   // acm
   hr = m_pAcmFraunhofer->ConvertInit(&m_inFormat, InProps.cbBuffer * 12 / 10, m_nBitrate);
   if(hr != S_OK)
      return E_FAIL;

   // t@C쐬
   m_hFile = ::CreateFile(pwFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);
   if(m_hFile == NULL)
      return E_FAIL;

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CFraunhoferWriterInputPin::CFraunhoferWriterInputPin(CFraunhoferWriter *pFilter, LPUNKNOWN pUnk, CCritSec *pLock, CCritSec *pReceiveLock, HRESULT *phr)
   : CRenderedInputPin(NAME("Input"), pFilter, pLock, phr, L"Input"), m_pReceiveLock(pReceiveLock), m_pFilter(pFilter)
{  // CFraunhoferWriterInputPiñRXgN^

   // ϐ̏
   m_nBitrate = 0;
   m_pAcmFraunhofer = new CAcmFraunhofer();
   m_hFile = NULL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CFraunhoferWriterInputPin::~CFraunhoferWriterInputPin()
{  // CFraunhoferWriterInputPiñfXgN^

   if(m_hFile != NULL)
   {  // ܂t@CĂȂȂAt@C
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   if(m_pAcmFraunhofer != NULL)
   {
      delete m_pAcmFraunhofer;
      m_pAcmFraunhofer = NULL;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFraunhoferWriter::CheckBitrate(WAVEFORMATEX *pInFormat, int nOutBitrate)
{  // pInFormat̓͂̏ꍇɁAnOutBitratẽrbg[gŏo͂ł邩`FbN

   CheckPointer(m_pInputPin, E_POINTER);

   return m_pInputPin->CheckBitrate(pInFormat, nOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFraunhoferWriter::SetBitrate(int nOutBitrate)
{  // o͂̃rbg[gݒ肷

   CheckPointer(m_pInputPin, E_POINTER);
   return m_pInputPin->SetBitrate(nOutBitrate);
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFraunhoferWriter::Pause()
{
   CAutoLock cObjectLock(m_pLock);

   HRESULT hr = S_OK;

   if(m_State == State_Stopped)
      hr = m_pInputPin->StartStreaming();

   if(SUCCEEDED(hr))
      hr = CBaseFilter::Pause();

   return hr;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFraunhoferWriter::Stop()
{  // tB^~ꂽꍇɌĂ΂

   CAutoLock cObjectLock(m_pLock);

   if(m_pInputPin != NULL)
      m_pInputPin->Stop();
    
    return CBaseFilter::Stop();
}
// -----------------------------------------------------------------------------------------------------------------------------------
int CFraunhoferWriter::GetPinCount()
{  // s̐Ԃ(tB^[͓̓s1)

   if(m_pInputPin == NULL)
      return 0;

   return 1;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CBasePin *CFraunhoferWriter::GetPin(int n)
{  // nԖڂ̃s̃|C^Ԃ(tB^[͓̓s1)

   if(n == 0)
      return m_pInputPin;

   return NULL;
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFraunhoferWriter::NonDelegatingQueryInterface(REFIID riid, void ** ppv)
{  // C^[tFCX擾AQƃJEgCNg

   CheckPointer(ppv, E_POINTER);
   CAutoLock lock(&m_Lock);

   if (riid == IID_IFileSinkFilter)
   {
      return GetInterface((IFileSinkFilter *)this, ppv);
   }
   else if (riid == IID_IMediaPosition || riid == IID_IMediaSeeking)
   {
      if (m_pPosition == NULL) 
      {
         HRESULT hr = S_OK;
         m_pPosition = new CPosPassThru(NAME("FraunhoferWriter Pass Through"), (IUnknown *) GetOwner(), (HRESULT *) &hr, m_pInputPin);

         if (m_pPosition == NULL) 
            return E_OUTOFMEMORY;

         if (FAILED(hr)) 
         {
            delete m_pPosition;
            m_pPosition = NULL;
            return hr;
         }
      }

      return m_pPosition->NonDelegatingQueryInterface(riid, ppv);
   } 
   else if(riid == IID_IFraunhoferWriterInterface)
   {
      return GetInterface((IFraunhoferWriterInterface *)this, ppv);
   }

   return CBaseFilter::NonDelegatingQueryInterface(riid, ppv);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CFraunhoferWriter::CFraunhoferWriter(LPUNKNOWN pUnk, HRESULT *phr)
   : CBaseFilter(NAME("FraunhoferWriter"), pUnk, &m_Lock, CLSID_EcoDecoFraunhoferWriter) , m_pPosition(NULL)
{  // RXgN^

   ASSERT(phr);

   // ̓s̍쐬
   m_pInputPin = new CFraunhoferWriterInputPin(this, GetOwner(), &m_Lock, &m_ReceiveLock, phr);
   if (m_pInputPin == NULL)
   {
      if(phr)
         *phr = E_OUTOFMEMORY;

      return;
   }

   if(phr)
      *phr = S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------------------
CFraunhoferWriter::~CFraunhoferWriter()
{  // fXgN^

   if(m_pPosition != NULL)
   {
      delete m_pPosition;
      m_pPosition = NULL;
   }

   // ̓s̉
   if(m_pInputPin != NULL)
   {
      delete m_pInputPin;
      m_pInputPin = NULL;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
STDMETHODIMP CFraunhoferWriter::SetFileName(WCHAR *pwFileName)
{
   if(m_pInputPin == NULL)
      return E_FAIL;

   return m_pInputPin->SetFileName(pwFileName);
}
// -----------------------------------------------------------------------------------------------------------------------------------
CUnknown * WINAPI CFraunhoferWriter::CreateInstance(LPUNKNOWN punk, HRESULT *phr)
{  // IuWFNg쐬

   ASSERT(phr);
    
   CFraunhoferWriter *pNewObject = new CFraunhoferWriter(punk, phr);
   if (pNewObject == NULL)
   {
      if(phr != NULL)
         *phr = E_OUTOFMEMORY;
   }

   return dynamic_cast<CUnknown *>(pNewObject);
}
// -----------------------------------------------------------------------------------------------------------------------------------
