/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#ifndef _EcoDecoMp3_h_
#define _EcoDecoMp3_h_

#include <windows.h>
#include <shlwapi.h>
#include <streams.h>
#include <mmreg.h>
#include <msacm.h>

#include "mpglib/mpg123.h"
#include "mpglib/mpglib.h"
#include "BladeMP3EncDLL.h"

#define FILTERNAME_MP3DEC           L"Mp3 Decoder"
#define FILTERNAME_FRAUNHOFERWRITER L"Fraunhofer Writer"
#define FILTERNAME_LAMEWRITER       L"Lame Writer"

#define MODE_ABR 0
#define MODE_CBR 1
#define MODE_VBR 2


//#define WAVE_FORMAT_IEEE_FLOAT 3
#define SAFE_RELEASE(p) { if(p!=NULL) { (p)->Release(); (p)=NULL; } }

// {B335BFBF-A6C5-4418-8956-5860B93E2BC4}
static const GUID CLSID_EcoDecoMp3Dec = 
{ 0xb335bfbf, 0xa6c5, 0x4418, { 0x89, 0x56, 0x58, 0x60, 0xb9, 0x3e, 0x2b, 0xc4 } };

// {A658A66F-63A9-42a1-8A1E-94ADC89AA360}
static const GUID IID_IMp3DecInterface = 
{ 0xa658a66f, 0x63a9, 0x42a1, { 0x8a, 0x1e, 0x94, 0xad, 0xc8, 0x9a, 0xa3, 0x60 } };


// {F714A0FA-B683-4185-9BEB-D454D3B1CF7D}
static const GUID CLSID_EcoDecoFraunhoferWriter = 
{ 0xf714a0fa, 0xb683, 0x4185, { 0x9b, 0xeb, 0xd4, 0x54, 0xd3, 0xb1, 0xcf, 0x7d } };

// {993828F1-D8CA-4f9d-ACD6-17A581B1597C}
static const GUID IID_IFraunhoferWriterInterface = 
{ 0x993828f1, 0xd8ca, 0x4f9d, { 0xac, 0xd6, 0x17, 0xa5, 0x81, 0xb1, 0x59, 0x7c } };


// {0B76D3B5-01FD-48d0-9BB4-338B46D983A0}
static const GUID CLSID_EcoDecoLameWriter =
{ 0x0b76d3b5, 0x01fd, 0x48d0, { 0x9b, 0xb4, 0x33, 0x8b, 0x46, 0xd9, 0x83, 0xa0 } };

// {40F60711-37BB-4d40-93D7-13A764871AAE}
static const GUID IID_ILameWriterInterface = 
{ 0x40f60711, 0x37bb, 0x4d40, { 0x93, 0xd7, 0x13, 0xa7, 0x64, 0x87, 0x1a, 0xae } };


static const GUID WMMEDIASUBTYPE_MP3 = 
{ 0x00000055, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 } }; 

// ------------------------------------------------------------------------------------------------------------------------
struct ENUMDATA
{
   int nBitrate;
   HACMDRIVERID hadid;
   WAVEFORMATEX inFormat;
   MPEGLAYER3WAVEFORMAT outFormat;
};
// ------------------------------------------------------------------------------------------------------------------------
typedef struct
{
   int nMode;
   int nQuality;

   struct
   {
      DWORD dwBitrate;
   } abr;

   struct
   {
      DWORD dwBitrate;
   } cbr;

   struct
   {
      int nVBRQuality;
      DWORD dwMinBitrate;
      DWORD dwMaxBitrate;
   } vbr;
} LAME_CONFIG, *PLAME_CONFIG;
// ------------------------------------------------------------------------------------------------------------------------
// fR[hݒC^[tFCX
__interface
__declspec(uuid("{16F5105B-7322-4a62-9284-992DD186F6A1}"))
IMp3DecInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(void *);
   STDMETHODIMP GetOutFormat(void *);
   STDMETHODIMP SetOutFormat(void *);
};
// ------------------------------------------------------------------------------------------------------------------------
// FraunhoferGR[hݒC^[tFCX
__interface
__declspec(uuid("{60DE31EA-E970-4ed7-8FD4-991C29206462}"))
IFraunhoferWriterInterface : public IUnknown
{
public:
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, int);
   STDMETHODIMP SetBitrate(int);
   STDMETHODIMP SetFileName(WCHAR *);
};
// ------------------------------------------------------------------------------------------------------------------------
// o͐ݒC^[tFCX
__interface
__declspec(uuid("{00465F16-8051-4024-97FA-835E05A19AD2}"))
ILameWriterInterface : public IUnknown
{
public:
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, void *);
   STDMETHODIMP SetOutFormat(void *);
   STDMETHODIMP SetFileName(WCHAR *);
};
// ------------------------------------------------------------------------------------------------------------------------
class CMp3Dec : public CTransformFilter, public IMp3DecInterface
{
public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CMp3Dec(LPUNKNOWN pUnk,HRESULT *phr);
   virtual ~CMp3Dec();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // CTransformFilteȑz\bh
   HRESULT CheckInputType(const CMediaType *);
   HRESULT CheckTransform(const CMediaType *,const CMediaType *);
   HRESULT GetMediaType(int iPosition,CMediaType *);
   HRESULT DecideBufferSize(IMemAllocator *, ALLOCATOR_PROPERTIES *);

   // CTransformFilter̃I[o[Ch
   HRESULT StartStreaming(void);
   HRESULT Receive(IMediaSample *);
   HRESULT StopStreaming();
   HRESULT BeginFlush();
   HRESULT EndOfStream(void);
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);

   // IaoTuvDecInterface
   STDMETHODIMP GetInFormat(void *);
   STDMETHODIMP GetOutFormat(void *);
   STDMETHODIMP SetOutFormat(void *);

   // [U֐
   bool ID3v1TagExists(BYTE *, int);
   int GetFramePos(BYTE *, int, int);

private:

   // [Uϐ
   CCritSec m_myLock;
   CPosPassThru *m_pPosition;

   mpg123 *m_pMpg123;

   bool m_bFirstReceive;
   LONGLONG m_llTotalOutSize;

   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;
};
// ------------------------------------------------------------------------------------------------------------------------
class CAcmFraunhofer
{
public:

   // RXgN^ƃfXgN^
   CAcmFraunhofer();
   ~CAcmFraunhofer();

   // R[obN֐
   static BOOL CALLBACK AcmDriverEnumCallback(HACMDRIVERID, DWORD, DWORD);

   // [U֐
   HRESULT CheckFormat(WAVEFORMATEX *, int);
   HRESULT ConvertInit(WAVEFORMATEX *, int, int);
   HRESULT Convert(HANDLE, BYTE *, int);
   HRESULT ConvertEnd(HANDLE);

private:

   // [Uϐ
   HACMDRIVER m_hDriver;
   HACMSTREAM m_hStream;
   ACMSTREAMHEADER m_acmHeader;

   ENUMDATA m_enumData;

   BYTE *m_pInBuffer;
   BYTE *m_pOutBuffer;
};
// ------------------------------------------------------------------------------------------------------------------------
class CFraunhoferWriterInputPin: public CRenderedInputPin
{
   friend class CFraunhoferWriter;
   friend class CAcmFraunhofer;

public:

   // RXgN^ƃfXgN^
   CFraunhoferWriterInputPin(CFraunhoferWriter *, LPUNKNOWN, CCritSec *, CCritSec *, HRESULT *);
   ~CFraunhoferWriterInputPin();

   // CRenderedInputPin(CBasePin)̏z\bh
   virtual HRESULT CheckMediaType(const CMediaType *);

   // CRenderedInputPiñI[o[Ch
   STDMETHODIMP Receive(IMediaSample *);
   STDMETHODIMP EndOfStream(void);
   STDMETHODIMP ReceiveCanBlock() { return S_FALSE;}
   HRESULT BreakConnect();

   STDMETHODIMP NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate)
   {
      return S_OK;
   }

   // IFraunhoferWriterInterface
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, int);
   STDMETHODIMP SetBitrate(int);
   STDMETHODIMP SetFileName(WCHAR *);

   // [U֐
   HRESULT StartStreaming();
   HRESULT SetFileName(LPCOLESTR);
   HRESULT Stop();

private:

   // [Uϐ
   HANDLE m_hFile;
   CFraunhoferWriter * const m_pFilter;
   CCritSec *m_pReceiveLock;
   WCHAR m_awFileName[MAX_PATH];

   WAVEFORMATEX m_inFormat;

   int m_nBitrate;
   CAcmFraunhofer *m_pAcmFraunhofer;

};
// ------------------------------------------------------------------------------------------------------------------------
class CFraunhoferWriter : public CBaseFilter, public IFraunhoferWriterInterface
{
   friend class CFraunhoferWriterInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CFraunhoferWriter(LPUNKNOWN,HRESULT *);
   ~CFraunhoferWriter();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);
   STDMETHODIMP Pause();
   STDMETHODIMP Stop();

   // IFraunhoferWriterInterface
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, int);
   STDMETHODIMP SetBitrate(int);
   STDMETHODIMP SetFileName(WCHAR *);

private:

   // [Uϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CFraunhoferWriterInputPin *m_pInputPin;
   CPosPassThru *m_pPosition;
};
// ------------------------------------------------------------------------------------------------------------------------
class CLameWriterInputPin : public CRenderedInputPin
{
   friend class CLameWriter;

public:

   // RXgN^ƃfXgN^
   CLameWriterInputPin(CLameWriter *, LPUNKNOWN, CCritSec *, CCritSec *, HRESULT *);
   ~CLameWriterInputPin();

   // CRenderedInputPin(CBasePin)̏z\bh
   virtual HRESULT CheckMediaType(const CMediaType *);

   // CRenderedInputPiñI[o[Ch
   STDMETHODIMP Receive(IMediaSample *);
   STDMETHODIMP EndOfStream(void);
   STDMETHODIMP ReceiveCanBlock() { return S_FALSE;}
   HRESULT BreakConnect();

   STDMETHODIMP NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate)
   {
      return S_OK;
   }

   // ILameWriterInterface
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, void *);
   STDMETHODIMP SetOutFormat(void *);
   STDMETHODIMP SetFileName(WCHAR *);

   // [U֐
   HRESULT StartStreaming();
   HRESULT SetFileName(LPCOLESTR);
   HRESULT Stop();

private:

   // [Uϐ
   HANDLE m_hFile;
   CLameWriter * const m_pFilter;
   CCritSec *m_pReceiveLock;
   WCHAR m_awFileName[MAX_PATH];
   WAVEFORMATEX m_inFormat;

   HINSTANCE m_hDLL;
   HBE_STREAM m_hbeStream;
   BE_CONFIG m_beConfig;
   LAME_CONFIG m_lameConfig;
   PBYTE m_pMP3Buffer;
   int m_nMaxBuffer;
   int m_nCurrentPos;

   BEINITSTREAM     beInitStream;
   BEENCODECHUNK    beEncodeChunk;
   BEDEINITSTREAM   beDeinitStream;
   BECLOSESTREAM    beCloseStream;
   BEVERSION        beVersion;
   BEWRITEVBRHEADER beWriteVBRHeader;
   BEWRITEINFOTAG   beWriteInfoTag;

   // [U֐
   void SetConfig(BE_CONFIG *, LAME_CONFIG *, WAVEFORMATEX *);
};
// ------------------------------------------------------------------------------------------------------------------------
class CLameWriter : public CBaseFilter, public ILameWriterInterface
{
   friend class CLameWriterInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CLameWriter(LPUNKNOWN,HRESULT *);
   ~CLameWriter();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);
   STDMETHODIMP Pause();
   STDMETHODIMP Stop();

   // ILameWriterInterface
   STDMETHODIMP CheckBitrate(WAVEFORMATEX *, void *);
   STDMETHODIMP SetOutFormat(void *);
   STDMETHODIMP SetFileName(WCHAR *);

private:

   // [Uϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CLameWriterInputPin *m_pInputPin;
   CPosPassThru *m_pPosition;

};
// ------------------------------------------------------------------------------------------------------------------------

#endif _EcoDecoMp3_h_
