/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/
#include "EcoDecoVorbis.h"

// -----------------------------------------------------------------------------------------------------------------------------------
void CBitConv::Initialize(WAVEFORMATEX *pOutFormat, double dGain)
{
   ::CopyMemory(&m_outFormat, pOutFormat, sizeof(m_outFormat));

   if(m_outFormat.wFormatTag == WAVE_FORMAT_PCM)
   {
      if(m_outFormat.wBitsPerSample == 8)
      {
         m_dMinData = -128.0;
         m_dMaxData =  127.0;
      }
      else if(m_outFormat.wBitsPerSample == 16)
      {
         m_dMinData = -32767.5;
         m_dMaxData =  32766.5;
      }
      else if(m_outFormat.wBitsPerSample == 24)
      {
         m_dMinData = -8388607.5;
         m_dMaxData =  8388606.5;
      }
      else // if(m_outFormat.wBitsPerSample == 32)
      {
         m_dMinData = -2147483647.5;
         m_dMaxData =  2147483646.5;
      }

      m_dRatioPlus  = dGain * pow(2.0, m_outFormat.wBitsPerSample-1) - 1;
      m_dRatioMinus = dGain * pow(2.0, m_outFormat.wBitsPerSample-1);
   }
   else // if(m_outFormat.wFormatTag == WAVE_FORMAT_IEEE_FLOAT)
   {
      m_dMinData = -1.0;
      m_dMaxData =  1.0;

      m_dRatioPlus = dGain;
      m_dRatioMinus = dGain;
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
void CBitConv::ConvertTo8I(BYTE *pbOutBuffer, float **ppInBuffer, int nSampleSize)
{  // 32bit()8bit()

   int i, j;
   double dData;

   for(i=0;i<nSampleSize;i++)
   {
      for(j=0;j<m_outFormat.nChannels;j++)
      {
         if(ppInBuffer[j][i] > 0.0f)
         {
            dData = (double)ppInBuffer[j][i] * m_dRatioPlus;

            if(dData > m_dMaxData)
               dData = m_dMaxData;

            *pbOutBuffer = BYTE(dData + 128.0);
            pbOutBuffer++;
         }
         else
         {
            dData = (double)ppInBuffer[j][i] * m_dRatioMinus;

            if(dData < m_dMinData)
               dData = m_dMinData;

            *pbOutBuffer = BYTE(dData + 128.0);
            pbOutBuffer++;
         }
      }
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
void CBitConv::ConvertTo16I(short *pbOutBuffer, float **ppInBuffer, int nSampleSize)
{  // 32bit()16bit()
   int i;
   double dData;

   if(m_outFormat.nChannels == 2)
   {  // XeȈꍇ
      for(i=0;i<nSampleSize;i++)
      {
         if(ppInBuffer[0][i] > 0.0f)
         {
            dData = (double)ppInBuffer[0][i] * m_dRatioPlus;

            if(dData > m_dMaxData)
               dData = m_dMaxData;

            *pbOutBuffer = short(dData + 0.5);
            pbOutBuffer++;
         }
         else
         {
            dData = (double)ppInBuffer[0][i] * m_dRatioMinus;

            if(dData < m_dMinData)
               dData = m_dMinData;

            *pbOutBuffer = short(dData - 0.5);
            pbOutBuffer++;
         }

         if(ppInBuffer[1][i] > 0.0f)
         {
            dData = (double)ppInBuffer[1][i] * m_dRatioPlus;

            if(dData > m_dMaxData)
               dData = m_dMaxData;

            *pbOutBuffer = short(dData + 0.5);
            pbOutBuffer++;
         }
         else
         {
            dData = (double)ppInBuffer[1][i] * m_dRatioMinus;

            if(dData < m_dMinData)
               dData = m_dMinData;

            *pbOutBuffer = short(dData - 0.5);
            pbOutBuffer++;
         }
      }
   }
   else
   {  // m̏ꍇ
      for(i=0;i<nSampleSize;i++)
      {
         if(ppInBuffer[0][i] > 0.0f)
         {
            dData = (double)ppInBuffer[0][i] * m_dRatioPlus;

            if(dData > m_dMaxData)
               dData = m_dMaxData;

            *pbOutBuffer = short(dData + 0.5);
            pbOutBuffer++;
         }
         else
         {
            dData = (double)ppInBuffer[0][i] * m_dRatioMinus;

            if(dData < m_dMinData)
               dData = m_dMinData;

            *pbOutBuffer = short(dData - 0.5);
            pbOutBuffer++;
         }
      }
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
void CBitConv::ConvertTo24I(BYTE *pbOutBuffer, float **ppInBuffer, int nSampleSize)
{  // 32bit()24bit()

   int i, j, nData;
   double dData;

   for(i=0;i<nSampleSize;i++)
   {
      for(j=0;j<m_outFormat.nChannels;j++)
      {
         if(ppInBuffer[j][i] > 0.0f)
         {
            dData = (double)ppInBuffer[j][i] * m_dRatioPlus;

            if(dData > m_dMaxData)
               dData = m_dMaxData;

            nData = int(dData + 0.5);
         }
         else
         {
            dData = (double)ppInBuffer[j][i] * m_dRatioMinus;

            if(dData < m_dMinData)
               dData = m_dMinData;

            nData = int(dData - 0.5);
         }

         *pbOutBuffer = nData;
         pbOutBuffer++;

         *pbOutBuffer = nData >> 8;
         pbOutBuffer++;

         *pbOutBuffer = nData >> 16; 
         pbOutBuffer++;
      }
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
void CBitConv::ConvertTo32I(int *pbOutBuffer, float **ppInBuffer, int nSampleSize)
{  // 32bit()32bit()

   int i, j;
   double dData;

   for(i=0;i<nSampleSize;i++)
   {
      for(j=0;j<m_outFormat.nChannels;j++)
      {
         if(ppInBuffer[j][i] > 0.0f)
         {
            dData = (double)ppInBuffer[j][i] * m_dRatioPlus;

            if(dData > m_dMaxData)
               dData = m_dMaxData;

            *pbOutBuffer = int(dData + 0.5);
            pbOutBuffer++;
         }
         else
         {
            dData = (double)ppInBuffer[j][i] * m_dRatioMinus;

            if(dData < m_dMinData)
               dData = m_dMinData;

            *pbOutBuffer = int(dData - 0.5);
            pbOutBuffer++;
         }
      }
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
void CBitConv::ConvertTo32F(float *pbOutBuffer, float **ppInBuffer, int nSampleSize)
{  // 32bit()32bit()

   int i, j;

   if(m_dRatioPlus == 1.0)
   {
      for(i=0;i<nSampleSize;i++)
      {
         for(j=0;j<m_outFormat.nChannels;j++)
         {
            if(ppInBuffer[j][i] > 1.0f)
               ppInBuffer[j][i] = 1.0f;

            if(ppInBuffer[j][i] < -1.0f)
               ppInBuffer[j][i] = -1.0f;

            *pbOutBuffer = ppInBuffer[j][i];
            pbOutBuffer++;
         }
      }
   }
   else
   {
      for(i=0;i<nSampleSize;i++)
      {
         for(j=0;j<m_outFormat.nChannels;j++)
         {
            ppInBuffer[j][i] = (float)(ppInBuffer[j][i] * m_dRatioPlus);

            if(ppInBuffer[j][i] > 1.0f)
               ppInBuffer[j][i] = 1.0f;

            if(ppInBuffer[j][i] < -1.0f)
               ppInBuffer[j][i] = -1.0f;

            *pbOutBuffer = ppInBuffer[j][i];
            pbOutBuffer++;
         }
      }
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
void CBitConv::ConvertTo64D(double *pbOutBuffer, float **ppInBuffer, int nSampleSize)
{  // 32bit()64bit()

   int i, j;
   double dData;

   if(m_dRatioPlus == 1.0)
   {
      for(i=0;i<nSampleSize;i++)
      {
         for(j=0;j<m_outFormat.nChannels;j++)
         {
            if(ppInBuffer[j][i] > 1.0f)
               ppInBuffer[j][i] = 1.0f;

            if(ppInBuffer[j][i] < -1.0f)
               ppInBuffer[j][i] = -1.0f;

            *pbOutBuffer = (double)ppInBuffer[j][i];
            pbOutBuffer++;
         }
      }
   }
   else
   {
      for(i=0;i<nSampleSize;i++)
      {
         for(j=0;j<m_outFormat.nChannels;j++)
         {
            dData = ppInBuffer[j][i] * m_dRatioPlus;

            if(dData > 1.0f)
               dData = 1.0f;

            if(dData < -1.0f)
               dData = -1.0f;

            *pbOutBuffer = dData;
            pbOutBuffer++;
         }
      }
   }
}
// -----------------------------------------------------------------------------------------------------------------------------------
