/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#include "EcoDecoVorbis.h"

#define ENCODE_BUFFER_SIZE 32768

// ------------------------------------------------------------------------------------------------------------------------
void CaoTuVEnc::SJIStoUTF8(char *pcText, int nArraySize)
{  // VtgJISUTF8ɕϊ

   if(nArraySize <= 0)
      return;

   int nLen = MultiByteToWideChar(CP_ACP, 0, (LPCSTR)pcText, -1, NULL, NULL);

   WCHAR *pwTempBuf = new WCHAR[nLen];

   // VtgJIS  Unicode
   MultiByteToWideChar(CP_ACP, 0, (LPCSTR)pcText, -1, (LPWSTR)pwTempBuf, nLen);

   // Unicode  UTF8
   WideCharToMultiByte(CP_UTF8, 0, (LPCWSTR)pwTempBuf, -1, (LPSTR)pcText, nArraySize, NULL, NULL);

}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuVEnc::EncodeInit(WCHAR *pwFileName, VORBISFORMAT *pVorbisFormat, VORBISTAG *pVorbisTag)
{  // OggVorbisGR[hƂ̏
   int eos = 0, ret;

   // vorbis
   vorbis_info_init(&m_vi);

   if(-0.11f <= pVorbisFormat->fQuality && pVorbisFormat->fQuality <= 1.01f)
   {  // VBȐ
      ret = vorbis_encode_init_vbr(&m_vi, (long)pVorbisFormat->nChannels, pVorbisFormat->nSamplesPerSec, pVorbisFormat->fQuality);
   }
   else
   {  // ABR,CBȐ
      ret = vorbis_encode_init(&m_vi, (long)pVorbisFormat->nChannels, pVorbisFormat->nSamplesPerSec, pVorbisFormat->nMaxBitsPerSec, pVorbisFormat->nAvgBitsPerSec, pVorbisFormat->nMinBitsPerSec);
   }

   if(ret != 0)
   {  // Ɏsꍇ

      vorbis_info_clear(&m_vi);
      return E_FAIL;
   }

   // vorbis̃^Ot
   vorbis_comment_init(&m_vc);

   if(pVorbisTag != NULL)
   {
      if(pVorbisTag->acTitle[0] != '\0')
      {
         SJIStoUTF8(pVorbisTag->acTitle, sizeof(pVorbisTag->acTitle));
         vorbis_comment_add_tag(&m_vc, "TITLE", pVorbisTag->acTitle);
      }

      if(pVorbisTag->acArtist[0] != '\0')
      {
         SJIStoUTF8(pVorbisTag->acArtist, sizeof(pVorbisTag->acArtist));
         vorbis_comment_add_tag(&m_vc, "ARTIST", pVorbisTag->acArtist);
      }

      if(pVorbisTag->acAlbum[0] != '\0')
      {
         SJIStoUTF8(pVorbisTag->acAlbum, sizeof(pVorbisTag->acAlbum));
         vorbis_comment_add_tag(&m_vc, "ALBUM", pVorbisTag->acAlbum);
      }

      if(pVorbisTag->acTrackNumber[0] != '\0')
      {
         SJIStoUTF8(pVorbisTag->acTrackNumber, sizeof(pVorbisTag->acTrackNumber));
         vorbis_comment_add_tag(&m_vc, "TRACKNUMBER", pVorbisTag->acTrackNumber);
      }

      if(pVorbisTag->acDate[0] != '\0')
      {
         SJIStoUTF8(pVorbisTag->acDate, sizeof(pVorbisTag->acDate));
         vorbis_comment_add_tag(&m_vc, "DATE", pVorbisTag->acDate);
      }

      if(pVorbisTag->acGenre[0] != '\0')
      {
         SJIStoUTF8(pVorbisTag->acGenre, sizeof(pVorbisTag->acGenre));
         vorbis_comment_add_tag(&m_vc, "GENRE", pVorbisTag->acGenre);
      }

      if(pVorbisTag->acComment[0] != '\0')
      {
         SJIStoUTF8(pVorbisTag->acComment, sizeof(pVorbisTag->acComment));
         vorbis_comment_add_tag(&m_vc, "COMMENT", pVorbisTag->acComment);
      }
   }

   // m_vd̏
   vorbis_analysis_init(&m_vd, &m_vi);
   vorbis_block_init(&m_vd, &m_vb);

   // o̓t@Cłɑ݂Ȃ폜
   if(::PathFileExists(pwFileName) != FALSE)
   {
      if(::DeleteFile(pwFileName) == FALSE)
      {  // t@CbNȂAt@Co͂łȂ

         vorbis_info_clear(&m_vi);
         return (HRESULT)GetLastError();
      }
   }

   // o̓t@CVKɍ쐬
   m_hFile = ::CreateFile(pwFileName, GENERIC_WRITE, 0, NULL, CREATE_ALWAYS, (DWORD)0, NULL);
   if(m_hFile == INVALID_HANDLE_VALUE)
      return (HRESULT)INVALID_HANDLE_VALUE;

   // ogg̃wb_t@Cɏo͂  
   srand((unsigned int)time(NULL));
   ogg_stream_init(&m_os, rand());

   ogg_packet header;
   ogg_packet header_comm;
   ogg_packet header_code;

   vorbis_analysis_headerout(&m_vd, &m_vc, &header, &header_comm, &header_code);
   ogg_stream_packetin(&m_os, &header);
   ogg_stream_packetin(&m_os, &header_comm);
   ogg_stream_packetin(&m_os, &header_code);

   while(!eos)
   {
      int result = ogg_stream_flush(&m_os, &m_og);

      if(result==0)
         break;

      BOOL flag;
      DWORD dwWriteSize;

      flag = ::WriteFile(m_hFile , (LPVOID)m_og.header, m_og.header_len, &dwWriteSize , NULL);
      if(flag == FALSE)
      {
         vorbis_info_clear(&m_vi);
         return (HRESULT)GetLastError();
      }

      flag = ::WriteFile(m_hFile , (LPVOID)m_og.body, m_og.body_len, &dwWriteSize , NULL);
      if(flag == FALSE)
      {
         vorbis_info_clear(&m_vi);
         return (HRESULT)GetLastError();
      }
   }

   // `li[
   m_nChannels = (int)pVorbisFormat->nChannels;

   return S_OK;
}
// -----------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuVEnc::Encode(int nBufferSize)
{  // GR[h

   int eos = 0;

   vorbis_analysis_wrote(&m_vd, nBufferSize);

   while(vorbis_analysis_blockout(&m_vd, &m_vb)==1)
   {
      vorbis_analysis(&m_vb, NULL);
      vorbis_bitrate_addblock(&m_vb);

      while(vorbis_bitrate_flushpacket(&m_vd, &m_op))
      {
         ogg_stream_packetin(&m_os, &m_op);
    
         while(!eos)
         {
            int result = ogg_stream_pageout(&m_os, &m_og);
            if(result == 0)
               break;

            BOOL flag;
            DWORD dwWriteSize;

            flag = ::WriteFile(m_hFile , (LPVOID)m_og.header, m_og.header_len, &dwWriteSize , NULL);
            if(flag == FALSE) return E_FAIL;

            flag = ::WriteFile(m_hFile , (LPVOID)m_og.body, m_og.body_len, &dwWriteSize , NULL);
            if(flag == FALSE) return E_FAIL;

            if(ogg_page_eos(&m_og))
               eos = 1;
         }
      }
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuVEnc::Receive(short *psSrc, int nSrcLength)
{
   HRESULT hr;
   float **ppfBuffer;

   if(m_nChannels == 1)
   {  // m̏ꍇ

      int nBufSize;

      while(nSrcLength > 0)
      {
         if(nSrcLength >= ENCODE_BUFFER_SIZE)
            nBufSize = ENCODE_BUFFER_SIZE;
         else
            nBufSize = nSrcLength;

         ppfBuffer = vorbis_analysis_buffer(&m_vd, nBufSize);

         // ppfBufferɃf[^ړ
         for(int i=0;i<nBufSize;i++)
         {
            ppfBuffer[0][i] = *psSrc / 32768.f;
            *psSrc++;
         }

         // GR[hs
         hr = Encode(nBufSize);
         if(FAILED(hr))
            return hr;

         nSrcLength -= nBufSize;
      }

   }
   else
   {  // XeȈꍇ

      int nBufSize, nBufHalfSize;

      while(nSrcLength > 0)
      {
         if(nSrcLength >= ENCODE_BUFFER_SIZE)
            nBufSize = ENCODE_BUFFER_SIZE;
         else
            nBufSize = nSrcLength;

         nBufHalfSize = nBufSize / 2;

         // ppfBufferɃf[^ړ
         ppfBuffer = vorbis_analysis_buffer(&m_vd, nBufSize);

         for(int i=0;i<nBufHalfSize;i++)
         {
            ppfBuffer[0][i] = *psSrc / 32768.f;
            *psSrc++;
            ppfBuffer[1][i] = *psSrc / 32768.f;
            *psSrc++;
         }

         // GR[hs
         hr = Encode(nBufHalfSize);
         if(FAILED(hr))
            return hr;

         nSrcLength -= nBufSize;
      }
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
HRESULT CaoTuVEnc::EncodeEnd()
{
   // obt@ɂ܂cĂf[^̃GR[hs
   Encode(0);

   // ogg vorbiš㏈
   ogg_stream_clear(&m_os);
   vorbis_block_clear(&m_vb);
   vorbis_dsp_clear(&m_vd);
   vorbis_comment_clear(&m_vc);
   vorbis_info_clear(&m_vi);

   // t@C
   if(m_hFile != NULL)
   {
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }

   return S_OK;
}
// ------------------------------------------------------------------------------------------------------------------------
CaoTuVEnc::CaoTuVEnc()
{  // CaoTuVEnc̃RXgN^

   m_hFile = NULL;
}
// ------------------------------------------------------------------------------------------------------------------------
CaoTuVEnc::~CaoTuVEnc()
{  // CaoTuVEnc̃fXgN^

   // t@C
   if(m_hFile != NULL)
   {
      ::CloseHandle(m_hFile);
      m_hFile = NULL;
   }
}
// ------------------------------------------------------------------------------------------------------------------------
