/**************************************************************************
 * Copyright (C) 2008 Cocha                                               *
 * http://sourceforge.jp/projects/ecodecotool/                            *
 *                                                                        *
 *  This Program is free software; you can redistribute it and/or modify  *
 *  it under the terms of the GNU General Public License as published by  *
 *  the Free Software Foundation; either version 2, or (at your option)   *
 *  any later version.                                                    *
 *                                                                        *
 *  This Program is distributed in the hope that it will be useful,       *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *  GNU General Public License for more details.                          *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with GNU Make; see the file COPYING.  If not, write to          *
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. *
 *                                                                        *
 **************************************************************************/

#ifndef _EcoDecoVorbis_h_
#define _EcoDecoVorbis_h_

#include <windows.h>
#include <math.h>
#include <time.h>
#include <shlwapi.h>
#include <commctrl.h>
#include <streams.h>

#include "vorbis/vorbisenc.h"

#define FILTER_AOTUVDEC_NAME    L"aoTuv Decoder"
#define FILTER_AOTUVWRITER_NAME L"aoTuv Writer"

#define WAVE_FORMAT_IEEE_FLOAT 3
#define SAFE_RELEASE(p) { if(p!=NULL) { (p)->Release(); (p)=NULL; } }

// {733B2BDE-28E8-4dbb-BA68-367D45C077F6}
static const GUID CLSID_aoTuvDec = 
{ 0x733b2bde, 0x28e8, 0x4dbb, { 0xba, 0x68, 0x36, 0x7d, 0x45, 0xc0, 0x77, 0xf6 } };

// {1AFACF98-9BAA-4545-9099-75E5519CA0BD}
static const GUID CLSID_aoTuvWriter = 
{ 0x1afacf98, 0x9baa, 0x4545, { 0x90, 0x99, 0x75, 0xe5, 0x51, 0x9c, 0xa0, 0xbd } };

// {BD7DAEC2-193E-4a6a-B9D3-476D8C929B35}
static const GUID IID_IaoTuvWriterInterface = 
{ 0xbd7daec2, 0x193e, 0x4a6a, { 0xb9, 0xd3, 0x47, 0x6d, 0x8c, 0x92, 0x9b, 0x35 } };

// {4559B935-767F-4549-B325-7B493C4CAF49}
static const GUID IID_IaoTuvDecInterface = 
{ 0x4559b935, 0x767f, 0x4549, { 0xb3, 0x25, 0x7b, 0x49, 0x3c, 0x4c, 0xaf, 0x49 } };

// {D2855FA9-61A7-4db0-B979-71F297C17A04}
static const GUID MEDIASUBTYPE_Ogg =
{ 0xd2855fa9, 0x61a7, 0x4db0, { 0xb9, 0x79, 0x71, 0xf2, 0x97, 0xc1, 0x7a, 0x04} };

// cddca2d5-6d75-4f98-840e-737bedd5c63b
static const GUID MEDIASUBTYPE_Vorbis =
{ 0xcddca2d5, 0x6d75, 0x4f98, { 0x84, 0x0e, 0x73, 0x7b, 0xed, 0xd5, 0xc6, 0x3b} };

// 6bddfa7e-9f22-46a9-ab5e-884eff294d9f
static const GUID FORMAT_VorbisFormat =
{ 0x6bddfa7e, 0x9f22, 0x46a9, { 0xab, 0x5e, 0x88, 0x4e, 0xff, 0x29, 0x4d, 0x9f} };
// ------------------------------------------------------------------------------------------------------------------------
typedef struct tagVORBISFORMAT
{
	WORD  nChannels;
	long  nSamplesPerSec;
	long  nMinBitsPerSec;
	long  nAvgBitsPerSec;
	long  nMaxBitsPerSec;
	float fQuality;
} VORBISFORMAT;

typedef struct tagVORBISTAG
{
   char acTitle[256];
   char acArtist[256];
   char acAlbum[256];
   char acTrackNumber[256];
   char acDate[256];
   char acGenre[256];
   char acComment[256];
} VORBISTAG;
// ------------------------------------------------------------------------------------------------------------------------
// GR[hݒC^[tFCX
__interface
__declspec(uuid("{16F5105B-7322-4a62-9284-992DD186F6A1}"))
IaoTuVWriterInterface : public IUnknown
{
public:
   STDMETHODIMP SetVorbisFormat(void *);
   STDMETHODIMP GetVorbisFormat(void *);
   STDMETHODIMP SetVorbisTag(void *);
   STDMETHODIMP SetFileName(WCHAR *);
};
// ------------------------------------------------------------------------------------------------------------------------
// fR[hݒC^[tFCX
__interface
__declspec(uuid("{635001D9-A56C-4724-996E-3B2AD67FCDDB}"))
IaoTuvDecInterface : public IUnknown
{
public:
   STDMETHODIMP GetInFormat(void *);
   STDMETHODIMP GetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetOutBitsPerSample(WORD, WORD);
};
// ------------------------------------------------------------------------------------------------------------------------
class CBitConv
{
public:

   void Initialize(WAVEFORMATEX *, double);
   void ConvertTo8I(BYTE *, float **, int);
   void ConvertTo16I(short *, float **, int);
   void ConvertTo24I(BYTE *, float **, int);
   void ConvertTo32I(int *, float **, int);
   void ConvertTo32F(float *, float **, int);
   void ConvertTo64D(double *, float **, int);

private:

   WAVEFORMATEX m_outFormat;

   double m_dMinData, m_dMaxData;
   double m_dRatioPlus, m_dRatioMinus;
};
// ------------------------------------------------------------------------------------------------------------------------
class CaoTuVDec : public CTransformFilter, public IaoTuvDecInterface
{
   friend class CBitConv;
   friend class CaoTuVDecInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CaoTuVDec(LPUNKNOWN pUnk,HRESULT *phr);
   virtual ~CaoTuVDec();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // CTransformFilteȑz\bh
   HRESULT CheckInputType(const CMediaType *);
   HRESULT CheckTransform(const CMediaType *,const CMediaType *);
   HRESULT GetMediaType(int iPosition,CMediaType *);
   HRESULT DecideBufferSize(IMemAllocator *, ALLOCATOR_PROPERTIES *);

   // CTransformFilter̃I[o[Ch
   HRESULT StartStreaming(void);
   HRESULT Receive(IMediaSample *);
   HRESULT StopStreaming();
   HRESULT BeginFlush();
   HRESULT EndOfStream(void);
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);

   // IaoTuvDecInterface
   STDMETHODIMP GetInFormat(void *);
   STDMETHODIMP GetOutFormat(WAVEFORMATEX *);
   STDMETHODIMP SetOutBitsPerSample(WORD, WORD);

   // [U֐
   void HeaderInitialize(void);
   void BlockInitialize(void);
   void ReceiveHeader(BYTE *, int);
   HRESULT Decode(IMediaSample *, bool);

private:

   // [Uϐ
   CCritSec m_myLock;

   CBitConv *pBitConv;
   bool m_bHeaderInitialized;
   bool m_bBlockInitialized;
   int m_nPacketNumber;
   bool m_bUseRatio;
   double m_dGain;

   VORBISFORMAT m_inFormat;
   WAVEFORMATEX m_outFormat;

   vorbis_block     m_vb;
   vorbis_comment   m_vc;
   vorbis_dsp_state m_vd;
   vorbis_info      m_vi;
};
// ------------------------------------------------------------------------------------------------------------------------
class CaoTuVEnc
{
public:

   // RXgN^ƃfXgN^
   CaoTuVEnc();
   ~CaoTuVEnc();

   // [U֐
   HRESULT EncodeInit(WCHAR *, VORBISFORMAT *, VORBISTAG *);
   HRESULT Encode(int);
   HRESULT Receive(short *, int);
   HRESULT EncodeEnd();
   HRESULT SetFileName(WCHAR *);

private:

   // [U֐
   void SJIStoUTF8(char *, int);

   // gpϐ
   ogg_stream_state m_os;
   ogg_page         m_og;
   ogg_packet       m_op;
   vorbis_info      m_vi;
   vorbis_comment   m_vc;
   vorbis_dsp_state m_vd;
   vorbis_block     m_vb;

   HANDLE m_hFile;
   int m_nChannels;
};
// ------------------------------------------------------------------------------------------------------------------------
class CaoTuVWriterInputPin : public CRenderedInputPin
{
   friend class CaoTuVEncode;
   friend class CaoTuVWriter;

public:

   // RXgN^ƃfXgN^
   CaoTuVWriterInputPin(CaoTuVWriter *, LPUNKNOWN, CCritSec *, CCritSec *, HRESULT *);
   ~CaoTuVWriterInputPin();

   // CRenderedInputPin(CBasePin)̏z\bh
   virtual HRESULT CheckMediaType(const CMediaType *);

   // CRenderedInputPiñI[o[Ch
   STDMETHODIMP Receive(IMediaSample *);
   STDMETHODIMP EndOfStream(void);
   HRESULT Stop();
   STDMETHODIMP ReceiveCanBlock() { return S_FALSE;}
   HRESULT BreakConnect();

   STDMETHODIMP NewSegment(REFERENCE_TIME tStart, REFERENCE_TIME tStop, double dRate)
   {
      return S_OK;
   }

   // [U֐
   HRESULT SetVorbisFormat(VORBISFORMAT *);
   HRESULT GetVorbisFormat(VORBISFORMAT *);
   HRESULT SetVorbisTag(VORBISTAG *);
   HRESULT SetFileName(LPCOLESTR);
   HRESULT SetFileName(WCHAR *);

private:

   // gpϐ
   CaoTuVWriter * const m_pFilter;
   CCritSec *m_pReceiveLock;
   WAVEFORMATEX m_InputWaveFormatEx;
   CaoTuVEnc *paoTuVEnc;
   VORBISFORMAT m_VorbisFormat;
   VORBISTAG m_VorbisTag;
   bool m_bInitialize;
};
// ------------------------------------------------------------------------------------------------------------------------
class CaoTuVWriter : public CBaseFilter, public IaoTuVWriterInterface
{
   friend class CaoTuVWriterInputPin;

public:
   DECLARE_IUNKNOWN

   // RXgN^ƃfXgN^
   CaoTuVWriter(LPUNKNOWN,HRESULT *);
   ~CaoTuVWriter();

   // IuWFNg쐬֐
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   // CBaseFilteȑz\bh
   virtual CBasePin *GetPin(int n);
   virtual int GetPinCount();

   // CBaseFilter̃I[o[Ch
   STDMETHODIMP NonDelegatingQueryInterface(REFIID, void **);

   // IaoTuvInterfacẽI[o[Ch
   STDMETHODIMP SetVorbisFormat(void *);
   STDMETHODIMP GetVorbisFormat(void *);
   STDMETHODIMP SetVorbisTag(void *);
   STDMETHODIMP SetFileName(WCHAR *);

   // gpϐ
   CPosPassThru *m_pPosition;

private:

   // gpϐ
   CCritSec m_Lock;
   CCritSec m_ReceiveLock;
   CaoTuVWriterInputPin *m_pInputPin;
};
// ------------------------------------------------------------------------------------------------------------------------

#endif _EcoDecoVorbis_h_
