
//
//  ID3v2^O擾
//
//  Written by Otachan
//  http://otachan.com/
//

#include "stdafx.h"

#include "wa_ipc.h"

#include "CommonFunc.h"

#include "in_mpg123.h"

#include "TagInfo.h"
#include "ID3v2Info.h"

extern const char*	GenreList[];

bool
Tag::GetTitleFromID3v2(_TagInfo* TagInfo, _ReplayGainInfo* ReplayGainInfo, const WCHAR* FileName)
{
	::SetLastError(NO_ERROR);

	HANDLE	hF = ::CreateFile(
							TagInfo ? TagInfo->FileName : FileName,
							GENERIC_READ,
							FILE_SHARE_READ,
							NULL,
							OPEN_EXISTING,
							FILE_FLAG_RANDOM_ACCESS,
							NULL);

	if(::GetLastError() != NO_ERROR) return false;

	bool	RetCode;
	bool	FindReplayGainInfo;
	const DWORD	FileSize = ::GetFileSize(hF, NULL);

	if(FileSize >= 10) {
		unsigned char	Tag[10];
		DWORD	ReadByte;

		memset(Tag, '\0', 3);
		::ReadFile(hF, Tag, 10, &ReadByte, NULL);

		bool	FindTag;
		bool	FindTagFooter;
		unsigned char	TagVersion;

		if((*Tag == 'I') &&
				(*(Tag + 1) == 'D') &&
				(*(Tag + 2) == '3') &&
				((TagVersion = *(Tag + 3)) >= 3)) {
			FindTag = true;
			FindTagFooter = false;
		} else {
			memset(Tag, '\0', 3);
			::SetFilePointer(hF, FileSize - 10, NULL, FILE_BEGIN);
			::ReadFile(hF, Tag, 10, &ReadByte, NULL);

			if((*Tag == '3') &&
					(*(Tag + 1) == 'D') &&
					(*(Tag + 2) == 'I') &&
					((TagVersion = *(Tag + 3)) >= 4)) {
				FindTag = true;
				FindTagFooter = true;
			} else {
				FindTag = false;
			}
		}

		if(FindTag) {
			UINT	TagSize =	(*(Tag + 6) << 21) +
								(*(Tag + 7) << 14) +
								(*(Tag + 8) << 7) +
								*(Tag + 9);

			if(FileSize >= (10 + TagSize)) {
				const unsigned char	TagFlag = *(Tag + 5);
				const bool	TagUnsynchronization = (TagFlag & 0x80) != 0;
				const bool	TagExtendedHeader = (TagFlag & 0x40) != 0;
				unsigned char*	TagData = new unsigned char[TagSize];

				if(FindTagFooter) ::SetFilePointer(hF, FileSize - 10 - TagSize, NULL, FILE_BEGIN);
				::ReadFile(hF, TagData, TagSize, &ReadByte, NULL);

				::CloseHandle(hF);

				if(TagUnsynchronization) {
					TagSize = ID3v2DecodeUnsynchronization(TagData, TagSize, true);
				}

				unsigned char*	TagDataPnt = TagData;
				unsigned char*	MaxTagDataPnt = TagDataPnt + TagSize;

				if(TagExtendedHeader) {
					if(TagVersion >= 4) {	// Ver. 2.4
						TagDataPnt +=	(*(TagDataPnt + 0) << 21) +
										(*(TagDataPnt + 1) << 14) +
										(*(TagDataPnt + 2) << 7) +
										*(TagDataPnt + 3);
					} else {				// Ver. 2.3
						TagDataPnt +=	4 +
										(*(TagDataPnt + 0) << 24) +
										(*(TagDataPnt + 1) << 16) +
										(*(TagDataPnt + 2) << 8) +
										*(TagDataPnt + 3);
						MaxTagDataPnt -=	(*(TagDataPnt + 6) << 24) +
											(*(TagDataPnt + 7) << 16) +
											(*(TagDataPnt + 8) << 8) +
											*(TagDataPnt + 9);
					}
				}

				bool	TitleSc = false;
				bool	ArtistSc = false;
				bool	CommentSc = false;
				bool	AlbumSc = false;
				bool	YearSc = false;
				bool	GenreSc = false;
				bool	TrackSc = false;
				bool	ComposerSc = false;
				bool	OrgArtistSc = false;
				bool	CopyrightSc = false;
				bool	EncoderSc = false;
				bool	ReplayGainTrackGainSc = false;
				bool	ReplayGainTrackPeakSc = false;
				bool	ReplayGainAlbumGainSc = false;
				bool	ReplayGainAlbumPeakSc = false;

				while(TagDataPnt < MaxTagDataPnt) {
					const unsigned char FrameID0 = *TagDataPnt++;

					if(FrameID0 == '\0') break;

					const unsigned char FrameID1 = *TagDataPnt++;
					const unsigned char FrameID2 = *TagDataPnt++;
					const unsigned char FrameID3 = *TagDataPnt++;

					const unsigned char	FrameFlag2 = *(TagDataPnt + 5);
					UINT	FrameSize;
					bool	FrameCompression;
					bool	FrameCoded;
					bool	FrameUnsynchronization;

					if(TagVersion >= 4) {	// Ver. 2.4
						FrameSize =	(*(TagDataPnt + 0) << 21) +
									(*(TagDataPnt + 1) << 14) +
									(*(TagDataPnt + 2) << 7) +
									*(TagDataPnt + 3);
						FrameCompression = (FrameFlag2 & 0x08) != 0;
						FrameCoded = (FrameFlag2 & 0x04) != 0;
						FrameUnsynchronization = (FrameFlag2 & 0x02) != 0;
					} else {				// Ver. 2.3
						FrameSize =	(*(TagDataPnt + 0) << 24) +
									(*(TagDataPnt + 1) << 16) +
									(*(TagDataPnt + 2) << 8) +
									*(TagDataPnt + 3);
						FrameCompression = (FrameFlag2 & 0x80) != 0;
						FrameCoded = (FrameFlag2 & 0x40) != 0;
						FrameUnsynchronization = false;
					}

					TagDataPnt += 6;

					if((FrameCompression == false) && (FrameCoded == false)) {
						if(FrameID0 == 'T') {
							if(TagInfo) {
								WCHAR*	Buff;

								if((TitleSc == false) &&			(FrameID1 == 'I') &&
																	(FrameID2 == 'T') &&
																	(FrameID3 == '2')) {
									Buff = TagInfo->Title;
									TitleSc = true;
								} else if((ArtistSc == false) &&	(FrameID1 == 'P') &&
																	(FrameID2 == 'E') &&
																	(FrameID3 == '1')) {
									Buff = TagInfo->Artist;
									ArtistSc = true;
								} else if((AlbumSc == false) &&		(FrameID1 == 'A') &&
																	(FrameID2 == 'L') &&
																	(FrameID3 == 'B')) {
									Buff = TagInfo->Album;
									AlbumSc = true;
								} else if((YearSc == false) && (TagVersion >= 4) &&
																	(FrameID1 == 'D') &&
																	(FrameID2 == 'R') &&
																	(FrameID3 == 'C')) {
									Buff = TagInfo->Year;
									YearSc = true;
								} else if((YearSc == false) && (TagVersion == 3) &&
																	(FrameID1 == 'Y') &&
																	(FrameID2 == 'E') &&
																	(FrameID3 == 'R')) {
									Buff = TagInfo->Year;
									YearSc = true;
								} else if((GenreSc == false) &&		(FrameID1 == 'C') &&
																	(FrameID2 == 'O') &&
																	(FrameID3 == 'N')) {
									Buff = TagInfo->Genre;
									GenreSc = true;
								} else if((TrackSc == false) &&		(FrameID1 == 'R') &&
																	(FrameID2 == 'C') &&
																	(FrameID3 == 'K')) {
									Buff = TagInfo->Track;
									TrackSc = true;
								} else if((ComposerSc == false) &&	(FrameID1 == 'C') &&
																	(FrameID2 == 'O') &&
																	(FrameID3 == 'M')) {
									Buff = TagInfo->Composer;
									ComposerSc = true;
								} else if((OrgArtistSc == false) &&	(FrameID1 == 'O') &&
																	(FrameID2 == 'P') &&
																	(FrameID3 == 'E')) {
									Buff = TagInfo->OrgArtist;
									OrgArtistSc = true;
								} else if((CopyrightSc == false) &&	(FrameID1 == 'C') &&
																	(FrameID2 == 'O') &&
																	(FrameID3 == 'P')) {
									Buff = TagInfo->Copyright;
									CopyrightSc = true;
								} else if((EncoderSc == false) &&	(FrameID1 == 'E') &&
																	(FrameID2 == 'N') &&
																	(FrameID3 == 'C')) {
									Buff = TagInfo->Encoder;
									EncoderSc = true;
								} else {
									Buff = NULL;
								}

								if(Buff) {
									ID3v2FrameTEXT(
												Buff,
												MAX_MUSICTEXT,
												TagDataPnt,
												FrameSize,
												FrameUnsynchronization);
								}
							} else if(ReplayGainInfo) {
								if(									(FrameID1 == 'X') &&
																	(FrameID2 == 'X') &&
																	(FrameID3 == 'X')) {
									WCHAR	FieldName[MAX_MUSICTEXT];
									WCHAR	FieldData[MAX_MUSICTEXT];

									ID3v2FrameTXXX(
												FieldName,
												MAX_MUSICTEXT,
												FieldData,
												MAX_MUSICTEXT,
												TagDataPnt,
												FrameSize,
												FrameUnsynchronization);

									int		ReplayGainFieldName;

									if((ReplayGainTrackGainSc == false) &&
											_wcsicmp(
												FieldName,
												APE_TAG_FIELD_L_REPLAYGAIN_TRACK_GAIN) == 0) {
										ReplayGainFieldName = REPLAYGAIN_TRACK_GAIN;
										ReplayGainTrackGainSc = true;
									} else if((ReplayGainTrackPeakSc == false) &&
											_wcsicmp(
												FieldName,
												APE_TAG_FIELD_L_REPLAYGAIN_TRACK_PEAK) == 0) {
										ReplayGainFieldName = REPLAYGAIN_TRACK_PEAK;
										ReplayGainTrackPeakSc = true;
									} else if((ReplayGainAlbumGainSc == false) &&
											_wcsicmp(
												FieldName,
												APE_TAG_FIELD_L_REPLAYGAIN_ALBUM_GAIN) == 0) {
										ReplayGainFieldName = REPLAYGAIN_ALBUM_GAIN;
										ReplayGainAlbumGainSc = true;
									} else if((ReplayGainAlbumPeakSc == false) &&
											_wcsicmp(
												FieldName,
												APE_TAG_FIELD_L_REPLAYGAIN_ALBUM_PEAK) == 0) {
										ReplayGainFieldName = REPLAYGAIN_ALBUM_PEAK;
										ReplayGainAlbumPeakSc = true;
									} else {
										ReplayGainFieldName = REPLAYGAIN_NONE;
									}

									if(ReplayGainFieldName != REPLAYGAIN_NONE) {
										StoreReplayGainInfo(
														ReplayGainInfo,
														ReplayGainFieldName,
														FieldData);
									}
								}
							}
						} else if(TagInfo && (CommentSc == false) &&	(FrameID0 == 'C') &&
																		(FrameID1 == 'O') &&
																		(FrameID2 == 'M') &&
																		(FrameID3 == 'M')) {
							ID3v2FrameCOMM(
										TagInfo->Comment,
										MAX_MUSICTEXT,
										TagDataPnt,
										FrameSize,
										FrameUnsynchronization);
							CommentSc = true;
						}
					}

					TagDataPnt += FrameSize;
				}

				delete[] TagData;

				RetCode = true;

				if(TagInfo) {
					if(TitleSc == false) *TagInfo->Title = L'\0';
					if(ArtistSc == false) *TagInfo->Artist = L'\0';
					if(CommentSc == false) *TagInfo->Comment = L'\0';
					if(AlbumSc == false) *TagInfo->Album = L'\0';
					if(YearSc == false) *TagInfo->Year = L'\0';
					if(GenreSc) {
						if(*TagInfo->Genre == L'(') {
							WCHAR*	GenreBuff;

							for(GenreBuff = TagInfo->Genre; *GenreBuff; GenreBuff++) {
								if(*GenreBuff == L')') {
									*GenreBuff = L'\0';
									GenreBuff++;
									break;
								}
							}

							if(*GenreBuff) {
								memmove(
									TagInfo->Genre,
									GenreBuff,
									(wcslen(GenreBuff) + 1) * sizeof WCHAR);
							} else {
								const int	Genre = _wtoi(TagInfo->Genre + 1);

								if(Genre < MAX_GENRE) {
									Strcpy(TagInfo->Genre, MAX_MUSICTEXT, GenreList[Genre]);
								} else {
									*TagInfo->Genre = L'\0';
								}
							}
						}
					} else {
						*TagInfo->Genre = L'\0';
					}
					if(TrackSc == false) *TagInfo->Track = L'\0';
					if(ComposerSc == false) *TagInfo->Composer = L'\0';
					if(OrgArtistSc == false) *TagInfo->OrgArtist = L'\0';
					if(CopyrightSc == false) *TagInfo->Copyright = L'\0';
					if(EncoderSc == false) *TagInfo->Encoder = L'\0';
				} else if(ReplayGainInfo) {
					FindReplayGainInfo = ReplayGainInfo->ValidTrackGain ||
											ReplayGainInfo->ValidAlbumGain;
				}
			} else {
				RetCode = false;
			}
		} else {
			RetCode = false;
		}
	} else {
		RetCode = false;
	}

	if(RetCode == false) {
		::CloseHandle(hF);

		FindReplayGainInfo = false;
	}

	return (TagInfo || (ReplayGainInfo == NULL)) ? RetCode : FindReplayGainInfo;
}

inline void
ID3v2FrameTEXT(
			WCHAR* Buff,
			const UINT BuffSize,
			unsigned char* TagDataPnt,
			UINT FrameSize,
			const bool FrameUnsynchronization)
{
	if(FrameUnsynchronization) {
		FrameSize = ID3v2DecodeUnsynchronization(TagDataPnt, FrameSize, false);
	}

	const UINT	FrameStrSize = FrameSize - 1;
	char*	FrameStrPnt = reinterpret_cast<char*>(TagDataPnt + 1);
	const UINT	StrCode = *TagDataPnt;
	bool	UnicodeUseBOM;

	switch(StrCode) {
	case 0x00:		// ISO-8859-1
		Strcpy(Buff, BuffSize, FrameStrPnt, FrameStrSize);
		break;
	case 0x01:		// Unicode(UTF-16 Use BOM)
		UnicodeUseBOM = true;
	case 0x02:		// Unicode(UTF-16 BigEndian)
		if(StrCode == 0x02) UnicodeUseBOM = false;

		Strcpy(
			Buff,
			BuffSize,
			reinterpret_cast<WCHAR*>(FrameStrPnt),
			FrameStrSize / sizeof WCHAR,
			UnicodeUseBOM,
			true);
		break;
	case 0x03:		// Unicode(UTF-8)
		UTF8Strcpy(Buff, BuffSize, FrameStrPnt, FrameStrSize);
		break;
	}
}

inline void
ID3v2FrameTXXX(
			WCHAR* FieldName,
			const UINT FieldNameSize,
			WCHAR* FieldData,
			const UINT FieldDataSize,
			unsigned char* TagDataPnt,
			UINT FrameSize,
			const bool FrameUnsynchronization)
{
	if(FrameUnsynchronization) {
		FrameSize = ID3v2DecodeUnsynchronization(TagDataPnt, FrameSize, false);
	}

	const UINT	FrameStrSize = FrameSize - 1;
	char*	FrameStrPnt = reinterpret_cast<char*>(TagDataPnt + 1);
	const UINT	StrCode = *TagDataPnt;
	UINT	SimpleStrSize;
	UINT	DetailStrSize;
	bool	UnicodeUseBOM;

	switch(StrCode) {
	case 0x00:		// ISO-8859-1
		SimpleStrSize = strlen(FrameStrPnt);
		DetailStrSize = FrameStrSize - SimpleStrSize - 1;

		Strcpy(FieldName, FieldNameSize, FrameStrPnt, SimpleStrSize);
		Strcpy(FieldData, FieldDataSize, FrameStrPnt + SimpleStrSize + 1, DetailStrSize);
		break;
	case 0x01:		// Unicode(UTF-16 Use BOM)
		UnicodeUseBOM = true;
	case 0x02:		// Unicode(UTF-16 BigEndian)
		if(StrCode == 0x02) UnicodeUseBOM = false;

		SimpleStrSize = WideStrSize(reinterpret_cast<WCHAR*>(FrameStrPnt), FrameStrSize);
		DetailStrSize = FrameStrSize - SimpleStrSize;

		Strcpy(
			FieldName,
			FieldNameSize,
			reinterpret_cast<WCHAR*>(FrameStrPnt),
			SimpleStrSize / sizeof WCHAR,
			UnicodeUseBOM,
			true);

		Strcpy(
			FieldData,
			FieldDataSize,
			reinterpret_cast<WCHAR*>(FrameStrPnt + SimpleStrSize),
			DetailStrSize / sizeof WCHAR,
			UnicodeUseBOM,
			true);
		break;
	case 0x03:		// Unicode(UTF-8)
		SimpleStrSize = strlen(FrameStrPnt) + 1;
		DetailStrSize = FrameStrSize - SimpleStrSize;

		UTF8Strcpy(FieldName, FieldNameSize, FrameStrPnt, SimpleStrSize);
		UTF8Strcpy(FieldData, FieldDataSize, FrameStrPnt + SimpleStrSize, DetailStrSize);
		break;
	}
}

inline void
ID3v2FrameCOMM(
			WCHAR* Buff,
			const UINT BuffSize,
			unsigned char* TagDataPnt,
			UINT FrameSize,
			const bool FrameUnsynchronization)
{
	if(FrameUnsynchronization) {
		FrameSize = ID3v2DecodeUnsynchronization(TagDataPnt, FrameSize, false);
	}

	const UINT	FrameStrSize = FrameSize - 1 - 3;
	char*	FrameStrPnt = reinterpret_cast<char*>(TagDataPnt + 1 + 3);
	const UINT	StrCode = *TagDataPnt;
	UINT	SimpleStrSize;
	UINT	DetailStrSize;
	bool	UnicodeUseBOM;

	switch(StrCode) {
	case 0x00:		// ISO-8859-1
		SimpleStrSize = strlen(FrameStrPnt);
		DetailStrSize = FrameStrSize - SimpleStrSize - 1;

		if(DetailStrSize >= 1) {
			Strcpy(Buff, DetailStrSize + 1, FrameStrPnt + SimpleStrSize + 1, DetailStrSize);
		} else {
			Strcpy(Buff, SimpleStrSize + 1, FrameStrPnt, SimpleStrSize);
		}

		break;
	case 0x01:		// Unicode(UTF-16 Use BOM)
		UnicodeUseBOM = true;
	case 0x02:		// Unicode(UTF-16 BigEndian)
		if(StrCode == 0x02) UnicodeUseBOM = false;

		SimpleStrSize = WideStrSize(reinterpret_cast<WCHAR*>(FrameStrPnt), FrameStrSize);
		DetailStrSize = FrameStrSize - SimpleStrSize;

		if(DetailStrSize >= (1 * sizeof WCHAR)) {
			Strcpy(
				Buff,
				DetailStrSize / sizeof WCHAR + 1,
				reinterpret_cast<WCHAR*>(FrameStrPnt + SimpleStrSize),
				DetailStrSize / sizeof WCHAR,
				UnicodeUseBOM,
				true);
		} else {
			Strcpy(
				Buff,
				SimpleStrSize / sizeof WCHAR + 1,
				reinterpret_cast<WCHAR*>(FrameStrPnt),
				SimpleStrSize / sizeof WCHAR,
				UnicodeUseBOM,
				true);
		}

		break;
	case 0x03:		// Unicode(UTF-8)
		SimpleStrSize = strlen(FrameStrPnt) + 1;
		DetailStrSize = FrameStrSize - SimpleStrSize;

		if(DetailStrSize >= 1) {
			UTF8Strcpy(Buff, DetailStrSize + 1, FrameStrPnt + SimpleStrSize, DetailStrSize);
		} else {
			UTF8Strcpy(Buff, SimpleStrSize + 1, FrameStrPnt, SimpleStrSize);
		}

		break;
	}
}

UINT
ID3v2DecodeUnsynchronization(unsigned char* Data, const UINT Size, const bool SetZero)
{
	unsigned char*	WriteData = Data;
	UINT	DecodeSize = 0;
	bool	FullBits = false;

	for(UINT Idx = 0; Idx < Size; Idx++) {
		const unsigned char	DataPnt = *Data++;

		if(DataPnt == 0xff) {
			FullBits = true;
		} else {
		 	if(FullBits) {
				FullBits = false;
				if(DataPnt == 0x00) continue;
			}
		}

		*WriteData++ = DataPnt;
		DecodeSize++;
	}

	if(SetZero) memset(WriteData, 0, Size - DecodeSize);

	return DecodeSize;
}

UINT
WideStrSize(WCHAR* InBuff, const UINT MaxSize)
{
	unsigned char*	InBuffPnt = reinterpret_cast<unsigned char*>(InBuff);
	bool	FirstByte = true;
	bool	ZeroBits = false;
	UINT	Size;

	for(Size = 0; Size < MaxSize; Size++) {
		unsigned char	Str = *InBuffPnt++;

		if(Str == 0x00) {
			if(ZeroBits && (FirstByte == false)) {
				Size++;
				break;
			}

			ZeroBits = true;
		} else {
			ZeroBits = false;
		}

		FirstByte = !FirstByte;
	}

	return Size;
}

