
#ifndef ___BLADEDLL_H_INCLUDED___
#define ___BLADEDLL_H_INCLUDED___

#ifdef __GNUC__
#define ATTRIBUTE_PACKED	__attribute__((packed))
#else
#define ATTRIBUTE_PACKED
#pragma pack(push)
#pragma pack(1)
#endif

#ifdef	__cplusplus
extern "C" {
#endif


#define		BE_CONFIG_MP3			0										
#define		BE_CONFIG_LAME			256		


typedef		unsigned long			HBE_STREAM;
typedef		HBE_STREAM				*PHBE_STREAM;
typedef		unsigned long			BE_ERR;


#define		BE_ERR_SUCCESSFUL					0x00000000
#define		BE_ERR_INVALID_FORMAT				0x00000001
#define		BE_ERR_INVALID_FORMAT_PARAMETERS	0x00000002
#define		BE_ERR_NO_MORE_HANDLES				0x00000003
#define		BE_ERR_INVALID_HANDLE				0x00000004
#define		BE_ERR_BUFFER_TOO_SMALL				0x00000005


#define		BE_MAX_HOMEPAGE			128


#define		BE_MP3_MODE_STEREO		0
#define		BE_MP3_MODE_JSTEREO		1
#define		BE_MP3_MODE_DUALCHANNEL	2
#define		BE_MP3_MODE_MONO		3



#define		MPEG1	1
#define		MPEG2	0

#ifdef _BLADEDLL
#undef FLOAT
	#include <Windows.h>
#endif

#define CURRENT_STRUCT_VERSION 1
#define CURRENT_STRUCT_SIZE sizeof(BE_CONFIG)	


typedef enum
{
	VBR_METHOD_NONE			= -1,
	VBR_METHOD_DEFAULT		=  0,
	VBR_METHOD_OLD			=  1,
	VBR_METHOD_NEW			=  2,
	VBR_METHOD_MTRH			=  3,
	VBR_METHOD_ABR			=  4
} VBRMETHOD;

typedef enum 
{
	LQP_NOPRESET			=-1,

	LQP_NORMAL_QUALITY		= 0,
	LQP_LOW_QUALITY			= 1,
	LQP_HIGH_QUALITY		= 2,
	LQP_VOICE_QUALITY		= 3,
	LQP_R3MIX				= 4,
	LQP_VERYHIGH_QUALITY	= 5,
	LQP_STANDARD			= 6,
	LQP_FAST_STANDARD		= 7,
	LQP_EXTREME				= 8,
	LQP_FAST_EXTREME		= 9,
	LQP_INSANE				= 10,
	LQP_ABR					= 11,
	LQP_CBR					= 12,
	LQP_MEDIUM				= 13,
	LQP_FAST_MEDIUM			= 14,

	LQP_PHONE	=1000,
	LQP_SW		=2000,
	LQP_AM		=3000,
	LQP_FM		=4000,
	LQP_VOICE	=5000,
	LQP_RADIO	=6000,
	LQP_TAPE	=7000,
	LQP_HIFI	=8000,
	LQP_CD		=9000,
	LQP_STUDIO	=10000

} LAME_QUALITY_PRESET;



typedef struct	{
	DWORD	dwConfig;			
	union	{

		struct	{

			DWORD	dwSampleRate;		
			BYTE	byMode;			
			WORD	wBitrate;		
			BOOL	bPrivate;		
			BOOL	bCRC;
			BOOL	bCopyright;
			BOOL	bOriginal;

			} mp3;					

			struct
			{
			DWORD			dwStructVersion;	
			DWORD			dwStructSize;

			DWORD			dwSampleRate;		
			DWORD			dwReSampleRate;		
			LONG			nMode;				
			DWORD			dwBitrate;			
			DWORD			dwMaxBitrate;		
			LONG			nPreset;			
			DWORD			dwMpegVersion;		
			DWORD			dwPsyModel;			
			DWORD			dwEmphasis;			

			BOOL			bPrivate;			
			BOOL			bCRC;				
			BOOL			bCopyright;			
			BOOL			bOriginal;			
			
			BOOL			bWriteVBRHeader;	
			BOOL			bEnableVBR;			
			INT				nVBRQuality;		
			DWORD			dwVbrAbr_bps;		
			VBRMETHOD		nVbrMethod;
			BOOL			bNoRes;				

			BOOL			bStrictIso;			
			WORD			nQuality;			

			BYTE			btReserved[255-4*sizeof(DWORD) - sizeof( WORD )];

			} LHV1;					

		struct	{

			DWORD	dwSampleRate;
			BYTE	byMode;
			WORD	wBitrate;
			BYTE	byEncodingMethod;

		} aac;

	} format;
		
} BE_CONFIG, *PBE_CONFIG ATTRIBUTE_PACKED;


typedef struct	{


	BYTE	byDLLMajorVersion;
	BYTE	byDLLMinorVersion;


	BYTE	byMajorVersion;
	BYTE	byMinorVersion;


	BYTE	byDay;
	BYTE	byMonth;
	WORD	wYear;


	CHAR	zHomepage[BE_MAX_HOMEPAGE + 1];	

	BYTE	byAlphaLevel;
	BYTE	byBetaLevel;
	BYTE	byMMXEnabled;

	BYTE	btReserved[125];


} BE_VERSION, *PBE_VERSION ATTRIBUTE_PACKED;

#ifndef _BLADEDLL

typedef BE_ERR	(*BEINITSTREAM)			(PBE_CONFIG, PDWORD, PDWORD, PHBE_STREAM);
typedef BE_ERR	(*BEENCODECHUNK)		(HBE_STREAM, DWORD, PSHORT, PBYTE, PDWORD);

typedef BE_ERR	(*BEENCODECHUNKFLOATS16NI)	(HBE_STREAM, DWORD, PFLOAT, PFLOAT, PBYTE, PDWORD);
typedef BE_ERR	(*BEDEINITSTREAM)			(HBE_STREAM, PBYTE, PDWORD);
typedef BE_ERR	(*BECLOSESTREAM)			(HBE_STREAM);
typedef VOID	(*BEVERSION)				(PBE_VERSION);
typedef BE_ERR	(*BEWRITEVBRHEADER)			(LPCSTR);
typedef BE_ERR	(*BEWRITEINFOTAG)			(HBE_STREAM, LPCSTR );

#define	TEXT_BEINITSTREAM				"beInitStream"
#define	TEXT_BEENCODECHUNK				"beEncodeChunk"
#define	TEXT_BEENCODECHUNKFLOATS16NI	"beEncodeChunkFloatS16NI"
#define	TEXT_BEDEINITSTREAM				"beDeinitStream"
#define	TEXT_BECLOSESTREAM				"beCloseStream"
#define	TEXT_BEVERSION					"beVersion"
#define	TEXT_BEWRITEVBRHEADER			"beWriteVBRHeader"
#define	TEXT_BEFLUSHNOGAP				"beFlushNoGap"
#define	TEXT_BEWRITEINFOTAG				"beWriteInfoTag"


#else

__declspec(dllexport) BE_ERR	beInitStream(PBE_CONFIG pbeConfig, PDWORD dwSamples, PDWORD dwBufferSize, PHBE_STREAM phbeStream);
__declspec(dllexport) BE_ERR	beEncodeChunk(HBE_STREAM hbeStream, DWORD nSamples, PSHORT pSamples, PBYTE pOutput, PDWORD pdwOutput);

__declspec(dllexport) BE_ERR	beEncodeChunkFloatS16NI(HBE_STREAM hbeStream, DWORD nSamples, PFLOAT buffer_l, PFLOAT buffer_r, PBYTE pOutput, PDWORD pdwOutput);
__declspec(dllexport) BE_ERR	beDeinitStream(HBE_STREAM hbeStream, PBYTE pOutput, PDWORD pdwOutput);
__declspec(dllexport) BE_ERR	beCloseStream(HBE_STREAM hbeStream);
__declspec(dllexport) VOID		beVersion(PBE_VERSION pbeVersion);
__declspec(dllexport) BE_ERR	beWriteVBRHeader(LPCSTR lpszFileName);
__declspec(dllexport) BE_ERR	beFlushNoGap(HBE_STREAM hbeStream, PBYTE pOutput, PDWORD pdwOutput);
__declspec(dllexport) BE_ERR	beWriteInfoTag( HBE_STREAM hbeStream, LPCSTR lpszFileName );

#endif

#ifdef	__cplusplus
}
#endif

#ifndef __GNUC__
#pragma pack(pop)
#endif

#endif
