#pragma once

#include <streams.h>
#include "../CSimpleFilter/CSimpleFilter.h"

#include "valib/filters/decoder_graph.h"
#include "valib/sink/sink_dshow.h"

#define WAVE_FORMAT_IEEE_FLOAT 3
#define FILTERNAME L"DecodeAC3"

#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "../lib/strmbase.lib")
#pragma comment(lib, "../lib/CSimpleFilter.lib")
#pragma comment(lib, "../lib/dsound.lib")


static const GUID CLSID_DecodeAc3 =
{ 0x38321b5e, 0xc287, 0x4c1a, { 0x91, 0x43, 0x79, 0x1, 0x7c, 0x33, 0x9a, 0x3f } };

static const GUID MEDIASUBTYPE_AVI_AC3 =
{ 0x00002000, 0x0000, 0x0010, { 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71} };

class CDecodeAc3 : public CSimpleTransform , public IDecodeInterface
{
public:
   DECLARE_IUNKNOWN

   
   CDecodeAc3(LPUNKNOWN, HRESULT *);
   ~CDecodeAc3();

   
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   
   HRESULT OnConnectInPin(const CMediaType *);
   HRESULT OnConnectOutPin(const CMediaType *, int, CMediaType *, int *);

   
   HRESULT OnTransform(IMediaSample *, IMediaSample *);
   HRESULT OnStart();
   HRESULT OnSeek();
   STDMETHODIMP OnQueryInterface(REFIID, void **);

   
   HRESULT GetOutFormat(void *);
   HRESULT SetOutFormat(void *);

private:

   
   WAVEFORMATEX m_outFormat;
   REFERENCE_TIME m_rtCurrent;

   Speakers m_inSpeakers;
   Speakers m_outSpeakers;
   DecoderGraph m_decoderGraph;

   Chunk m_chunk;

   BYTE *m_pbInBuffer;
   int m_nInBufferLength;
   int m_nInArraySize;
   bool m_bSeek;
};

