#pragma once

typedef unsigned int   uint32;
typedef unsigned short uint16;
typedef unsigned char  uint8;
typedef char           str_ansi;
typedef wchar_t        str_utf16;

#include <streams.h>
#include <shlwapi.h>
#include "maclib.h"
#include "../CSimpleFilter/CSimpleFilter.h"

#define FILTERNAME L"DecodeApe"

#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "shlwapi.lib")
#pragma comment(lib, "../lib/strmbase.lib")
#pragma comment(lib, "../lib/CSimpleFilter.lib")
#pragma comment(lib, "MACLib.lib")



static const GUID CLSID_SourceApe = 
{ 0x71f2e335, 0x44cd, 0x4ad5, { 0x94, 0x67, 0xd0, 0xb9, 0x16, 0x9c, 0x5b, 0xa5 } };

class CSourceApe : public CSimplePushSource , public IFileSourceFilter
{
public:
   DECLARE_IUNKNOWN

   
   CSourceApe(LPUNKNOWN, HRESULT *);
   ~CSourceApe();

   
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   
   HRESULT OnConnectOutPin(CMediaType *, int *, REFERENCE_TIME *);
   HRESULT FillBuffer(IMediaSample *);

   
   STDMETHODIMP OnQueryInterface(REFIID riid, void ** ppv);
   HRESULT OnSeek(LONGLONG, LONGLONG);

   
   STDMETHODIMP Load(LPCOLESTR, const AM_MEDIA_TYPE *);
   STDMETHODIMP GetCurFile(LPOLESTR *, AM_MEDIA_TYPE *);


private:
   
   IAPEDecompress *m_pAPEDecompress;
   WAVEFORMATEX m_outFormat;

   WCHAR m_awInputFileName[MAX_PATH];

   int m_nBlockSize;

   REFERENCE_TIME m_rtStop, m_rtCurrent;

};

