#pragma once

#include <streams.h>
#include <shlwapi.h>
#include "../CSimpleFilter/CSimpleFilter.h"

#include "ttacodec.h"

#define FRAME_TIME 1.04489795918367346939

#pragma comment(lib, "winmm.lib")
#pragma comment(lib, "shlwapi.lib")
#pragma comment(lib, "../lib/strmbase.lib")

#pragma pack(1)

typedef struct
{
   unsigned char id[3];
   unsigned short version;
   unsigned char flags;
   unsigned char size[4];
} id3v2;

struct TTA_HEADER
{
   char TTAid[4];
   unsigned short AudioFormat;
   unsigned short NumChannels;
   unsigned short BitsPerSample;
   unsigned int SampleRate;
   unsigned int DataLength;
   unsigned int CRC32;
};

# pragma pack ()



static const GUID CLSID_SourceTta =
{ 0xe2fa064b, 0xcf4d, 0x4e7f, { 0xb9, 0x8e, 0x24, 0x28, 0xb9, 0xb, 0xcf, 0xe8 } };

class CSourceTta : public CSimplePushSource , public IFileSourceFilter
{
public:
   DECLARE_IUNKNOWN

   
   CSourceTta(LPUNKNOWN, HRESULT *);
   ~CSourceTta();

   
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   
   HRESULT OnConnectOutPin(CMediaType *, int *, REFERENCE_TIME *);
   HRESULT FillBuffer(IMediaSample *);

   
   STDMETHODIMP OnQueryInterface(REFIID riid, void ** ppv);
   HRESULT OnSeek(LONGLONG, LONGLONG);

   
   STDMETHODIMP Load(LPCOLESTR, const AM_MEDIA_TYPE *);
   STDMETHODIMP GetCurFile(LPOLESTR *, AM_MEDIA_TYPE *);

private:

   
   HANDLE m_hFile;
   TTA_codec *m_pTTACodec;
   WAVEFORMATEX m_outFormat;
   WCHAR m_awInputFileName[MAX_PATH];

   int   m_nInBufferSize;
   BYTE *m_pbInBuffer;
   int m_nTotalLength;

   int *m_pnSeekTable;
   int m_nSeekTableSize;
   int m_nCurrentFrameNumber;

   int m_nID3v2Length;

   REFERENCE_TIME m_rtStop, m_rtCurrent;
   LONGLONG m_llTotalDuration;
};

