
#include        <stdio.h>
#include        <string.h>
#include        <signal.h>


#ifndef WIN32
#include        <sys/signal.h>
#include        <unistd.h>
#endif

#define _USE_MATH_DEFINES

#include        <math.h>

#ifdef _WIN32
# undef WIN32
# define WIN32
#endif

#ifdef WIN32



#define NEW_DCT9

#ifdef REAL_IS_FLOAT
#  define real float
#elif defined(REAL_IS_LONG_DOUBLE)
#  define real long double
#else
#  define real double
#endif

#ifdef __GNUC__
#define INLINE inline
#else
#define INLINE
#endif


#define		AUDIOBUFSIZE		16384

#ifndef FALSE
#define         FALSE                   0
#endif
#ifndef FALSE
#define         TRUE                    1
#endif

#define         SBLIMIT                 32
#define         SSLIMIT                 18

#define         SCALE_BLOCK             12


#define         MPG_MD_STEREO           0
#define         MPG_MD_JOINT_STEREO     1
#define         MPG_MD_DUAL_CHANNEL     2
#define         MPG_MD_MONO             3


class	mpg123;

struct frame {
	bool mpeg25;
	int lsf;
	int lay;
	int error_protection;
	int bitrate;
	int frequency;
	int padding;
	int extension;
	int mode;
	int mode_ext;
	int copyright;
	int original;
	int emphasis;
	int stereo;
	int jsbound;
	int framesize; 

	int sideInfoSize; 

	
	int II_sblimit;
	void *alloc;
};

struct parameter {
	int quiet;	
	int tryresync;  
	int verbose;    
	int checkrange;
};

extern const int tabsel_123[2][3][16];


	{
		gr_info_s	gr[2];
	} ch[2];
};



class
RingBuff_8bit
{
public:
	RingBuff_8bit(void);
	~RingBuff_8bit(void);

	void __fastcall	Init(void);
	inline void __fastcall
	SetPointer(void)
	{
		ReadPnt = BuffEnd;
		BitIndex = 0;
	}
	inline bool __fastcall
	SetPointer(const unsigned int BackStep)
	{
		if((BuffWrite < (1 << 8)) && (BackStep > ReadPnt)) return false;

		ReadPnt -= BackStep;
		BitIndex = 0;

		return true;
	}
	void __fastcall	Add(unsigned char* AddBuff, const unsigned int Size);
	inline unsigned char __fastcall
	get1bit(void)
	{
		const unsigned char	Value = *(Buff + ReadPnt) << BitIndex;

		ReadPnt += ++BitIndex >> 3;
		BitIndex &= 7;

		return Value >> 7;
	}
	inline unsigned int __fastcall
	getbits_fast(const int NumberOfBits)
	{
		if(NumberOfBits <= 0) return 0;

		unsigned int	Value = (*(Buff + ReadPnt) << 8) |
									*(Buff + static_cast<unsigned char>(ReadPnt + 1));

		Value = static_cast<unsigned short>(Value << BitIndex) >> (16 - NumberOfBits);

		ReadPnt += (BitIndex += NumberOfBits) >> 3;
		BitIndex &= 7;

		return Value;
	}
	inline unsigned int __fastcall
	getbits(const int NumberOfBits)
	{
		if(NumberOfBits <= 0) return 0;

		unsigned int	Value = (*(Buff + ReadPnt) << 16) |
									(*(Buff + static_cast<unsigned char>(ReadPnt + 1)) << 8) |
									*(Buff + static_cast<unsigned char>(ReadPnt + 2));

		Value = ((Value << BitIndex) & 0xffffff) >> (24 - NumberOfBits);

		ReadPnt += (BitIndex += NumberOfBits) >> 3;
		BitIndex &= 7;

		return Value;
	}

private:
	unsigned int	BuffWrite;
	unsigned char	BuffEnd;
	unsigned char	ReadPnt;
	unsigned int	BitIndex;
	unsigned char*	Buff;
};

class
RingBuff_16bit
{
public:
	RingBuff_16bit(void);
	~RingBuff_16bit(void);

	void __fastcall	Init(void);
	inline void __fastcall
	SetPointer(void)
	{
		ReadPnt = BuffEnd;
		BitIndex = 0;
	}
	inline bool __fastcall
	SetPointer(const unsigned int BackStep)
	{
		if((BuffWrite < (1 << 16)) && (BackStep > ReadPnt)) return false;

		ReadPnt -= BackStep;
		BitIndex = 0;

		return true;
	}
	void __fastcall	Add(unsigned char* AddBuff, const unsigned int Size);
	inline unsigned char __fastcall
	get1bit(void)
	{
		const unsigned char	Value = *(Buff + ReadPnt) << BitIndex;

		ReadPnt += ++BitIndex >> 3;
		BitIndex &= 7;

		return Value >> 7;
	}
	inline unsigned int __fastcall
	getbits_fast(const int NumberOfBits)
	{
		if(NumberOfBits <= 0) return 0;

		unsigned int	Value = (*(Buff + ReadPnt) << 8) |
									*(Buff + static_cast<unsigned short>(ReadPnt + 1));

		Value = static_cast<unsigned short>(Value << BitIndex) >> (16 - NumberOfBits);

		ReadPnt += (BitIndex += NumberOfBits) >> 3;
		BitIndex &= 7;

		return Value;
	}
	inline unsigned int __fastcall
	getbits(const int NumberOfBits)
	{
		if(NumberOfBits <= 0) return 0;

		unsigned int	Value = (*(Buff + ReadPnt) << 16) |
									(*(Buff + static_cast<unsigned short>(ReadPnt + 1)) << 8) |
									*(Buff + static_cast<unsigned short>(ReadPnt + 2));

		Value = ((Value << BitIndex) & 0xffffff) >> (24 - NumberOfBits);

		ReadPnt += (BitIndex += NumberOfBits) >> 3;
		BitIndex &= 7;

		return Value;
	}
	inline void __fastcall
	Cache_Start(void)
	{
		CacheSize = 8 - BitIndex;
		Cache = getbits_fast(CacheSize) << (sizeof Cache * 8 - CacheSize);
	}
	inline void __fastcall
	Cache_End(void)
	{
		const unsigned short	SubPnt = CacheSize / 8;

		ReadPnt -= SubPnt;
		BitIndex = 8 - (CacheSize - SubPnt * 8);

		if(BitIndex == 8) {
			BitIndex = 0;
		} else {
			ReadPnt--;
		}
	}
	inline void __fastcall
	Cache_Charge(void)
	{
		while(CacheSize < (sizeof Cache * 8 - 8)) {
			Cache |= *(Buff + ReadPnt++) << (sizeof Cache * 8 - 8 - CacheSize);
			CacheSize += 8;
		}
	}
	inline unsigned int __fastcall
	Cache_get1bit(void)
	{
		const unsigned int	_Cache = Cache;

		CacheSize--;
		Cache <<= 1;

		return _Cache >> (sizeof Cache * 8 - 1);
	}
	inline unsigned int __fastcall
	Cache_getbits_fast(const int NumberOfBits)
	{
		const unsigned int	_Cache = Cache;

		CacheSize -= NumberOfBits;
		Cache <<= NumberOfBits;

		return _Cache >> (sizeof Cache * 8 - NumberOfBits);
	}

private:
	unsigned int	BuffWrite;
	unsigned short	BuffEnd;
	unsigned short	ReadPnt;
	unsigned int	BitIndex;
	unsigned int	CacheSize;
	unsigned int	Cache;
	unsigned char*	Buff;
};

typedef	int	(__fastcall mpg123::*DO_LAYER123_FUNC)(unsigned char* pcm_sample, int* pcm_point);

typedef	void	(__fastcall mpg123::*SYNTH_1TO1_MONO_FUNC)
					(real* bandPtr, unsigned char* samples, int* pnt);
typedef	void	(__fastcall mpg123::*SYNTH_1TO1_FUNC)
					(real* bandPtr, int channel, unsigned char* out, int* pnt);



extern int synth_2to1 (real *,int,unsigned char *,int *);
extern int synth_2to1_8bit (real *,int,unsigned char *,int *);
extern int synth_2to1_mono (real *,unsigned char *,int *);
extern int synth_2to1_mono2stereo (real *,unsigned char *,int *);
extern int synth_2to1_8bit_mono (real *,unsigned char *,int *);
extern int synth_2to1_8bit_mono2stereo (real *,unsigned char *,int *);

extern int synth_4to1 (real *,int,unsigned char *,int *);
extern int synth_4to1_8bit (real *,int,unsigned char *,int *);
extern int synth_4to1_mono (real *,unsigned char *,int *);
extern int synth_4to1_mono2stereo (real *,unsigned char *,int *);
extern int synth_4to1_8bit_mono (real *,unsigned char *,int *);
extern int synth_4to1_8bit_mono2stereo (real *,unsigned char *,int *);

extern int synth_ntom (real *,int,unsigned char *,int *);
extern int synth_ntom_8bit (real *,int,unsigned char *,int *);
extern int synth_ntom_mono (real *,unsigned char *,int *);
extern int synth_ntom_mono2stereo (real *,unsigned char *,int *);
extern int synth_ntom_8bit_mono (real *,unsigned char *,int *);
extern int synth_ntom_8bit_mono2stereo (real *,unsigned char *,int *);

extern void rewindNbits(int bits);
extern int  hsstell(void);
extern int get_songlen(struct frame *fr,int no);

extern void __fastcall init_layer3(const unsigned int);
extern void __fastcall init_layer2(void);
extern void __fastcall make_decode_tables(long scale);
extern void make_conv16to8_table(int);
extern void __fastcall dct64(real *,real *,real *);

extern void synth_ntom_set_step(long,long);

extern unsigned char *conv16to8;
extern const long freqs[9];
extern real muls[27][64];
extern real decwin[512+32];
extern real *pnts[5];

extern const struct parameter param;



