#pragma once

#include <streams.h>
#include <math.h>
#include "../CSimpleFilter/CSimpleFilter.h"

#ifndef WAVE_FORMAT_IEEE_FLOAT
#define WAVE_FORMAT_IEEE_FLOAT 3
#endif

struct SmplData{double l,r;};


static const GUID CLSID_ConvertWav = 
{ 0xefbf44b7, 0xbb1f, 0x48c8, { 0xba, 0x59, 0xeb, 0x98, 0x3, 0x57, 0x9b, 0x1e } };


static const GUID IID_IConvertWavInterface = 
{ 0xbda4cab0, 0x2eb2, 0x42cb, { 0xa6, 0x31, 0xe8, 0x9e, 0x82, 0x35, 0x2d, 0xd1} };


__interface IConvertWavInterface : public IUnknown
{
public:
   HRESULT GetInFormat(WAVEFORMATEX *);
   HRESULT GetOutFormat(WAVEFORMATEX *);
   HRESULT GetTransformedBytes(LONGLONG *);
   HRESULT SetOutFormat(WAVEFORMATEX *);
   HRESULT SetNormalize(double);
   HRESULT SetWait(int);
};

class CConvertSamples
{
public:

   
   HRESULT ConvertInit(WAVEFORMATEX *, WAVEFORMATEX *, int, double);
   void Convert(struct SmplData *, int, BYTE *, int *);
   void ConvertSSE2(struct SmplData *, int, BYTE *, int *);
   void ConvertEnd(struct SmplData *, int, BYTE *, int *);

private:

   
   double bessel0(double);

   
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;

   int iptr;
	int ismd, ismr;
   long firodrv;
   int isrm, osrm;
   int sptr, sptrr, eptr, eptrr;
   double m_hfir[65536];
   double m_dMaxData, m_dMinData;
   double m_dRatioPlus, m_dRatioMinus;
};

class CConvertChannels
{
public:
   
   HRESULT SetFormat(WAVEFORMATEX *, WAVEFORMATEX *);
   HRESULT Convert(BYTE *, int, BYTE *, int *);
   HRESULT Convert(BYTE *, int, int *);

private:

   
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;
};

class CConvertBits
{
public:

   
   HRESULT SetFormat(WAVEFORMATEX *, WAVEFORMATEX *);
   HRESULT Convert(BYTE *, int, BYTE *, int *);

private:

   
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;
   double m_dRatio;

   
   HRESULT Convert8(BYTE *, int, BYTE *, int *);
   HRESULT Convert16(BYTE *, int, BYTE *, int *);
   HRESULT Convert24(BYTE *, int, BYTE *, int *);
   HRESULT Convert32i(BYTE *, int, BYTE *, int *);
   HRESULT Convert32f(float *, int, BYTE *, int *);
   HRESULT Convert64(double *, int, BYTE *, int *);
};

class CConvertWav : public CSimpleTransform , public IConvertWavInterface
{
   friend class CConvertBits;
   friend class CConvertChannels;
   friend class CConvertSamples;

public:
   DECLARE_IUNKNOWN

   
   CConvertWav(LPUNKNOWN, HRESULT *);
   ~CConvertWav();

   
   static CUnknown * WINAPI CreateInstance(LPUNKNOWN, HRESULT *);

   
   HRESULT OnConnectInPin(const CMediaType *);
   HRESULT OnConnectOutPin(const CMediaType *, int, CMediaType *, int *);
   HRESULT OnTransform(IMediaSample *, IMediaSample *);

   
   HRESULT GetInFormat(WAVEFORMATEX *);
   HRESULT GetOutFormat(WAVEFORMATEX *);
   HRESULT GetTransformedBytes(LONGLONG *);
   HRESULT SetOutFormat(WAVEFORMATEX *);
   HRESULT SetNormalize(double);
   HRESULT SetWait(int);

   
   HRESULT OnStart();
   HRESULT OnSeek();
   HRESULT OnStop(bool);
   STDMETHODIMP OnQueryInterface(REFIID, void **);

private:

   
   void ConvertToDouble(BYTE *, int);
   HRESULT Convert(BYTE *, int, BYTE *, int *);
   void Normalize(BYTE *, int, WAVEFORMATEX *);

   
   bool m_bSetOutFormat;
   bool m_bUseSSE2;

   bool m_bUseNormalize;
   double m_dNormalizeScale;

   int m_nWait;
   LONGLONG m_llInputSize;

   REFERENCE_TIME m_rtCurrent;
   WAVEFORMATEX m_inFormat;
   WAVEFORMATEX m_outFormat;

   CConvertBits     *m_pConvertBits;
   CConvertChannels *m_pConvertChannels;
   CConvertSamples  *m_pConvertSamples;

   int m_nSmplSize;
   struct SmplData *m_smpld;
};

