

#ifndef VALIB_AGC_H
#define VALIB_AGC_H

#include "../filter.h"
#include "../data.h"





class AGC : public NullFilter
{
protected:
  SampleBuf w;
  SampleBuf buf[2];               

  size_t    block;                
  size_t    sample[2];            
  bool      buf_sync[2];          
  vtime_t   buf_time[2];          

  size_t    nsamples;             

  sample_t  factor;               
  sample_t  level;                

  inline size_t next_block();

  bool fill_buffer();
  void process();

public:
  
  bool auto_gain;                 
  bool normalize;                 

  
  sample_t master;                
  sample_t gain;                  

  sample_t attack;                
  sample_t release;               

  
  bool     drc;                   
  sample_t drc_power;             
  sample_t drc_level;             

  AGC(size_t nsamples);

  
  

  
  size_t get_buffer() const;
  void   set_buffer(size_t nsamples);

  
  

  virtual void reset();
  virtual bool get_chunk(Chunk *out);
};






size_t 
AGC::next_block()
{
  return (block + 1) & 1;
}

#endif
