

#ifndef VALIB_BASS_REDIR_H
#define VALIB_BASS_REDIR_H

#include "../filter.h"





class IIR
{
protected:
  double a, a1, a2, b1, b2;
  sample_t x1, x2, y1, y2;

public:
  double gain;
  double freq;
  double sample_rate;

  IIR()
  {
    gain = 1.0;
    freq = 0;
    sample_rate = 0;

    
    a  = 1.0;
    a1 = 0;
    a2 = 0;
    b1 = 0;
    b2 = 0;

    x1 = 0;
    x2 = 0;
    y1 = 0;
    y2 = 0;
  };

  inline void reset()
  {
    x1 = 0;
    x2 = 0;
    y1 = 0;
    y2 = 0;
  };

  virtual void update() = 0; 

  void process(sample_t *samples, int nsamples);
};





class HPF : public IIR
{
public:
  void update();
};





class LPF : public IIR
{
public:
  void update();
};





class BassRedir : public NullFilter
{
protected:
  bool enabled;
  LPF  lpf;

  
  

  virtual void on_reset();
  virtual bool on_set_input(Speakers spk);
  virtual bool on_process();

public:
  BassRedir();

  
  

  
  inline bool get_enabled() const;
  inline void set_enabled(bool _enabled);

  
  inline double get_freq() const;
  inline void   set_freq(double _freq);

};





inline bool 
BassRedir::get_enabled() const
{
  return enabled;
}

inline void 
BassRedir::set_enabled(bool _enabled)
{
  if (_enabled && !enabled)
    lpf.reset();
  enabled = _enabled;
}

inline double 
BassRedir::get_freq() const
{
  return lpf.freq;
}

inline void 
BassRedir::set_freq(double _freq)
{
  lpf.freq = _freq;
  lpf.update();
}


#endif
