

#ifndef VALIB_DELAY_H
#define VALIB_DELAY_H

#include "../filter.h"
#include "../data.h"


#define DELAY_SP 0 
#define DELAY_MS 1 
#define DELAY_M  2 
#define DELAY_CM 3 
#define DELAY_FT 4 
#define DELAY_IN 5 

class Delay : public NullFilter
{
protected:
  bool  enabled;
  int   units;                    
  float delays[NCHANNELS];        

  SampleBuf buf;                  
  bool      first_half;           
  int       ch_delays[NCHANNELS]; 
  int       lag;                  

  double    units2samples(int _units);

  
  

  virtual void on_reset();
  virtual bool on_process();

public:
  Delay();

  inline bool get_enabled() const;
  inline void set_enabled(bool _enabled);

  int  get_units() const;
  void set_units(int units);

  void get_delays(float delays[NCHANNELS]) const;
  void set_delays(float delays[NCHANNELS]);
};


inline bool Delay::get_enabled() const
{ return enabled; }

inline void Delay::set_enabled(bool _enabled)
{ enabled = _enabled; }

#endif
