

#ifndef VALIB_DEMUX_H
#define VALIB_DEMUX_H

#include "../filter.h"
#include "../mpeg_demux.h"

class Demux : public NullFilter
{
protected:
  PSParser ps;          

  int    stream;        
  int    substream;     

  Speakers out_spk;
  uint8_t *out_rawdata;
  size_t   out_size;

  void process();

public:
  Demux();

  inline int get_stream()    const { return stream;    }
  inline int get_substream() const { return substream; }
    
  
  virtual void reset();
  virtual bool is_ofdd() const;
  virtual bool process(const Chunk *chunk);

  virtual Speakers get_output() const;
  virtual bool is_empty() const;
  virtual bool get_chunk(Chunk *chunk);
};

#endif
