

#ifndef VALIB_DITHER_H
#define VALIB_DITHER_H

#include <math.h>
#include "../filter.h"
#include "../rng.h"

class Dither : public NullFilter
{
public:
  double level;
  Dither(double level_ = 0.0): NullFilter(FORMAT_MASK_LINEAR), level(level_) {};

protected:
  RNG rng;

  virtual bool on_process()
  {
    if (level > 0.0)
    {
      if (EQUAL_SAMPLES(level * spk.level, 1.0))
      {
        
        for (int ch = 0; ch < spk.nch(); ch++)
          for (size_t s = 0; s < size; s++)
            samples[ch][s] += rng.get_sample();
      }
      else
      {
        
        double factor = level * spk.level;
        for (int ch = 0; ch < spk.nch(); ch++)
          for (size_t s = 0; s < size; s++)
            samples[ch][s] += rng.get_sample() * factor;
      }
    }
    return true;
  }
};

#endif
